/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.java;

import java.io.Serializable;
import java.util.EmptyStackException;

public class ContinuationStack
implements Serializable {
    private int[] istack;
    private float[] fstack;
    private double[] dstack;
    private long[] lstack;
    private Object[] astack;
    private Object[] tstack;
    private int iTop;
    private int fTop;
    private int dTop;
    private int lTop;
    private int aTop;
    private int tTop;

    public ContinuationStack() {
        this.istack = new int[10];
        this.lstack = new long[5];
        this.dstack = new double[5];
        this.fstack = new float[5];
        this.astack = new Object[10];
        this.tstack = new Object[5];
    }

    public ContinuationStack(ContinuationStack parent) {
        this.istack = new int[parent.istack.length];
        this.lstack = new long[parent.lstack.length];
        this.dstack = new double[parent.dstack.length];
        this.fstack = new float[parent.fstack.length];
        this.astack = new Object[parent.astack.length];
        this.tstack = new Object[parent.tstack.length];
        System.arraycopy(parent.istack, 0, this.istack, 0, parent.istack.length);
        System.arraycopy(parent.lstack, 0, this.lstack, 0, parent.lstack.length);
        System.arraycopy(parent.dstack, 0, this.dstack, 0, parent.dstack.length);
        System.arraycopy(parent.fstack, 0, this.fstack, 0, parent.fstack.length);
        System.arraycopy(parent.astack, 0, this.astack, 0, parent.astack.length);
        System.arraycopy(parent.tstack, 0, this.tstack, 0, parent.tstack.length);
        this.iTop = parent.iTop;
        this.fTop = parent.fTop;
        this.dTop = parent.dTop;
        this.lTop = parent.lTop;
        this.aTop = parent.aTop;
        this.tTop = parent.tTop;
    }

    public double popDouble() {
        if (this.dTop == 0) {
            throw new EmptyStackException();
        }
        double d = this.dstack[--this.dTop];
        return d;
    }

    public float popFloat() {
        if (this.fTop == 0) {
            throw new EmptyStackException();
        }
        float f = this.fstack[--this.fTop];
        return f;
    }

    public int popInt() {
        if (this.iTop == 0) {
            throw new EmptyStackException();
        }
        int i = this.istack[--this.iTop];
        return i;
    }

    public long popLong() {
        if (this.lTop == 0) {
            throw new EmptyStackException();
        }
        long l = this.lstack[--this.lTop];
        return l;
    }

    public Object popObject() {
        if (this.aTop == 0) {
            throw new EmptyStackException();
        }
        Object o = this.astack[--this.aTop];
        return o;
    }

    public Object popReference() {
        if (this.tTop == 0) {
            throw new EmptyStackException();
        }
        Object o = this.tstack[--this.tTop];
        return o;
    }

    public void pushDouble(double d) {
        this.dstack[this.dTop++] = d;
        if (this.dTop == this.dstack.length) {
            double[] hlp = new double[this.dstack.length + 10];
            System.arraycopy(this.dstack, 0, hlp, 0, this.dstack.length);
            this.dstack = hlp;
        }
    }

    public void pushFloat(float f) {
        this.fstack[this.fTop++] = f;
        if (this.fTop == this.fstack.length) {
            float[] hlp = new float[this.fstack.length + 10];
            System.arraycopy(this.fstack, 0, hlp, 0, this.fstack.length);
            this.fstack = hlp;
        }
    }

    public void pushInt(int i) {
        this.istack[this.iTop++] = i;
        if (this.iTop == this.istack.length) {
            int[] hlp = new int[this.istack.length + 10];
            System.arraycopy(this.istack, 0, hlp, 0, this.istack.length);
            this.istack = hlp;
        }
    }

    public void pushLong(long l) {
        this.lstack[this.lTop++] = l;
        if (this.lTop == this.lstack.length) {
            long[] hlp = new long[this.lstack.length + 10];
            System.arraycopy(this.lstack, 0, hlp, 0, this.lstack.length);
            this.lstack = hlp;
        }
    }

    public void pushObject(Object o) {
        this.astack[this.aTop++] = o;
        if (this.aTop == this.astack.length) {
            Object[] hlp = new Object[this.astack.length + 10];
            System.arraycopy(this.astack, 0, hlp, 0, this.astack.length);
            this.astack = hlp;
        }
    }

    public void pushReference(Object o) {
        this.tstack[this.tTop++] = o;
        if (this.tTop == this.tstack.length) {
            Object[] hlp = new Object[this.tstack.length + 10];
            System.arraycopy(this.tstack, 0, hlp, 0, this.tstack.length);
            this.tstack = hlp;
        }
    }

    public String toString() {
        return "i=" + this.iTop + ",l=" + this.lTop + ",d=" + this.dTop + ",f=" + this.fTop + ",a=" + this.aTop + ",t=" + this.tTop;
    }
}

