/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.flow.AbstractInterpreter;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.flow.InvalidContinuationException;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.flow.java.Continuable;
import org.apache.cocoon.components.flow.java.Continuation;
import org.apache.cocoon.components.flow.java.ContinuationClassLoader;
import org.apache.cocoon.components.flow.java.ContinuationContext;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.util.ReflectionUtils;
import org.apache.commons.jxpath.JXPathIntrospector;

public class JavaInterpreter
extends AbstractInterpreter
implements Configurable {
    private boolean initialized = false;
    private int timeToLive = 600000;
    public static final String USER_GLOBAL_SCOPE = "JAVA GLOBAL SCOPE";
    private ClassLoader classloader;
    private Map methods = new HashMap();
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$java$VarMap;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$java$VarMapHandler;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$java$Continuable;

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
    }

    public synchronized void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("initialize java flow interpreter");
            }
            this.classloader = new ContinuationClassLoader(Thread.currentThread().getContextClassLoader());
            Iterator scripts = this.needResolve.iterator();
            while (scripts.hasNext()) {
                String classname = (String)scripts.next();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("registered java class \"" + classname + "\" for flow");
                }
                if (!(class$org$apache$cocoon$components$flow$java$Continuable == null ? JavaInterpreter.class$("org.apache.cocoon.components.flow.java.Continuable") : class$org$apache$cocoon$components$flow$java$Continuable).isAssignableFrom(Class.forName(classname))) {
                    this.getLogger().error("java class \"" + classname + "\" doesn't implement Continuable");
                    continue;
                }
                Class<?> clazz = this.classloader.loadClass(classname);
                Map m = ReflectionUtils.discoverMethods(clazz);
                this.methods.putAll(m);
                this.initialized = true;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot initialize JavaInterpreter", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void callFunction(String function, List params, Redirector redirector) throws Exception {
        Request request;
        Session session;
        HashMap userScopes;
        Method method;
        if (!this.initialized) {
            this.initialize();
        }
        if ((method = (Method)this.methods.get(function)) == null) {
            throw new ProcessingException("No method '" + function + "' found. " + this.methods);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("calling method \"" + method + "\"");
        }
        if ((userScopes = (HashMap)(session = (request = ContextHelper.getRequest((Context)this.avalonContext)).getSession(true)).getAttribute(USER_GLOBAL_SCOPE)) == null) {
            userScopes = new HashMap();
        }
        Continuable flow = (Continuable)userScopes.get(method.getDeclaringClass());
        ContinuationContext context = new ContinuationContext();
        context.setObject(flow);
        context.setMethod(method);
        context.setAvalonContext(this.avalonContext);
        context.setLogger(this.getLogger());
        context.setServiceManager(this.manager);
        context.setRedirector(redirector);
        Parameters parameters = new Parameters();
        Iterator i = params.iterator();
        while (i.hasNext()) {
            Interpreter.Argument argument = (Interpreter.Argument)i.next();
            parameters.setParameter(argument.name, argument.value);
        }
        context.setParameters(parameters);
        Continuation continuation = new Continuation(context);
        WebContinuation wk = this.continuationsMgr.createWebContinuation((Object)continuation, null, this.timeToLive, this.getInterpreterID(), null);
        FlowHelper.setWebContinuation((Map)ContextHelper.getObjectModel((Context)this.avalonContext), (WebContinuation)wk);
        continuation.registerThread();
        try {
            try {
                if (flow == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("create new instance of \"" + method.getDeclaringClass() + "\"");
                    }
                    flow = (Continuable)method.getDeclaringClass().newInstance();
                    context.setObject(flow);
                }
                method.invoke((Object)flow, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                if (ite.getTargetException() == null) {
                    throw ite;
                }
                if (ite.getTargetException() instanceof Exception) {
                    throw (Exception)ite.getTargetException();
                }
                if (ite.getTargetException() instanceof Error) {
                    throw new ProcessingException("An internal error occured", ite.getTargetException());
                }
                if (ite.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)ite.getTargetException();
                }
                throw ite;
            }
            Object var16_14 = null;
            if (continuation.isCapturing()) {
                continuation.getStack().popReference();
            }
            continuation.deregisterThread();
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            if (continuation.isCapturing()) {
                continuation.getStack().popReference();
            }
            continuation.deregisterThread();
            throw throwable;
        }
        userScopes.put(method.getDeclaringClass(), flow);
        session.setAttribute(USER_GLOBAL_SCOPE, userScopes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleContinuation(String id, List params, Redirector redirector) throws Exception {
        WebContinuation parentwk;
        if (!this.initialized) {
            this.initialize();
        }
        if ((parentwk = this.continuationsMgr.lookupWebContinuation(id, this.getInterpreterID())) == null) {
            throw new InvalidContinuationException("The continuation ID " + id + " is invalid.");
        }
        Continuation parentContinuation = (Continuation)parentwk.getContinuation();
        ContinuationContext parentContext = (ContinuationContext)parentContinuation.getContext();
        ContinuationContext context = new ContinuationContext();
        context.setObject(parentContext.getObject());
        context.setMethod(parentContext.getMethod());
        context.setAvalonContext(this.avalonContext);
        context.setLogger(this.getLogger());
        context.setServiceManager(this.manager);
        context.setRedirector(redirector);
        Parameters parameters = new Parameters();
        Iterator i = params.iterator();
        while (i.hasNext()) {
            Interpreter.Argument argument = (Interpreter.Argument)i.next();
            parameters.setParameter(argument.name, argument.value);
        }
        context.setParameters(parameters);
        Continuation continuation = new Continuation(parentContinuation, context);
        Request request = ContextHelper.getRequest((Context)this.avalonContext);
        Session session = request.getSession(true);
        HashMap userScopes = (HashMap)session.getAttribute(USER_GLOBAL_SCOPE);
        Continuable flow = (Continuable)context.getObject();
        Method method = context.getMethod();
        WebContinuation wk = this.continuationsMgr.createWebContinuation((Object)continuation, parentwk, this.timeToLive, this.getInterpreterID(), null);
        FlowHelper.setWebContinuation((Map)ContextHelper.getObjectModel((Context)this.avalonContext), (WebContinuation)wk);
        continuation.registerThread();
        try {
            try {
                method.invoke((Object)flow, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                if (ite.getTargetException() == null) {
                    throw ite;
                }
                if (ite.getTargetException() instanceof Exception) {
                    throw (Exception)ite.getTargetException();
                }
                if (ite.getTargetException() instanceof Error) {
                    throw new ProcessingException("An internal error occured", ite.getTargetException());
                }
                if (ite.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)ite.getTargetException();
                }
                throw ite;
            }
            Object var19_17 = null;
            if (continuation.isCapturing()) {
                continuation.getStack().popReference();
            }
            continuation.deregisterThread();
        }
        catch (Throwable throwable) {
            Object var19_18 = null;
            if (continuation.isCapturing()) {
                continuation.getStack().popReference();
            }
            continuation.deregisterThread();
            throw throwable;
        }
        userScopes.put(method.getDeclaringClass(), flow);
        session.setAttribute(USER_GLOBAL_SCOPE, (Object)userScopes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JXPathIntrospector.registerDynamicClass((Class)(class$org$apache$cocoon$components$flow$java$VarMap == null ? (class$org$apache$cocoon$components$flow$java$VarMap = JavaInterpreter.class$("org.apache.cocoon.components.flow.java.VarMap")) : class$org$apache$cocoon$components$flow$java$VarMap), (Class)(class$org$apache$cocoon$components$flow$java$VarMapHandler == null ? (class$org$apache$cocoon$components$flow$java$VarMapHandler = JavaInterpreter.class$("org.apache.cocoon.components.flow.java.VarMapHandler")) : class$org$apache$cocoon$components$flow$java$VarMapHandler));
    }
}

