/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.midi.xmidi;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.midi.xmidi.ByteLen;

public final class Utils {
    public static final String VERSION = "1.2";

    public static byte[] hexToBa(String h, int len) throws ProcessingException {
        int l = h.length();
        int cnt = 0;
        int bs = 0;
        int bc = 0;
        byte[] ba = new byte[len];
        for (int i = 0; i < l; ++i) {
            String s = h.substring(i, i + 1);
            int x = " \n\t\r".indexOf(s);
            if (x != -1) continue;
            int tmp = "0123456789ABCDEF".indexOf(s.toUpperCase());
            if (bc == 0) {
                bs = tmp;
            } else if (bc == 1) {
                bs <<= 4;
                bs |= tmp;
            } else {
                throw new ProcessingException("hexToBa: internal error");
            }
            if (++bc < 2) continue;
            ba[cnt] = (byte)bs;
            ++cnt;
            bc = 0;
        }
        if (bc != 0) {
            throw new ProcessingException("un-even number of hex digits");
        }
        if (cnt != len) {
            throw new ProcessingException("hexToBa: count (" + cnt + ") != length (" + len + ")");
        }
        return ba;
    }

    public static String baToString(byte[] b, int strt, int end) {
        int l = end - strt + 1;
        char[] c = new char[l];
        for (int j = 0; j < l; ++j) {
            c[j] = (char)b[j];
        }
        return new String(c);
    }

    public static String baToHex(byte[] b, int strt, int end) throws ProcessingException {
        int l = end - strt + 1;
        if (b.length < end) {
            throw new ProcessingException("baToHex: length error; b.length=" + b.length + ", strt=" + strt + ", end=" + end + ", l=" + l);
        }
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < l; ++i) {
            int t = Utils.getUnsignedByte(b[strt + i]);
            int a = t / 16;
            int aa = t % 16;
            sb.append("0123456789ABCDEF".substring(a, a + 1));
            sb.append("0123456789ABCDEF".substring(aa, aa + 1));
        }
        return sb.toString();
    }

    public static byte[] intToBa(int n, int c) throws ProcessingException {
        byte[] b = new byte[c];
        int t = n;
        for (int i = 0; i < c; ++i) {
            int j = c - i - 1;
            int k = t % 256;
            b[j] = (byte)k;
            t /= 256;
        }
        if (t > 0) {
            throw new ProcessingException("intToBa: t is " + t + ", n = " + n + ", c = " + c);
        }
        return b;
    }

    public static int baToInt(byte[] b, int strt, int end) throws ProcessingException {
        if (end > b.length - 1) {
            throw new ProcessingException("baToInt: strt = " + strt + ", end = " + end + ", b.length = " + b.length);
        }
        int l = end - strt + 1;
        int i = 0;
        for (int j = 0; j < l; ++j) {
            int p = strt + l - j - 1;
            if (p > b.length - 1) {
                throw new ProcessingException("baToInt: p = " + p + ", strt = " + strt + ", end = " + end + ", l = " + l + ", j = " + j + ", i = " + i);
            }
            int k = Utils.getUnsignedByte(b[p]);
            int n = Utils.pow(256, j);
            i += n * k;
        }
        return i;
    }

    public static int getUnsignedByte(byte b) {
        int t = 0;
        if ((b & 0x80) == 128) {
            t = 1;
        }
        int k = b = (byte)(b & 0x7F);
        return k += t * 128;
    }

    public static ByteLen deltaToInt(byte[] b, int offset) throws ProcessingException {
        int j = 0;
        byte[] ba = new byte[4];
        boolean jFlag = true;
        while (jFlag) {
            if (j + offset > b.length) {
                throw new ProcessingException("deltaToInt: length error; j = " + j + ", offset = " + offset + ", b.length = " + b.length);
            }
            ba[j] = b[j + offset];
            if (ba[j] >= 0) {
                jFlag = false;
            } else {
                int n = j;
                ba[n] = (byte)(ba[n] & 0x7F);
            }
            ++j;
        }
        int s = 0;
        for (int i = 0; i < j; ++i) {
            int k = j - i - 1;
            int p = Utils.pow(128, i);
            byte m = ba[k];
            s += m * p;
        }
        ByteLen bl = new ByteLen(Utils.intToBa(s, 4), j);
        return bl;
    }

    public static int pow(int b, int e) {
        int a = 1;
        for (int i = 0; i < e; ++i) {
            a *= b;
        }
        return a;
    }

    public static int getPW(byte[] dta, int offset) throws ProcessingException {
        int hi = Utils.baToInt(dta, offset, offset);
        int lo = Utils.baToInt(dta, offset + 1, offset + 1);
        return lo |= (hi <<= 7);
    }

    public static int getNextHiOrd(byte[] dta, int offset) throws ProcessingException {
        int ol = 0;
        boolean tflag = true;
        for (int o = offset + 1; o < dta.length - 1; ++o) {
            int x;
            if (!tflag || ((x = Utils.baToInt(dta, o, o)) & 0x80) != 128) continue;
            tflag = false;
            ol = o;
        }
        if (tflag) {
            ol = offset + dta.length;
        }
        return ol;
    }

    public static byte[] intToDelta(byte[] t) throws ProcessingException {
        int k;
        int i1 = Utils.baToInt(t, 0, t.length - 1);
        if (i1 == 0) {
            byte[] b = new byte[]{0};
            return b;
        }
        int i2 = i1;
        byte[] b1 = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int j = 4 - i - 1;
            k = i2 % 128;
            i2 /= 128;
            b1[j] = (byte)k;
        }
        int j = -1;
        boolean bFlag = false;
        for (int i = 0; i < 4; ++i) {
            if (bFlag || b1[i] == 0) continue;
            j = i;
            bFlag = true;
        }
        k = 4 - j;
        byte[] b2 = new byte[k];
        for (int i = 0; i < k; ++i) {
            b2[i] = b1[i + j];
            if (i == k - 1) continue;
            int n = i;
            b2[n] = (byte)(b2[n] | 0x80);
        }
        return b2;
    }

    public static int stringToInt(String s) {
        Integer i = new Integer(s);
        int r = i;
        return r;
    }
}

