/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.midi.xmidi.ByteLen;
import org.apache.cocoon.components.midi.xmidi.Utils;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMidiGenerator
extends AbstractGenerator
implements Parameterizable {
    protected Source inputSource;
    private boolean global_verbose;
    private boolean local_verbose;
    private static final boolean VERBOSE_DEFAULT = true;
    private int midiFormat;
    private Hashtable ffHash;
    private String[] chanArray;
    private String[] fArray;
    private int numTracks;
    private int trkCount;
    private String[] notes;
    private int[] register;
    private Hashtable contHash;

    private boolean validateVerbosity(String verbose) {
        if (verbose.equalsIgnoreCase("TRUE")) {
            return true;
        }
        return !verbose.equalsIgnoreCase("FALSE");
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.global_verbose = this.validateVerbosity(parameters.getParameter("verbose", String.valueOf(true)));
    }

    public void recycle() {
        if (null != this.inputSource) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        this.initializeVariables();
        super.recycle();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.initializeLookupTables();
        try {
            this.inputSource = resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Error resolving '" + src + "'."), (SourceException)se);
        }
        this.local_verbose = this.validateVerbosity(this.parameters.getParameter("verbose", String.valueOf(this.global_verbose)));
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.inputSource.getValidity();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("processing file " + this.source);
                this.getLogger().debug("file resolved to " + this.inputSource.getURI());
            }
            this.parseMIDI(this.inputSource, this.xmlConsumer);
        }
        catch (SAXException e) {
            Exception cause = e.getException();
            if (cause != null) {
                if (cause instanceof ProcessingException) {
                    throw (ProcessingException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SAXException) {
                    throw (SAXException)cause;
                }
                throw new ProcessingException("Could not read resource " + this.inputSource.getURI(), (Throwable)cause);
            }
            throw e;
        }
    }

    private void parseMIDI(Source source, XMLConsumer consumer) throws SAXException, SourceNotFoundException, IOException, ProcessingException {
        InputStream inputStream = source.getInputStream();
        AttributesImpl attr = new AttributesImpl();
        String text = "";
        this.contentHandler.startDocument();
        attr.addAttribute("", "VERSION", "VERSION", "CDATA", "1.2");
        this.contentHandler.startElement("", "XMidi", "XMidi", attr);
        boolean chunkFlag = true;
        while (chunkFlag) {
            byte[] hdr = new byte[8];
            int r = inputStream.read(hdr);
            if (r == -1) {
                chunkFlag = false;
                continue;
            }
            if (r < 8) {
                this.getLogger().debug("Getting header");
            }
            String cid = Utils.baToString(hdr, 0, 3);
            int len = Utils.baToInt(hdr, 4, 7);
            byte[] dta = new byte[len];
            r = inputStream.read(dta);
            if (r < len) {
                throw new ProcessingException("Getting data");
            }
            if (cid.equals("MThd")) {
                attr.clear();
                attr.addAttribute("", "LENGTH", "LENGTH", "CDATA", "" + len);
                attr.addAttribute("", "TYPE", "TYPE", "CDATA", cid);
                this.contentHandler.startElement("", "MThd", "MThd", attr);
                this.midiFormat = Utils.baToInt(dta, 0, 1);
                this.numTracks = Utils.baToInt(dta, 2, 3);
                String pnq = Utils.baToHex(dta, 4, 5);
                attr.clear();
                this.contentHandler.startElement("", "FORMAT", "FORMAT", attr);
                text = "" + this.midiFormat;
                this.contentHandler.characters(text.toCharArray(), 0, text.length());
                this.contentHandler.endElement("", "FORMAT", "FORMAT");
                this.contentHandler.startElement("", "TRACKS", "TRACKS", attr);
                text = "" + this.numTracks;
                this.contentHandler.characters(text.toCharArray(), 0, text.length());
                this.contentHandler.endElement("", "TRACKS", "TRACKS");
                this.contentHandler.startElement("", "PPNQ", "PPNQ", attr);
                text = pnq;
                this.contentHandler.characters(text.toCharArray(), 0, text.length());
                this.contentHandler.endElement("", "PPNQ", "PPNQ");
                this.contentHandler.endElement("", "MThd", "MThd");
                continue;
            }
            if (cid.equals("MTrk")) {
                ++this.trkCount;
                if (this.trkCount > this.numTracks) {
                    throw new ProcessingException("too many tracks");
                }
                attr.clear();
                attr.addAttribute("", "LENGTH", "LENGTH", "CDATA", "" + len);
                attr.addAttribute("", "TYPE", "TYPE", "CDATA", cid);
                this.contentHandler.startElement("", "MTrk", "MTrk", attr);
                this.doTrack(dta, len);
                this.contentHandler.endElement("", "MTrk", "MTrk");
                continue;
            }
            attr.clear();
            attr.addAttribute("", "LENGTH", "LENGTH", "CDATA", "" + len);
            attr.addAttribute("", "TYPE", "TYPE", "CDATA", cid);
            this.contentHandler.startElement("", "CHUNK", "CHUNK", attr);
            this.doHexData(dta, len);
            this.contentHandler.endElement("", "CHUNK", "CHUNK");
        }
        this.contentHandler.endElement("", "XMidi", "XMidi");
        this.contentHandler.endDocument();
    }

    void initializeVariables() {
        this.numTracks = 0;
        this.trkCount = 0;
    }

    void initializeLookupTables() {
        this.ffHash = new Hashtable();
        this.ffHash.put("00", "Sequence Number");
        this.ffHash.put("01", "Text");
        this.ffHash.put("02", "Copyright");
        this.ffHash.put("03", "Sequence/Track Name");
        this.ffHash.put("04", "Instrument");
        this.ffHash.put("05", "Lyric");
        this.ffHash.put("06", "Marker");
        this.ffHash.put("07", "Cue Point");
        this.ffHash.put("20", "MIDI Channel");
        this.ffHash.put("21", "MIDI Port");
        this.ffHash.put("2F", "End of Track");
        this.ffHash.put("51", "Tempo");
        this.ffHash.put("54", "SMPTE Offset");
        this.ffHash.put("58", "Time Signature");
        this.ffHash.put("59", "Key Signature");
        this.ffHash.put("7F", "Proprietary Event");
        this.chanArray = new String[7];
        this.chanArray[0] = "Note Off";
        this.chanArray[1] = "Note On";
        this.chanArray[2] = "After Touch";
        this.chanArray[3] = "Control Change";
        this.chanArray[4] = "Program Change";
        this.chanArray[5] = "Channel Pressure";
        this.chanArray[6] = "Pitch Wheel";
        this.fArray = new String[16];
        this.fArray[0] = "SYSEX";
        this.fArray[1] = "MTC Quarter Frame Message";
        this.fArray[2] = "Song Position Pointer";
        this.fArray[3] = "Song Select";
        this.fArray[4] = "Undefined";
        this.fArray[5] = "Undefined";
        this.fArray[6] = "Tune Request";
        this.fArray[7] = "Unsupported";
        this.fArray[8] = "MIDI Clock";
        this.fArray[9] = "Undefined";
        this.fArray[10] = "MIDI Start";
        this.fArray[11] = "MIDI Continue";
        this.fArray[12] = "MIDI Stop";
        this.fArray[13] = "Undefined";
        this.fArray[14] = "Active Sense";
        this.fArray[15] = "NotUnderstood";
        this.contHash = new Hashtable();
        this.contHash.put("0", "Bank Select");
        this.contHash.put("1", "Modulation Wheel (coarse)");
        this.contHash.put("2", "Breath controller (coarse)");
        this.contHash.put("4", "Foot Pedal (coarse)");
        this.contHash.put("5", "Portamento Time (coarse)");
        this.contHash.put("6", "Data Entry (coarse)");
        this.contHash.put("7", "Volume (coarse)");
        this.contHash.put("8", "Balance (coarse)");
        this.contHash.put("10", "Pan position (coarse)");
        this.contHash.put("11", "Expression (coarse)");
        this.contHash.put("12", "Effect Control 1 (coarse)");
        this.contHash.put("13", "Effect Control 2 (coarse)");
        this.contHash.put("16", "General Purpose Slider 1");
        this.contHash.put("17", "General Purpose Slider 2");
        this.contHash.put("18", "General Purpose Slider 3");
        this.contHash.put("19", "General Purpose Slider 4");
        this.contHash.put("32", "Bank Select (fine)");
        this.contHash.put("33", "Modulation Wheel (fine)");
        this.contHash.put("34", "Breath controller (fine)");
        this.contHash.put("36", "Foot Pedal (fine)");
        this.contHash.put("37", "Portamento Time (fine)");
        this.contHash.put("38", "Data Entry (fine)");
        this.contHash.put("39", "Volume (fine)");
        this.contHash.put("40", "Balance (fine)");
        this.contHash.put("42", "Pan position (fine)");
        this.contHash.put("43", "Expression (fine)");
        this.contHash.put("44", "Effect Control 1 (fine)");
        this.contHash.put("45", "Effect Control 2 (fine)");
        this.contHash.put("64", "Hold Pedal (on/off)");
        this.contHash.put("65", "Portamento (on/off)");
        this.contHash.put("66", "Sustenuto Pedal (on/off)");
        this.contHash.put("67", "Soft Pedal (on/off)");
        this.contHash.put("68", "Legato Pedal (on/off)");
        this.contHash.put("69", "Hold 2 Pedal (on/off)");
        this.contHash.put("70", "Sound Variation");
        this.contHash.put("71", "Sound Timbre");
        this.contHash.put("72", "Sound Release Time");
        this.contHash.put("73", "Sound Attack Time");
        this.contHash.put("74", "Sound Brightness");
        this.contHash.put("75", "Sound Control 6");
        this.contHash.put("76", "Sound Control 7");
        this.contHash.put("77", "Sound Control 8");
        this.contHash.put("78", "Sound Control 9");
        this.contHash.put("79", "Sound Control 10");
        this.contHash.put("80", "General Purpose Button 1 (on/off)");
        this.contHash.put("81", "General Purpose Button 2 (on/off)");
        this.contHash.put("82", "General Purpose Button 3 (on/off)");
        this.contHash.put("83", "General Purpose Button 4 (on/off)");
        this.contHash.put("91", "Effects Level");
        this.contHash.put("92", "Tremulo Level");
        this.contHash.put("93", "Chorus Level");
        this.contHash.put("94", "Celeste Level");
        this.contHash.put("95", "Phaser Level");
        this.contHash.put("96", "Data Button increment");
        this.contHash.put("97", "Data Button decrement");
        this.contHash.put("98", "Non-registered Parameter (fine)");
        this.contHash.put("99", "Non-registered Parameter (coarse)");
        this.contHash.put("100", "Registered Parameter (fine)");
        this.contHash.put("101", "Registered Parameter (coarse)");
        this.contHash.put("120", "All Sound Off");
        this.contHash.put("121", "All Controllers Off");
        this.contHash.put("122", "Local Keyboard (on/off)");
        this.contHash.put("123", "All Notes Off");
        this.contHash.put("124", "Omni Mode Off");
        this.contHash.put("125", "Omni Mode On");
        this.contHash.put("126", "Mono Operation");
        this.contHash.put("127", "Poly Operation");
        this.notes = new String[128];
        this.register = new int[128];
        this.notes[0] = "C";
        this.register[0] = -5;
        this.notes[1] = "C#";
        this.register[1] = -5;
        this.notes[2] = "D";
        this.register[2] = -5;
        this.notes[3] = "Eb";
        this.register[3] = -5;
        this.notes[4] = "E";
        this.register[4] = -5;
        this.notes[5] = "F";
        this.register[5] = -5;
        this.notes[6] = "F#";
        this.register[6] = -5;
        this.notes[7] = "G";
        this.register[7] = -5;
        this.notes[8] = "Ab";
        this.register[8] = -5;
        this.notes[9] = "A";
        this.register[9] = -5;
        this.notes[10] = "Bb";
        this.register[10] = -5;
        this.notes[11] = "B";
        this.register[11] = -5;
        this.notes[12] = "C";
        this.register[12] = -4;
        this.notes[13] = "C#";
        this.register[13] = -4;
        this.notes[14] = "D";
        this.register[14] = -4;
        this.notes[15] = "Eb";
        this.register[15] = -4;
        this.notes[16] = "E";
        this.register[16] = -4;
        this.notes[17] = "F";
        this.register[17] = -4;
        this.notes[18] = "F#";
        this.register[18] = -4;
        this.notes[19] = "G";
        this.register[19] = -4;
        this.notes[20] = "Ab";
        this.register[20] = -4;
        this.notes[21] = "A";
        this.register[21] = -4;
        this.notes[22] = "Bb";
        this.register[22] = -4;
        this.notes[23] = "B";
        this.register[23] = -4;
        this.notes[24] = "C";
        this.register[24] = -3;
        this.notes[25] = "C#";
        this.register[25] = -3;
        this.notes[26] = "D";
        this.register[26] = -3;
        this.notes[27] = "Eb";
        this.register[27] = -3;
        this.notes[28] = "E";
        this.register[28] = -3;
        this.notes[29] = "F";
        this.register[29] = -3;
        this.notes[30] = "F#";
        this.register[30] = -3;
        this.notes[31] = "G";
        this.register[31] = -3;
        this.notes[32] = "Ab";
        this.register[32] = -3;
        this.notes[33] = "A";
        this.register[33] = -3;
        this.notes[34] = "Bb";
        this.register[34] = -3;
        this.notes[35] = "B";
        this.register[35] = -3;
        this.notes[36] = "C";
        this.register[36] = -2;
        this.notes[37] = "C#";
        this.register[37] = -2;
        this.notes[38] = "D";
        this.register[38] = -2;
        this.notes[39] = "Eb";
        this.register[39] = -2;
        this.notes[40] = "E";
        this.register[40] = -2;
        this.notes[41] = "F";
        this.register[41] = -2;
        this.notes[42] = "F#";
        this.register[42] = -2;
        this.notes[43] = "G";
        this.register[43] = -2;
        this.notes[44] = "Ab";
        this.register[44] = -2;
        this.notes[45] = "A";
        this.register[45] = -2;
        this.notes[46] = "Bb";
        this.register[46] = -2;
        this.notes[47] = "B";
        this.register[47] = -2;
        this.notes[48] = "C";
        this.register[48] = -1;
        this.notes[49] = "C#";
        this.register[49] = -1;
        this.notes[50] = "D";
        this.register[50] = -1;
        this.notes[51] = "Eb";
        this.register[51] = -1;
        this.notes[52] = "E";
        this.register[52] = -1;
        this.notes[53] = "F";
        this.register[53] = -1;
        this.notes[54] = "F#";
        this.register[54] = -1;
        this.notes[55] = "G";
        this.register[55] = -1;
        this.notes[56] = "Ab";
        this.register[56] = -1;
        this.notes[57] = "A";
        this.register[57] = -1;
        this.notes[58] = "Bb";
        this.register[58] = -1;
        this.notes[59] = "B";
        this.register[59] = -1;
        this.notes[60] = "C";
        this.register[60] = 0;
        this.notes[61] = "C#";
        this.register[61] = 0;
        this.notes[62] = "D";
        this.register[62] = 0;
        this.notes[63] = "Eb";
        this.register[63] = 0;
        this.notes[64] = "E";
        this.register[64] = 0;
        this.notes[65] = "F";
        this.register[65] = 0;
        this.notes[66] = "F#";
        this.register[66] = 0;
        this.notes[67] = "G";
        this.register[67] = 0;
        this.notes[68] = "Ab";
        this.register[68] = 0;
        this.notes[69] = "A";
        this.register[69] = 0;
        this.notes[70] = "Bb";
        this.register[70] = 0;
        this.notes[71] = "B";
        this.register[71] = 0;
        this.notes[72] = "C";
        this.register[72] = 1;
        this.notes[73] = "C#";
        this.register[73] = 1;
        this.notes[74] = "D";
        this.register[74] = 1;
        this.notes[75] = "Eb";
        this.register[75] = 1;
        this.notes[76] = "E";
        this.register[76] = 1;
        this.notes[77] = "F";
        this.register[77] = 1;
        this.notes[78] = "F#";
        this.register[78] = 1;
        this.notes[79] = "G";
        this.register[79] = 1;
        this.notes[80] = "Ab";
        this.register[80] = 1;
        this.notes[81] = "A";
        this.register[81] = 1;
        this.notes[82] = "Bb";
        this.register[82] = 1;
        this.notes[83] = "B";
        this.register[83] = 1;
        this.notes[84] = "C";
        this.register[84] = 2;
        this.notes[85] = "C#";
        this.register[85] = 2;
        this.notes[86] = "D";
        this.register[86] = 2;
        this.notes[87] = "Eb";
        this.register[87] = 2;
        this.notes[88] = "E";
        this.register[88] = 2;
        this.notes[89] = "F";
        this.register[89] = 2;
        this.notes[90] = "F#";
        this.register[90] = 2;
        this.notes[91] = "G";
        this.register[91] = 2;
        this.notes[92] = "Ab";
        this.register[92] = 2;
        this.notes[93] = "A";
        this.register[93] = 2;
        this.notes[94] = "Bb";
        this.register[94] = 2;
        this.notes[95] = "B";
        this.register[95] = 2;
        this.notes[96] = "C";
        this.register[96] = 3;
        this.notes[97] = "C#";
        this.register[97] = 3;
        this.notes[98] = "D";
        this.register[98] = 3;
        this.notes[99] = "Eb";
        this.register[99] = 3;
        this.notes[100] = "E";
        this.register[100] = 3;
        this.notes[101] = "F";
        this.register[101] = 3;
        this.notes[102] = "F#";
        this.register[102] = 3;
        this.notes[103] = "G";
        this.register[103] = 3;
        this.notes[104] = "Ab";
        this.register[104] = 3;
        this.notes[105] = "A";
        this.register[105] = 3;
        this.notes[106] = "Bb";
        this.register[106] = 3;
        this.notes[107] = "B";
        this.register[107] = 3;
        this.notes[108] = "C";
        this.register[108] = 4;
        this.notes[109] = "C#";
        this.register[109] = 4;
        this.notes[110] = "D";
        this.register[110] = 4;
        this.notes[111] = "Eb";
        this.register[111] = 4;
        this.notes[112] = "E";
        this.register[112] = 4;
        this.notes[113] = "F";
        this.register[113] = 4;
        this.notes[114] = "F#";
        this.register[114] = 4;
        this.notes[115] = "G";
        this.register[115] = 4;
        this.notes[116] = "Ab";
        this.register[116] = 4;
        this.notes[117] = "A";
        this.register[117] = 4;
        this.notes[118] = "Bb";
        this.register[118] = 4;
        this.notes[119] = "B";
        this.register[119] = 4;
        this.notes[120] = "C";
        this.register[120] = 5;
        this.notes[121] = "C#";
        this.register[121] = 5;
        this.notes[122] = "D";
        this.register[122] = 5;
        this.notes[123] = "Eb";
        this.register[123] = 5;
        this.notes[124] = "E";
        this.register[124] = 5;
        this.notes[125] = "F";
        this.register[125] = 5;
        this.notes[126] = "F#";
        this.register[126] = 5;
        this.notes[127] = "G";
        this.register[127] = 5;
    }

    void doTrack(byte[] dta, int len) throws SAXException, ProcessingException {
        AttributesImpl attr = new AttributesImpl();
        String text = "";
        boolean tFlag = true;
        int offset = 0;
        String edata = null;
        String snam = null;
        String nmData = "";
        String ctag = null;
        String[] ctagAttr = new String[4];
        String[] ctagAttrVal = new String[4];
        int ctagnum = 0;
        String cnum = null;
        String ctyp = null;
        int slen = 0;
        int chanType = 0;
        int hiName = 0;
        int status = 0;
        int noff = 0;
        String sval = null;
        boolean ecFlag = true;
        boolean nFlag = true;
        boolean firstTime = true;
        while (tFlag) {
            ByteLen bl = Utils.deltaToInt(dta, offset);
            String deltaLen = Utils.baToHex(bl.ba, 0, 3);
            nFlag = true;
            boolean statFlag = false;
            int first = Utils.baToInt(dta, offset += bl.len, offset);
            this.getLogger().debug("doTrack: in loop; deltaLen=" + deltaLen + ", len=" + bl.len + ", first=" + first);
            if ((first & 0x80) == 128) {
                statFlag = true;
                sval = Utils.baToHex(dta, offset, offset);
                status = first;
                this.getLogger().debug("doTrack: have status: " + sval);
                if (status < 240 && status > 127) {
                    ecFlag = false;
                    chanType = (status - 128) / 16;
                    snam = this.chanArray[chanType];
                    ctyp = sval.substring(0, 1);
                    cnum = sval.substring(1, 2);
                } else {
                    ecFlag = true;
                    if (status > 239 && status < 256) {
                        hiName = status - 240;
                        snam = this.fArray[hiName];
                    } else {
                        throw new ProcessingException("Invalid status: " + status);
                    }
                }
                ++offset;
            } else {
                this.getLogger().debug("doTrack: running status");
            }
            nmData = "";
            if (firstTime) {
                firstTime = false;
                if (!statFlag) {
                    throw new ProcessingException("first time, but no status; first = " + first);
                }
            }
            attr.clear();
            attr.addAttribute("", "DTIME", "DTIME", "CDATA", "" + deltaLen);
            this.contentHandler.startElement("", "DELTA", "DELTA", attr);
            if (status > 127 && status < 144) {
                slen = 2;
                int pitch = Utils.baToInt(dta, offset, offset);
                int vel = Utils.baToInt(dta, offset + 1, offset + 1);
                ctag = "NOTE_OFF";
                ctagAttr[0] = "PITCH";
                ctagAttrVal[0] = "" + pitch;
                ctagAttr[1] = "VELOCITY";
                ctagAttrVal[1] = "" + vel;
                ctagnum = 2;
                if (this.local_verbose) {
                    ctagAttr[2] = "NAME";
                    ctagAttrVal[2] = this.notes[pitch];
                    ctagAttr[3] = "REGISTER";
                    ctagAttrVal[3] = "" + this.register[pitch];
                    ctagnum = 4;
                }
            } else if (status > 143 && status < 160) {
                slen = 2;
                int pitch = Utils.baToInt(dta, offset, offset);
                int vel = Utils.baToInt(dta, offset + 1, offset + 1);
                ctag = "NOTE_ON";
                ctagAttr[0] = "PITCH";
                ctagAttrVal[0] = "" + pitch;
                ctagAttr[1] = "VELOCITY";
                ctagAttrVal[1] = "" + vel;
                ctagnum = 2;
                if (this.local_verbose) {
                    ctagAttr[2] = "NAME";
                    ctagAttrVal[2] = this.notes[pitch];
                    ctagAttr[3] = "REGISTER";
                    ctagAttrVal[3] = "" + this.register[pitch];
                    ctagnum = 4;
                }
            } else if (status > 159 && status < 176) {
                slen = 2;
                int pitch = Utils.baToInt(dta, offset, offset);
                int pres = Utils.baToInt(dta, offset + 1, offset + 1);
                ctag = "AFTER";
                ctagAttr[0] = "PITCH";
                ctagAttrVal[0] = "" + pitch;
                ctagAttr[1] = "PRESSURE";
                ctagAttrVal[1] = "" + pres;
                ctagnum = 2;
                if (this.local_verbose) {
                    ctagAttr[2] = "NAME";
                    ctagAttrVal[2] = this.notes[pitch];
                    ctagAttr[3] = "REGISTER";
                    ctagAttrVal[3] = "" + this.register[pitch];
                    ctagnum = 4;
                }
            } else if (status > 175 && status < 192) {
                slen = 2;
                int contnum = Utils.baToInt(dta, offset, offset);
                int contval = Utils.baToInt(dta, offset + 1, offset + 1);
                ctag = "CONTROL";
                ctagAttr[0] = "NUMBER";
                ctagAttrVal[0] = "" + contnum;
                ctagAttr[1] = "VALUE";
                ctagAttrVal[1] = "" + contval;
                ctagnum = 2;
                if (this.local_verbose) {
                    ctagAttr[2] = "NAME";
                    ctagAttrVal[2] = (String)this.contHash.get("" + contnum);
                    ctagnum = 3;
                }
            } else if (status > 191 && status < 208) {
                slen = 1;
                int patch = Utils.baToInt(dta, offset, offset);
                ctag = "PROGRAM";
                ctagAttr[0] = "NUMBER";
                ctagAttrVal[0] = "" + patch;
                ctagnum = 1;
            } else if (status > 207 && status < 224) {
                slen = 1;
                int pamt = Utils.baToInt(dta, offset, offset);
                ctag = "PRESSURE";
                ctagAttr[0] = "AMOUNT";
                ctagAttrVal[0] = "" + pamt;
                ctagnum = 1;
            } else if (status > 223 && status < 240) {
                slen = 2;
                int pwamt = Utils.getPW(dta, offset);
                ctag = "WHEEL";
                ctagAttr[0] = "AMOUNT";
                ctagAttrVal[0] = "" + pwamt;
                ctagnum = 1;
            } else if (status == 240) {
                bl = Utils.deltaToInt(dta, offset);
                slen = Utils.baToInt(bl.ba, 0, 3);
                noff = bl.len;
                nFlag = false;
                edata = Utils.baToHex(dta, offset + noff, offset + noff + slen - 1);
                noff += slen;
            } else if (status == 255) {
                nmData = Utils.baToHex(dta, offset, offset);
                snam = "non-MIDI";
                String nmNam = (String)this.ffHash.get(nmData);
                snam = nmNam != null ? snam + " - " + nmNam : snam + " - Unknown";
                bl = Utils.deltaToInt(dta, offset + 1);
                slen = Utils.baToInt(bl.ba, 0, 3);
                noff = bl.len + 1;
                nFlag = false;
                if (slen == 0) {
                    edata = "No data";
                } else {
                    edata = Utils.baToHex(dta, offset + noff, offset + noff + slen - 1);
                    noff += slen;
                }
                this.getLogger().debug("doTrack: status FF" + nmData + ", edata = " + edata);
            } else if (status == 241 || status == 243) {
                byte tcv = dta[offset];
                Integer tc = new Integer(tcv);
                edata = tc.toString();
                slen = 1;
            } else if (status == 242) {
                int tcv = Utils.getPW(dta, offset);
                Integer tc = new Integer(tcv);
                edata = tc.toString();
                slen = 2;
            } else if (status == 246 || status == 248 || status == 250 || status == 251 || status == 252 || status == 254) {
                edata = "No data for " + snam;
                slen = 0;
            } else {
                int ol = Utils.getNextHiOrd(dta, offset);
                edata = Utils.baToHex(dta, offset + 1, ol);
                slen = ol -= offset + 1;
            }
            if (ecFlag) {
                if (statFlag) {
                    attr.clear();
                    attr.addAttribute("", "SLEN", "SLEN", "CDATA", "" + slen);
                    attr.addAttribute("", "SNAM", "SNAM", "CDATA", snam);
                    if (!nmData.equals("")) {
                        attr.addAttribute("", "SNMT", "SNMT", "CDATA", nmData);
                    }
                    attr.addAttribute("", "SVAL", "SVAL", "CDATA", sval);
                    this.contentHandler.startElement("", "STATUS", "STATUS", attr);
                    attr.clear();
                    this.contentHandler.startElement("", "EDATA", "EDATA", attr);
                    text = edata;
                    this.contentHandler.characters(text.toCharArray(), 0, text.length());
                    this.contentHandler.endElement("", "EDATA", "EDATA");
                    this.contentHandler.endElement("", "STATUS", "STATUS");
                } else {
                    attr.clear();
                    this.contentHandler.startElement("", "EDATA", "EDATA", attr);
                    text = edata;
                    this.contentHandler.characters(text.toCharArray(), 0, text.length());
                    this.contentHandler.endElement("", "EDATA", "EDATA");
                }
            } else if (statFlag) {
                attr.clear();
                attr.addAttribute("", "SLEN", "SLEN", "CDATA", "" + slen);
                attr.addAttribute("", "SNAM", "SNAM", "CDATA", snam);
                if (!nmData.equals("")) {
                    attr.addAttribute("", "SNMT", "SNMT", "CDATA", nmData);
                }
                attr.addAttribute("", "SVAL", "SVAL", "CDATA", sval);
                this.contentHandler.startElement("", "STATUS", "STATUS", attr);
                attr.clear();
                attr.addAttribute("", "NUMBER", "NUMBER", "CDATA", cnum);
                attr.addAttribute("", "TYPE", "TYPE", "CDATA", ctyp);
                this.contentHandler.startElement("", "CHANNEL", "CHANNEL", attr);
                attr.clear();
                for (int c = 0; c < ctagnum; ++c) {
                    attr.addAttribute("", ctagAttr[c], ctagAttr[c], "CDATA", ctagAttrVal[c]);
                }
                this.contentHandler.startElement("", ctag, ctag, attr);
                this.contentHandler.endElement("", ctag, ctag);
                this.contentHandler.endElement("", "CHANNEL", "CHANNEL");
                this.contentHandler.endElement("", "STATUS", "STATUS");
            } else {
                attr.clear();
                attr.addAttribute("", "NUMBER", "NUMBER", "CDATA", cnum);
                attr.addAttribute("", "TYPE", "TYPE", "CDATA", ctyp);
                this.contentHandler.startElement("", "CHANNEL", "CHANNEL", attr);
                attr.clear();
                for (int c = 0; c < ctagnum; ++c) {
                    attr.addAttribute("", ctagAttr[c], ctagAttr[c], "CDATA", ctagAttrVal[c]);
                }
                this.contentHandler.startElement("", ctag, ctag, attr);
                this.contentHandler.endElement("", ctag, ctag);
                this.contentHandler.endElement("", "CHANNEL", "CHANNEL");
            }
            this.contentHandler.endElement("", "DELTA", "DELTA");
            offset = nFlag ? (offset += slen) : (offset += noff);
            if (offset < len) continue;
            tFlag = false;
        }
    }

    void doHexData(byte[] dta, int len) throws ProcessingException, SAXException {
        AttributesImpl attr = new AttributesImpl();
        String text = "";
        this.contentHandler.startElement("", "HEXDATA", "HEXDATA", attr);
        StringBuffer bth = new StringBuffer("");
        int bpl = 32;
        int r = len % bpl;
        int n = len / bpl;
        for (int i = 0; i < n; ++i) {
            int strt = i * bpl;
            bth.append(Utils.baToHex(dta, strt, strt + bpl - 1));
        }
        if (r > 0) {
            int strt = n * bpl;
            bth.append(Utils.baToHex(dta, strt, strt + r - 1));
        }
        text = bth.toString();
        this.contentHandler.characters(text.toCharArray(), 0, text.length());
        this.contentHandler.endElement("", "HEXDATA", "HEXDATA");
    }
}

