/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class LDAPTransformer
extends AbstractTransformer {
    public static final String my_uri = "http://apache.org/cocoon/LDAP/1.0";
    public static final String my_name = "LDAPTransformer";
    public static final String MAGIC_ATTRIBUTE_ELEMENT = "attribute";
    public static final String MAGIC_ATTRIBUTE_ELEMENT_ATTRIBUTE = "name";
    public static final String MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE = "mode";
    public static final String MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE_DEFAULT = "replace";
    public static final String MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE_VALUE_A = "append";
    public static final String MAGIC_AUTHENTICATION_ELEMENT = "authentication";
    public static final String MAGIC_COUNT_LIMIT_ELEMENT = "count-limit";
    public static final String MAGIC_DEBUG_ELEMENT = "debug";
    public static final String MAGIC_DEREF_LINK_ELEMENT = "deref-link";
    public static final String MAGIC_DOC_ELEMENT = "doc-element";
    public static final String MAGIC_ENCODING_ELEMENT = "encoding";
    public static final String MAGIC_ERROR_ELEMENT = "error-element";
    public static final String MAGIC_EXECUTE_ADD = "execute-add";
    public static final String MAGIC_EXECUTE_INCREMENT = "execute-increment";
    public static final String MAGIC_EXECUTE_QUERY = "execute-query";
    public static final String MAGIC_EXECUTE_REPLACE = "execute-replace";
    public static final String MAGIC_FILTER_ELEMENT = "filter";
    public static final String MAGIC_INITIALIZER_ELEMENT = "initializer";
    public static final String MAGIC_PASSWORD_ELEMENT = "password";
    public static final String MAGIC_PORT_ELEMENT = "port";
    public static final String MAGIC_ROOT_DN_ELEMENT = "rootdn";
    public static final String MAGIC_ROW_ELEMENT = "row-element";
    public static final String MAGIC_SAX_ERROR = "sax-error";
    public static final String MAGIC_SCOPE_ELEMENT = "scope";
    public static final String MAGIC_SEARCHBASE_ELEMENT = "searchbase";
    public static final String MAGIC_SERVERURL_ELEMENT = "serverurl";
    public static final String MAGIC_SHOW_ATTRIBUTE_ELEMENT = "show-attribute";
    public static final String MAGIC_TIME_LIMIT_ELEMENT = "time-limit";
    public static final String MAGIC_VERSION_ELEMENT = "version";
    public static final int STATE_OUTSIDE = 0;
    public static final int STATE_INSIDE_EXECUTE_QUERY = 1;
    public static final int STATE_INSIDE_EXECUTE_INCREMENT = 2;
    public static final int STATE_INSIDE_EXECUTE_ELEMENT = 3;
    public static final int STATE_INSIDE_INITIALIZER_ELEMENT = 4;
    public static final int STATE_INSIDE_SERVERURL_ELEMENT = 5;
    public static final int STATE_INSIDE_PORT_ELEMENT = 6;
    public static final int STATE_INSIDE_SCOPE_ELEMENT = 7;
    public static final int STATE_INSIDE_VERSION_ELEMENT = 8;
    public static final int STATE_INSIDE_AUTHENTICATION_ELEMENT = 9;
    public static final int STATE_INSIDE_ROOT_DN_ELEMENT = 10;
    public static final int STATE_INSIDE_PASSWORD_ELEMENT = 11;
    public static final int STATE_INSIDE_SEARCHBASE_ELEMENT = 12;
    public static final int STATE_INSIDE_DOC_ELEMENT = 13;
    public static final int STATE_INSIDE_ROW_ELEMENT = 14;
    public static final int STATE_INSIDE_ATTRIBUTE_ELEMENT = 15;
    public static final int STATE_INSIDE_SHOW_ATTRIBUTE_ELEMENT = 16;
    public static final int STATE_INSIDE_ERROR_ELEMENT = 17;
    public static final int STATE_INSIDE_FILTER_ELEMENT = 18;
    public static final int STATE_INSIDE_DEREF_LINK_ELEMENT = 19;
    public static final int STATE_INSIDE_COUNT_LIMIT_ELEMENT = 20;
    public static final int STATE_INSIDE_TIME_LIMIT_ELEMENT = 21;
    public static final int STATE_INSIDE_DEBUG_ELEMENT = 22;
    public static final int STATE_INSIDE_SAX_ERROR_ELEMENT = 23;
    public static final int STATE_INSIDE_EXECUTE_REPLACE = 24;
    public static final int STATE_INSIDE_EXECUTE_ADD = 25;
    protected Properties default_properties = new Properties();
    protected String current_name;
    protected int current_state = 0;
    protected StringBuffer current_value = new StringBuffer();
    protected Vector queries = new Vector();
    protected int current_query_index = -1;
    protected XMLConsumer xml_consumer;
    protected LexicalHandler lexical_handler;

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.current_state = 0;
        String parameter = parameters.getParameter(MAGIC_INITIALIZER_ELEMENT, null);
        if (parameter != null) {
            this.default_properties.setProperty(MAGIC_INITIALIZER_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_VERSION_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_VERSION_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_AUTHENTICATION_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_AUTHENTICATION_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_SCOPE_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_SCOPE_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_SERVERURL_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_SERVERURL_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_ROOT_DN_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_ROOT_DN_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_PASSWORD_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_PASSWORD_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_PORT_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_PORT_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_SEARCHBASE_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_SEARCHBASE_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_DOC_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_DOC_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_ROW_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_ROW_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_ERROR_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_ERROR_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_SAX_ERROR, null)) != null) {
            this.default_properties.setProperty(MAGIC_SAX_ERROR, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_DEREF_LINK_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_DEREF_LINK_ELEMENT, parameter.toUpperCase());
        }
        if ((parameter = parameters.getParameter(MAGIC_COUNT_LIMIT_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_COUNT_LIMIT_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_TIME_LIMIT_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_TIME_LIMIT_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_DEBUG_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_DEBUG_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_ENCODING_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_ENCODING_ELEMENT, parameter);
        }
        if ((parameter = parameters.getParameter(MAGIC_FILTER_ELEMENT, null)) != null) {
            this.default_properties.setProperty(MAGIC_FILTER_ELEMENT, parameter);
        }
    }

    protected void executeQuery(int index) throws SAXException {
        this.contentHandler.startPrefixMapping("", my_uri);
        LDAPQuery query = (LDAPQuery)this.queries.elementAt(index);
        try {
            query.execute();
        }
        catch (NamingException e) {
            this.getLogger().error(e.toString());
            throw new SAXException(e);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            throw new SAXException(e);
        }
        this.contentHandler.endPrefixMapping("");
    }

    protected static void throwIllegalStateException(String message) {
        throw new IllegalStateException("LDAPTransformer: " + message);
    }

    protected void startExecuteQuery(Attributes attributes) {
        switch (this.current_state) {
            case 0: {
                this.current_state = 1;
                this.current_query_index = this.queries.size();
                LDAPQuery query = new LDAPQuery(this);
                this.queries.addElement(query);
                this.getCurrentQuery().toDo = 1;
                this.getCurrentQuery().query_index = this.current_query_index;
                break;
            }
            case 18: {
                this.current_state = 1;
                this.current_query_index = this.queries.size();
                LDAPQuery query = new LDAPQuery(this);
                this.queries.addElement(query);
                this.getCurrentQuery().toDo = 1;
                this.getCurrentQuery().query_index = this.current_query_index;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start execute-query element");
            }
        }
    }

    protected void endExecuteQuery() throws SAXException {
        switch (this.current_state) {
            case 1: {
                this.executeQuery(this.current_query_index);
                this.queries.remove(this.current_query_index);
                --this.current_query_index;
                if (this.current_query_index > -1) {
                    this.current_state = this.getCurrentQuery().toDo;
                    break;
                }
                this.queries.removeAllElements();
                this.current_state = 0;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end execute-query element");
            }
        }
    }

    protected void startExecuteIncrement(Attributes attributes) {
        switch (this.current_state) {
            case 0: {
                this.current_state = 2;
                this.current_query_index = this.queries.size();
                LDAPQuery query = new LDAPQuery(this);
                this.queries.addElement(query);
                this.getCurrentQuery().toDo = 2;
                this.getCurrentQuery().query_index = this.current_query_index;
                break;
            }
            case 1: {
                this.current_state = 2;
                this.current_query_index = this.queries.size();
                LDAPQuery query = new LDAPQuery(this);
                this.queries.addElement(query);
                this.getCurrentQuery().toDo = 2;
                this.getCurrentQuery().query_index = this.current_query_index;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start execute-increment element");
            }
        }
    }

    protected void endExecuteIncrement() throws SAXException {
        switch (this.current_state) {
            case 2: {
                this.executeQuery(this.current_query_index);
                this.queries.remove(this.current_query_index);
                --this.current_query_index;
                if (this.current_query_index > 1) {
                    this.current_state = this.getCurrentQuery().toDo;
                    break;
                }
                this.queries.removeAllElements();
                this.current_state = 0;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end execute-increment element");
            }
        }
    }

    protected void startExecuteReplace(Attributes attributes) {
        switch (this.current_state) {
            case 0: {
                this.current_state = 24;
                this.current_query_index = this.queries.size();
                LDAPQuery query = new LDAPQuery(this);
                this.queries.addElement(query);
                this.getCurrentQuery().toDo = 24;
                this.getCurrentQuery().query_index = this.current_query_index;
                break;
            }
            case 1: {
                this.current_state = 24;
                this.current_query_index = this.queries.size();
                LDAPQuery query = new LDAPQuery(this);
                this.queries.addElement(query);
                this.getCurrentQuery().toDo = 24;
                this.getCurrentQuery().query_index = this.current_query_index;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start execute-replace element");
            }
        }
    }

    protected void endExecuteReplace() throws SAXException {
        switch (this.current_state) {
            case 24: {
                this.executeQuery(this.current_query_index);
                this.queries.remove(this.current_query_index);
                --this.current_query_index;
                if (this.current_query_index > 1) {
                    this.current_state = this.getCurrentQuery().toDo;
                    break;
                }
                this.queries.removeAllElements();
                this.current_state = 0;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end execute-replace element");
            }
        }
    }

    protected void startExecuteAdd(Attributes attributes) {
        switch (this.current_state) {
            case 0: {
                this.current_state = 25;
                this.current_query_index = this.queries.size();
                LDAPQuery query = new LDAPQuery(this);
                this.queries.addElement(query);
                this.getCurrentQuery().toDo = 25;
                this.getCurrentQuery().query_index = this.current_query_index;
                break;
            }
            case 1: {
                this.current_state = 25;
                this.current_query_index = this.queries.size();
                LDAPQuery query = new LDAPQuery(this);
                this.queries.addElement(query);
                this.getCurrentQuery().toDo = 25;
                this.getCurrentQuery().query_index = this.current_query_index;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start execute-add element");
            }
        }
    }

    protected void endExecuteAdd() throws SAXException {
        switch (this.current_state) {
            case 25: {
                this.executeQuery(this.current_query_index);
                this.queries.remove(this.current_query_index);
                --this.current_query_index;
                if (this.current_query_index > 1) {
                    this.current_state = this.getCurrentQuery().toDo;
                    break;
                }
                this.queries.removeAllElements();
                this.current_state = 0;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end execute-add element");
            }
        }
    }

    protected void startInitializerElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 4;
                this.getCurrentQuery().current_state = 4;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 4;
                this.getCurrentQuery().current_state = 4;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 4;
                this.getCurrentQuery().current_state = 4;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 4;
                this.getCurrentQuery().current_state = 4;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start initializer element");
            }
        }
    }

    protected void endInitializerElement() {
        switch (this.current_state) {
            case 4: {
                this.getCurrentQuery().initializer = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end initializer element");
            }
        }
    }

    protected void startScopeElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 7;
                this.getCurrentQuery().current_state = 7;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 7;
                this.getCurrentQuery().current_state = 7;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 7;
                this.getCurrentQuery().current_state = 7;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 7;
                this.getCurrentQuery().current_state = 7;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start scope element");
            }
        }
    }

    protected void endScopeElement() {
        switch (this.current_state) {
            case 7: {
                this.getCurrentQuery().scope = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end scope element");
            }
        }
    }

    protected void startAuthenticationElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 9;
                this.getCurrentQuery().current_state = 9;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 9;
                this.getCurrentQuery().current_state = 9;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 9;
                this.getCurrentQuery().current_state = 9;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 9;
                this.getCurrentQuery().current_state = 9;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start authentication element");
            }
        }
    }

    protected void endAuthenticationElement() {
        switch (this.current_state) {
            case 9: {
                this.getCurrentQuery().authentication = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end authentication element");
            }
        }
    }

    protected void startServerurlElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 5;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 5;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 5;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 5;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start serverurl element");
            }
        }
    }

    protected void endServerurlElement() {
        switch (this.current_state) {
            case 5: {
                this.getCurrentQuery().serverurl = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end serverurl element");
            }
        }
    }

    protected void startPortElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 6;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 6;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 6;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 6;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start port element");
            }
        }
    }

    protected void endPortElement() {
        switch (this.current_state) {
            case 6: {
                this.getCurrentQuery().port = Integer.parseInt(this.current_value.toString());
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end server element");
            }
        }
    }

    protected void startShowAttributeElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 16;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 16;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start show-attribute element");
            }
        }
    }

    protected void endShowAttributeElement() {
        switch (this.current_state) {
            case 16: {
                if (this.current_value.toString().toUpperCase().equals("FALSE")) {
                    this.getCurrentQuery().showAttribute = false;
                }
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end show-attribute element");
            }
        }
    }

    protected void startSearchbaseElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 12;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 12;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 12;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 12;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start searchbase element");
            }
        }
    }

    protected void endSearchbaseElement() {
        switch (this.current_state) {
            case 12: {
                this.getCurrentQuery().searchbase = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end searchbase element");
            }
        }
    }

    protected void startDocElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 13;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 13;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 13;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 13;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start doc-element element");
            }
        }
    }

    protected void endDocElement() {
        switch (this.current_state) {
            case 13: {
                this.getCurrentQuery().doc_element = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end doc-element element");
            }
        }
    }

    protected void startRowElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 14;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 14;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 14;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 14;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start row-element element");
            }
        }
    }

    protected void endRowElement() {
        switch (this.current_state) {
            case 14: {
                this.getCurrentQuery().row_element = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end row-element element");
            }
        }
    }

    protected void startErrorElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 17;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 17;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 17;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 17;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start error-element element");
            }
        }
    }

    protected void endErrorElement() {
        switch (this.current_state) {
            case 17: {
                this.getCurrentQuery().error_element = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end error-element element");
            }
        }
    }

    protected void startSaxError(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 23;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 23;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 23;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 23;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start sax-error element");
            }
        }
    }

    protected void endSaxError() {
        switch (this.current_state) {
            case 23: {
                if (this.current_value.toString().toUpperCase().equals("TRUE")) {
                    this.getCurrentQuery().sax_error = true;
                }
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end sax-error element");
            }
        }
    }

    protected void startRootDnElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 10;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 10;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 10;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 10;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start root-dn element");
            }
        }
    }

    protected void endRootDnElement() {
        switch (this.current_state) {
            case 10: {
                this.getCurrentQuery().root_dn = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end root-dn element");
            }
        }
    }

    protected void startPasswordElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 11;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 11;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 11;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 11;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start password element");
            }
        }
    }

    protected void endPasswordElement() {
        switch (this.current_state) {
            case 11: {
                this.getCurrentQuery().password = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end password element");
            }
        }
    }

    protected void startAttributeElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_state = 15;
                this.current_value.setLength(0);
                break;
            }
            case 2: {
                this.current_state = 15;
                this.current_value.setLength(0);
                break;
            }
            case 24: {
                boolean is_name_present = false;
                String mode = MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE_DEFAULT;
                if (attributes != null && attributes.getLength() > 0) {
                    AttributesImpl new_attributes = new AttributesImpl(attributes);
                    for (int i = 0; i < new_attributes.getLength(); ++i) {
                        String attr_name = new_attributes.getLocalName(i);
                        if (attr_name.equals(MAGIC_ATTRIBUTE_ELEMENT_ATTRIBUTE)) {
                            String value = new_attributes.getValue(i);
                            this.getCurrentQuery().addAttrList(value);
                            is_name_present = true;
                            continue;
                        }
                        if (attr_name.equals(MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE)) {
                            if (!new_attributes.getValue(i).equals(MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE_VALUE_A)) continue;
                            mode = MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE_VALUE_A;
                            continue;
                        }
                        this.getLogger().debug("Invalid attribute match: " + attr_name);
                        LDAPTransformer.throwIllegalStateException("Invalid attribute match in start attribute element");
                    }
                }
                if (!is_name_present) {
                    this.getLogger().debug("Do not match 'value' attribute");
                    LDAPTransformer.throwIllegalStateException("Do not match 'value' attribute in start attribute element");
                }
                this.getCurrentQuery().addAttrModeVal(mode);
                this.current_state = 15;
                this.current_value.setLength(0);
                break;
            }
            case 25: {
                if (attributes != null && attributes.getLength() > 0) {
                    AttributesImpl new_attributes = new AttributesImpl(attributes);
                    for (int i = 0; i < new_attributes.getLength(); ++i) {
                        String attr_name = new_attributes.getLocalName(i);
                        if (attr_name.equals(MAGIC_ATTRIBUTE_ELEMENT_ATTRIBUTE)) {
                            String value = new_attributes.getValue(i);
                            this.getCurrentQuery().addAttrList(value);
                            continue;
                        }
                        this.getLogger().debug("Invalid attribute match: " + attr_name);
                        LDAPTransformer.throwIllegalStateException("Invalid attribute match in start attribute element");
                    }
                } else {
                    this.getLogger().debug("Do not match 'value' attribute");
                    LDAPTransformer.throwIllegalStateException("Do not match 'value' attribute in start attribute element");
                }
                this.current_state = 15;
                this.current_value.setLength(0);
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start attribute element");
            }
        }
    }

    protected void endAttributeElement() {
        switch (this.current_state) {
            case 15: {
                if (this.getCurrentQuery().toDo == 24 || this.getCurrentQuery().toDo == 25) {
                    this.getCurrentQuery().addAttrVal(this.current_value.toString());
                    this.current_state = this.getCurrentQuery().toDo;
                    break;
                }
                this.getCurrentQuery().addAttrList(this.current_value.toString());
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end attribute element");
            }
        }
    }

    protected void startVersionElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_state = 8;
                this.current_value.setLength(0);
                break;
            }
            case 2: {
                this.current_state = 8;
                this.current_value.setLength(0);
                break;
            }
            case 24: {
                this.current_state = 8;
                this.current_value.setLength(0);
                break;
            }
            case 25: {
                this.current_state = 8;
                this.current_value.setLength(0);
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start version element");
            }
        }
    }

    protected void endVersionElement() {
        switch (this.current_state) {
            case 8: {
                this.getCurrentQuery().version = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end version element");
            }
        }
    }

    protected void startFilterElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_state = 18;
                this.getCurrentQuery().current_state = 18;
                this.current_value.setLength(0);
                break;
            }
            case 2: {
                this.current_state = 18;
                this.getCurrentQuery().current_state = 18;
                this.current_value.setLength(0);
                break;
            }
            case 24: {
                this.current_state = 18;
                this.getCurrentQuery().current_state = 18;
                this.current_value.setLength(0);
                break;
            }
            case 25: {
                this.current_state = 18;
                this.getCurrentQuery().current_state = 18;
                this.current_value.setLength(0);
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start filter element");
            }
        }
    }

    protected void endFilterElement() {
        switch (this.current_state) {
            case 18: {
                this.getCurrentQuery().filter = this.current_value.toString();
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end filter element");
            }
        }
    }

    protected void startDerefLinkElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_state = 19;
                this.current_value.setLength(0);
                break;
            }
            case 2: {
                this.current_state = 19;
                this.current_value.setLength(0);
                break;
            }
            case 24: {
                this.current_state = 19;
                this.current_value.setLength(0);
                break;
            }
            case 25: {
                this.current_state = 19;
                this.current_value.setLength(0);
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start deref-link element");
            }
        }
    }

    protected void endDerefLinkElement() {
        switch (this.current_state) {
            case 19: {
                if (this.current_value.toString().toUpperCase().equals("TRUE")) {
                    this.getCurrentQuery().deref_link = true;
                }
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end deref-link element");
            }
        }
    }

    protected void startCountLimitElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_state = 20;
                this.current_value.setLength(0);
                break;
            }
            case 2: {
                this.current_state = 20;
                this.current_value.setLength(0);
                break;
            }
            case 24: {
                this.current_state = 20;
                this.current_value.setLength(0);
                break;
            }
            case 25: {
                this.current_state = 20;
                this.current_value.setLength(0);
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start count-limit element");
            }
        }
    }

    protected void endCountLimitElement() {
        switch (this.current_state) {
            case 20: {
                this.getCurrentQuery().count_limit = Integer.parseInt(this.current_value.toString());
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end count-limit element");
            }
        }
    }

    protected void startTimeLimitElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_state = 21;
                this.current_value.setLength(0);
                break;
            }
            case 2: {
                this.current_state = 21;
                this.current_value.setLength(0);
                break;
            }
            case 24: {
                this.current_state = 21;
                this.current_value.setLength(0);
                break;
            }
            case 25: {
                this.current_state = 21;
                this.current_value.setLength(0);
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start time-limit element");
            }
        }
    }

    protected void endTimeLimitElement() {
        switch (this.current_state) {
            case 21: {
                this.getCurrentQuery().time_limit = Integer.parseInt(this.current_value.toString());
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end time-limit element");
            }
        }
    }

    protected void startDebugElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                this.current_value.setLength(0);
                this.current_state = 22;
                break;
            }
            case 2: {
                this.current_value.setLength(0);
                this.current_state = 22;
                break;
            }
            case 24: {
                this.current_value.setLength(0);
                this.current_state = 22;
                break;
            }
            case 25: {
                this.current_value.setLength(0);
                this.current_state = 22;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a start debug element");
            }
        }
    }

    protected void endDebugElement() {
        switch (this.current_state) {
            case 22: {
                if (this.current_value.toString().toUpperCase().equals("TRUE")) {
                    this.getCurrentQuery().debug = true;
                }
                this.current_state = this.getCurrentQuery().toDo;
                break;
            }
            default: {
                LDAPTransformer.throwIllegalStateException("Not expecting a end debug element");
            }
        }
    }

    protected LDAPQuery getCurrentQuery() {
        return (LDAPQuery)this.queries.elementAt(this.current_query_index);
    }

    protected LDAPQuery getQuery(int i) {
        return (LDAPQuery)this.queries.elementAt(i);
    }

    public void setDocumentLocator(Locator locator) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("PUBLIC ID: " + locator.getPublicId());
            this.getLogger().debug("SYSTEM ID: " + locator.getSystemId());
        }
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        if (!uri.equals(my_uri)) {
            super.startElement(uri, name, raw, attributes);
            return;
        }
        this.getLogger().debug("RECEIVED START ELEMENT " + name + "(" + uri + ")");
        if (name.equals(MAGIC_EXECUTE_QUERY)) {
            this.startExecuteQuery(attributes);
        } else if (name.equals(MAGIC_EXECUTE_INCREMENT)) {
            this.startExecuteIncrement(attributes);
        } else if (name.equals(MAGIC_INITIALIZER_ELEMENT)) {
            this.startInitializerElement(attributes);
        } else if (name.equals(MAGIC_AUTHENTICATION_ELEMENT)) {
            this.startAuthenticationElement(attributes);
        } else if (name.equals(MAGIC_SCOPE_ELEMENT)) {
            this.startScopeElement(attributes);
        } else if (name.equals(MAGIC_VERSION_ELEMENT)) {
            this.startVersionElement(attributes);
        } else if (name.equals(MAGIC_SERVERURL_ELEMENT)) {
            this.startServerurlElement(attributes);
        } else if (name.equals(MAGIC_PORT_ELEMENT)) {
            this.startPortElement(attributes);
        } else if (name.equals(MAGIC_DOC_ELEMENT)) {
            this.startDocElement(attributes);
        } else if (name.equals(MAGIC_ROW_ELEMENT)) {
            this.startRowElement(attributes);
        } else if (name.equals(MAGIC_ERROR_ELEMENT)) {
            this.startErrorElement(attributes);
        } else if (name.equals(MAGIC_SAX_ERROR)) {
            this.startSaxError(attributes);
        } else if (name.equals(MAGIC_ROOT_DN_ELEMENT)) {
            this.startRootDnElement(attributes);
        } else if (name.equals(MAGIC_PASSWORD_ELEMENT)) {
            this.startPasswordElement(attributes);
        } else if (name.equals(MAGIC_ATTRIBUTE_ELEMENT)) {
            this.startAttributeElement(attributes);
        } else if (name.equals(MAGIC_SHOW_ATTRIBUTE_ELEMENT)) {
            this.startShowAttributeElement(attributes);
        } else if (name.equals(MAGIC_SEARCHBASE_ELEMENT)) {
            this.startSearchbaseElement(attributes);
        } else if (name.equals(MAGIC_FILTER_ELEMENT)) {
            this.startFilterElement(attributes);
        } else if (name.equals(MAGIC_DEREF_LINK_ELEMENT)) {
            this.startDerefLinkElement(attributes);
        } else if (name.equals(MAGIC_COUNT_LIMIT_ELEMENT)) {
            this.startCountLimitElement(attributes);
        } else if (name.equals(MAGIC_TIME_LIMIT_ELEMENT)) {
            this.startTimeLimitElement(attributes);
        } else if (name.equals(MAGIC_DEBUG_ELEMENT)) {
            this.startDebugElement(attributes);
        } else if (name.equals(MAGIC_EXECUTE_REPLACE)) {
            this.startExecuteReplace(attributes);
        } else if (name.equals(MAGIC_EXECUTE_ADD)) {
            this.startExecuteAdd(attributes);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (!uri.equals(my_uri)) {
            super.endElement(uri, name, raw);
            return;
        }
        this.getLogger().debug("RECEIVED END ELEMENT " + name + "(" + uri + ")");
        if (name.equals(MAGIC_EXECUTE_QUERY)) {
            this.endExecuteQuery();
        } else if (name.equals(MAGIC_EXECUTE_INCREMENT)) {
            this.endExecuteIncrement();
        } else if (name.equals(MAGIC_INITIALIZER_ELEMENT)) {
            this.endInitializerElement();
        } else if (name.equals(MAGIC_AUTHENTICATION_ELEMENT)) {
            this.endAuthenticationElement();
        } else if (name.equals(MAGIC_SCOPE_ELEMENT)) {
            this.endScopeElement();
        } else if (name.equals(MAGIC_VERSION_ELEMENT)) {
            this.endVersionElement();
        } else if (name.equals(MAGIC_SERVERURL_ELEMENT)) {
            this.endServerurlElement();
        } else if (name.equals(MAGIC_PORT_ELEMENT)) {
            this.endPortElement();
        } else if (name.equals(MAGIC_DOC_ELEMENT)) {
            this.endDocElement();
        } else if (name.equals(MAGIC_ROW_ELEMENT)) {
            this.endRowElement();
        } else if (name.equals(MAGIC_ERROR_ELEMENT)) {
            this.endErrorElement();
        } else if (name.equals(MAGIC_SAX_ERROR)) {
            this.endSaxError();
        } else if (name.equals(MAGIC_ROOT_DN_ELEMENT)) {
            this.endRootDnElement();
        } else if (name.equals(MAGIC_PASSWORD_ELEMENT)) {
            this.endPasswordElement();
        } else if (name.equals(MAGIC_ATTRIBUTE_ELEMENT)) {
            this.endAttributeElement();
        } else if (name.equals(MAGIC_SHOW_ATTRIBUTE_ELEMENT)) {
            this.endShowAttributeElement();
        } else if (name.equals(MAGIC_SEARCHBASE_ELEMENT)) {
            this.endSearchbaseElement();
        } else if (name.equals(MAGIC_FILTER_ELEMENT)) {
            this.endFilterElement();
        } else if (name.equals(MAGIC_DEREF_LINK_ELEMENT)) {
            this.endDerefLinkElement();
        } else if (name.equals(MAGIC_COUNT_LIMIT_ELEMENT)) {
            this.endCountLimitElement();
        } else if (name.equals(MAGIC_TIME_LIMIT_ELEMENT)) {
            this.endTimeLimitElement();
        } else if (name.equals(MAGIC_DEBUG_ELEMENT)) {
            this.endDebugElement();
        } else if (name.equals(MAGIC_EXECUTE_REPLACE)) {
            this.endExecuteReplace();
        } else if (name.equals(MAGIC_EXECUTE_ADD)) {
            this.endExecuteAdd();
        }
    }

    public void characters(char[] ary, int start, int length) throws SAXException {
        if (this.current_state != 4 && this.current_state != 9 && this.current_state != 7 && this.current_state != 8 && this.current_state != 5 && this.current_state != 6 && this.current_state != 13 && this.current_state != 14 && this.current_state != 17 && this.current_state != 23 && this.current_state != 10 && this.current_state != 11 && this.current_state != 15 && this.current_state != 16 && this.current_state != 18 && this.current_state != 19 && this.current_state != 20 && this.current_state != 21 && this.current_state != 22 && this.current_state != 12) {
            super.characters(ary, start, length);
        }
        this.getLogger().debug("RECEIVED CHARACTERS: " + new String(ary, start, length));
        this.current_value.append(ary, start, length);
    }

    protected void start(String name, AttributesImpl attr) throws SAXException {
        this.contentHandler.startElement("", name, name, attr);
        attr.clear();
    }

    protected void end(String name) throws SAXException {
        this.contentHandler.endElement("", name, name);
    }

    protected void data(String data) throws SAXException {
        if (data != null) {
            this.contentHandler.characters(data.toCharArray(), 0, data.length());
        }
    }

    protected static String getStringValue(Object object) {
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public final Logger getTheLogger() {
        return this.getLogger();
    }

    class LDAPQuery {
        protected int query_index;
        protected int current_state;
        protected LDAPTransformer transformer;
        protected String initializer = "com.sun.jndi.ldap.LdapCtxFactory";
        protected String serverurl = "localhost";
        protected int port = 389;
        protected String root_dn = "";
        protected String password = "";
        protected String version = "2";
        protected String scope = "ONELEVEL_SCOPE";
        protected String authentication = "simple";
        private final String LDAP_ENCODING = "ISO-8859-1";
        protected String encoding = "ISO-8859-1";
        protected Properties env = new Properties();
        protected DirContext ctx;
        protected int toDo;
        protected String searchbase = "";
        protected List attrModeVal = new LinkedList();
        protected List attrListe = new LinkedList();
        protected List attrVale = new LinkedList();
        protected String REPLACE_MODE_DEFAULT = "";
        protected String REPLACE_MODE_APPEND = "";
        protected boolean showAttribute = true;
        protected String filter = "";
        protected String doc_element = "doc-element";
        protected String exec_element = "exec-element";
        protected String row_element = "row-element";
        protected String error_element = "ldap-error";
        protected boolean sax_error = false;
        protected boolean deref_link = false;
        protected long count_limit = 0L;
        protected int time_limit = 0;
        protected boolean debug = false;

        protected LDAPQuery(LDAPTransformer transformer) {
            this.transformer = transformer;
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_INITIALIZER_ELEMENT)) {
                this.initializer = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_INITIALIZER_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SERVERURL_ELEMENT)) {
                this.serverurl = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SERVERURL_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_PORT_ELEMENT)) {
                this.port = Integer.parseInt(transformer.default_properties.getProperty(LDAPTransformer.MAGIC_PORT_ELEMENT));
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_ROOT_DN_ELEMENT)) {
                this.root_dn = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_ROOT_DN_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_PASSWORD_ELEMENT)) {
                this.password = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_PASSWORD_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_VERSION_ELEMENT)) {
                this.version = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_VERSION_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SCOPE_ELEMENT)) {
                this.scope = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SCOPE_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_AUTHENTICATION_ELEMENT)) {
                this.authentication = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_AUTHENTICATION_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SEARCHBASE_ELEMENT)) {
                this.searchbase = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SEARCHBASE_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SHOW_ATTRIBUTE_ELEMENT)) {
                boolean bl = this.showAttribute = !transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SHOW_ATTRIBUTE_ELEMENT).equals("FALSE");
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_DOC_ELEMENT)) {
                this.doc_element = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_DOC_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_ROW_ELEMENT)) {
                this.row_element = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_ROW_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_ERROR_ELEMENT)) {
                this.error_element = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_ERROR_ELEMENT);
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SAX_ERROR)) {
                boolean bl = this.sax_error = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_SAX_ERROR).equals("TRUE");
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_DEREF_LINK_ELEMENT)) {
                boolean bl = this.deref_link = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_DEREF_LINK_ELEMENT).equals("TRUE");
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_COUNT_LIMIT_ELEMENT)) {
                this.count_limit = Long.parseLong(transformer.default_properties.getProperty(LDAPTransformer.MAGIC_COUNT_LIMIT_ELEMENT));
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_TIME_LIMIT_ELEMENT)) {
                this.time_limit = Integer.parseInt(transformer.default_properties.getProperty(LDAPTransformer.MAGIC_TIME_LIMIT_ELEMENT));
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_DEBUG_ELEMENT)) {
                boolean bl = this.debug = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_DEBUG_ELEMENT).equals("TRUE");
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_ENCODING_ELEMENT)) {
                this.encoding = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_ENCODING_ELEMENT);
            }
            if (null != LDAPTransformer.MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE_VALUE_A) {
                this.REPLACE_MODE_APPEND = LDAPTransformer.MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE_VALUE_A;
            }
            if (null != LDAPTransformer.MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE_DEFAULT) {
                this.REPLACE_MODE_DEFAULT = LDAPTransformer.MAGIC_ATTRIBUTE_ELEMENT_MODE_ATTRIBUTE_DEFAULT;
            }
            if (null != transformer.default_properties.getProperty(LDAPTransformer.MAGIC_FILTER_ELEMENT)) {
                this.filter = transformer.default_properties.getProperty(LDAPTransformer.MAGIC_FILTER_ELEMENT);
            }
        }

        /*
         * Exception decompiling
         */
        protected void execute() throws Exception, NamingException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CATCHBLOCK]], but top level block is 114[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void addAttrList(String attr) {
            this.attrListe.add(attr);
        }

        protected void addAttrModeVal(String mode) {
            this.attrModeVal.add(mode);
        }

        protected void addAttrVal(String val) {
            this.attrVale.add(val);
        }

        protected void connect() throws NamingException {
            if (this.root_dn != null && this.password != null) {
                this.env.put("java.naming.security.authentication", this.authentication);
                this.env.put("java.naming.security.principal", this.root_dn);
                this.env.put("java.naming.security.credentials", this.password);
            }
            this.env.put("java.naming.ldap.version", this.version);
            this.env.put("java.naming.factory.initial", this.initializer);
            this.env.put("java.naming.provider.url", this.serverurl + ":" + this.port);
            try {
                this.ctx = new InitialDirContext(this.env);
            }
            catch (NamingException e) {
                this.env.clear();
                throw new NamingException(e.toString());
            }
        }

        protected void disconnect() throws NamingException {
            try {
                if (this.ctx != null) {
                    this.ctx.close();
                }
            }
            catch (NamingException e) {
                this.ctx = null;
                this.env.clear();
                throw new NamingException(e.toString());
            }
            this.ctx = null;
            this.env.clear();
        }

        protected void debugPrint() {
            this.transformer.getTheLogger().debug("[LDAPTransformer] query_index: " + this.query_index);
            this.transformer.getTheLogger().debug("[LDAPTransformer] current_state: " + this.current_state);
            this.transformer.getTheLogger().debug("[LDAPTransformer] serverurl: " + this.serverurl);
            this.transformer.getTheLogger().debug("[LDAPTransformer] port: " + this.port);
            this.transformer.getTheLogger().debug("[LDAPTransformer] root_dn: " + this.root_dn);
            this.transformer.getTheLogger().debug("[LDAPTransformer] password: " + this.password);
            this.transformer.getTheLogger().debug("[LDAPTransformer] version: " + this.version);
            this.transformer.getTheLogger().debug("[LDAPTransformer] scope: " + this.scope);
            this.transformer.getTheLogger().debug("[LDAPTransformer] authentication: " + this.authentication);
            this.transformer.getTheLogger().debug("[LDAPTransformer] toDo: " + this.toDo);
            this.transformer.getTheLogger().debug("[LDAPTransformer] searchbase: " + this.searchbase);
            this.transformer.getTheLogger().debug("[LDAPTransformer] showAttribute: " + this.showAttribute);
            this.transformer.getTheLogger().debug("[LDAPTransformer] attribute: " + this.attrListe.toString());
            this.transformer.getTheLogger().debug("[LDAPTransformer] filter: " + this.filter);
            this.transformer.getTheLogger().debug("[LDAPTransformer] doc_element: " + this.doc_element);
            this.transformer.getTheLogger().debug("[LDAPTransformer] row_element: " + this.row_element);
            this.transformer.getTheLogger().debug("[LDAPTransformer] error_element: " + this.error_element);
            this.transformer.getTheLogger().debug("[LDAPTransformer] sax-error: " + this.sax_error);
            this.transformer.getTheLogger().debug("[LDAPTransformer] deref_link: " + this.deref_link);
            this.transformer.getTheLogger().debug("[LDAPTransformer] count_limit: " + this.count_limit);
            this.transformer.getTheLogger().debug("[LDAPTransformer] time_limit: " + this.time_limit);
        }

        private String recodeFromLDAPEncoding(String value) throws UnsupportedEncodingException {
            if (!"ISO-8859-1".equals(this.encoding)) {
                value = new String(value.getBytes("ISO-8859-1"), this.encoding);
            }
            return value;
        }

        private String recodeToLDAPEncoding(String value) throws UnsupportedEncodingException {
            if (!"ISO-8859-1".equals(this.encoding)) {
                value = new String(value.getBytes(this.encoding), "ISO-8859-1");
            }
            return value;
        }
    }
}

