/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.naming;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.naming.EntryManager;

public class LDAPEntryManager
extends AbstractLogEnabled
implements EntryManager,
Parameterizable,
Disposable,
Recyclable {
    protected static final String LDAP_HOST_PARAM = "ldap-host";
    protected static final String LDAP_USER_PARAM = "ldap-user";
    protected static final String LDAP_PASS_PARAM = "ldap-pass";
    protected static final String LDAP_BASE_PARAM = "ldap-base";
    private boolean disposed = false;
    private boolean recycled = false;
    protected DirContext context = null;
    protected Hashtable environment = null;

    public void parameterize(Parameters params) throws ParameterException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("LDAPEntryManager parameterizing");
        }
        if (this.environment == null) {
            String host = params.getParameter(LDAP_HOST_PARAM);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("LDAP using host: " + host);
            }
            String base = params.getParameter(LDAP_BASE_PARAM);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("LDAP using base: " + base);
            }
            String user = params.getParameter(LDAP_USER_PARAM);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("LDAP using user: " + user);
            }
            String pass = params.getParameter(LDAP_PASS_PARAM);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("LDAP using pass: " + pass);
            }
            this.environment = new Hashtable();
            this.environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            this.environment.put("java.naming.provider.url", host + "/" + base);
            if (user != null) {
                this.environment.put("java.naming.security.authentication", "simple");
                this.environment.put("java.naming.security.principal", user);
                this.environment.put("java.naming.security.credentials", pass);
            }
        }
    }

    public final void recycle() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("LDAPEntryManager recycling");
        }
        try {
            try {
                this.context.close();
            }
            catch (Exception e) {
                this.getLogger().error("LDAPEntryManager.recycle() :" + e.getMessage());
                Object var3_2 = null;
                this.context = null;
            }
            Object var3_1 = null;
            this.context = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.context = null;
            throw throwable;
        }
        this.recycled = true;
    }

    public final void dispose() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("LDAPEntryManager disposing");
        }
        try {
            block5: {
                try {
                    if (this.context == null) break block5;
                    this.context.close();
                }
                catch (Exception e) {
                    this.getLogger().error("LDAPEntryManager.recycle() :" + e.getMessage());
                    Object var3_2 = null;
                    this.context = null;
                    this.environment = null;
                    this.disposed = true;
                }
            }
            Object var3_1 = null;
            this.context = null;
            this.environment = null;
            this.disposed = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.context = null;
            this.environment = null;
            this.disposed = true;
            throw throwable;
        }
    }

    protected void initialize() throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("LDAPEntryManager initialising");
        }
        if (null == this.environment) {
            throw new IllegalStateException("LDAPEntryManager.initialize() : Not Configured");
        }
        if (this.disposed) {
            throw new IllegalStateException("LDAPEntryManager.initialize() : Already disposed");
        }
        try {
            this.context = new InitialDirContext(this.environment);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("LDAPEntryManager new context: " + this.context.getNameInNamespace());
            }
        }
        catch (Exception e) {
            this.getLogger().error("LDAPEntryManager.initialize()" + e.getMessage());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(String name, Map attributes) throws ProcessingException {
        Context newContext = null;
        try {
            try {
                if (this.context == null) {
                    this.initialize();
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("LDAPEntryManager creating new Context: " + name);
                }
                newContext = this.context.createSubcontext(name, this.map2Attributes(attributes));
            }
            catch (Exception e) {
                this.getLogger().error("LDAPEntryManager.create() :" + e.getMessage());
                throw new ProcessingException(e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (newContext == null) throw throwable;
                newContext.close();
                throw throwable;
            }
            catch (NamingException ne) {
                throw new ProcessingException((Exception)ne);
            }
        }
        try {}
        catch (NamingException ne) {
            throw new ProcessingException((Exception)ne);
        }
        if (newContext == null) return;
        newContext.close();
    }

    public Map get(String name) throws ProcessingException {
        try {
            if (this.context == null) {
                this.initialize();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("LDAPEntryManager retrieving Entry: " + name);
            }
            return this.attributes2Map(this.context.getAttributes(name));
        }
        catch (Exception e) {
            this.getLogger().error("LDAPEntryManager.get() :" + e.getMessage());
            throw new ProcessingException(e);
        }
    }

    public Map find(Map attributes) throws ProcessingException {
        return this.find("", attributes);
    }

    public Map find(String cntx, Map attributes) throws ProcessingException {
        try {
            if (this.context == null) {
                this.initialize();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("LDAPEntryManager finding Entries in: " + cntx);
            }
            return this.namingEnumeration2Map(this.context.search(cntx, this.map2Attributes(attributes)));
        }
        catch (Exception e) {
            this.getLogger().error("LDAPEntryManager.find() :" + e.getMessage());
            throw new ProcessingException(e);
        }
    }

    public void modify(String name, int mod_op, Map attributes) throws ProcessingException {
        try {
            if (this.context == null) {
                this.initialize();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("LDAPEntryManager modifying Entry: " + name);
            }
            this.context.modifyAttributes(name, mod_op, this.map2Attributes(attributes));
        }
        catch (Exception e) {
            this.getLogger().error("LDAPEntryManager.modify() :" + e.getMessage());
            throw new ProcessingException(e);
        }
    }

    private Map attributes2Map(Attributes attributes) throws NamingException {
        HashMap map = new HashMap();
        NamingEnumeration<? extends Attribute> atts = attributes.getAll();
        while (atts.hasMore()) {
            Attribute attr = atts.next();
            String id = attr.getID();
            ArrayList val = new ArrayList();
            NamingEnumeration<?> vals = attr.getAll();
            while (vals.hasMore()) {
                val.add(vals.next());
            }
            map.put(id, val);
        }
        return map;
    }

    private Attributes map2Attributes(Map map) {
        BasicAttributes attrs = new BasicAttributes(false);
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            String key = (String)me.getKey();
            BasicAttribute attr = new BasicAttribute(key);
            Iterator vals = ((List)me.getValue()).iterator();
            while (vals.hasNext()) {
                attr.add(vals.next());
            }
            attrs.put(attr);
        }
        return attrs;
    }

    private Map namingEnumeration2Map(NamingEnumeration enumeration) throws NamingException {
        HashMap<String, Map> map = new HashMap<String, Map>();
        while (enumeration.hasMore()) {
            SearchResult sr = (SearchResult)enumeration.next();
            map.put(sr.getName(), this.attributes2Map(sr.getAttributes()));
        }
        return map;
    }
}

