/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;

public class ParanoidClassLoader
extends URLClassLoader {
    public ParanoidClassLoader() {
        this((URL[])null, (ClassLoader)null, (URLStreamHandlerFactory)null);
    }

    public ParanoidClassLoader(ClassLoader parent) {
        this(new URL[0], parent, null);
    }

    public ParanoidClassLoader(URL[] urls) {
        this(urls, null, null);
    }

    public ParanoidClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, null);
    }

    public ParanoidClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public static final URLClassLoader newInstance(URL[] urls) {
        return new ParanoidClassLoader(urls);
    }

    public static final URLClassLoader newInstance(URL[] urls, ClassLoader parent) {
        return new ParanoidClassLoader(urls, parent);
    }

    public final Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            try {
                clazz = this.findClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                ClassLoader parent = this.getParent();
                if (parent != null) {
                    clazz = parent.loadClass(name);
                }
                throw cnfe;
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public final URL getResource(String name) {
        URL resource = this.findResource(name);
        ClassLoader parent = this.getParent();
        if (resource == null && parent != null) {
            resource = parent.getResource(name);
        }
        return resource;
    }

    public final void addDirectory(File file) throws IOException {
        this.addURL(file.getCanonicalFile().toURL());
    }

    public void addURL(URL url) {
        super.addURL(url);
    }
}

