/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.cocoon.servlet.ParanoidClassLoader;

public class ParanoidCocoonServlet
extends HttpServlet {
    public static final String DEFAULT_SERVLET_CLASS = "org.apache.cocoon.servlet.CocoonServlet";
    protected static final String CONTEXT_PREFIX = "context:";
    protected static final String FILE_PREFIX = "file:";
    protected Servlet servlet;
    protected ClassLoader classloader;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String externalClasspath = config.getInitParameter("paranoid-classpath");
        URL[] classPath = externalClasspath == null ? this.getClassPath(this.getContextDir()) : this.getClassPath(externalClasspath, this.getContextDir());
        String classLoaderName = config.getInitParameter("classloader-class");
        if (classLoaderName != null) {
            this.log("Using classloader " + classLoaderName);
        }
        this.classloader = this.createClassLoader(classLoaderName, classPath);
        String servletName = config.getInitParameter("servlet-class");
        if (servletName == null) {
            servletName = DEFAULT_SERVLET_CLASS;
        }
        this.log("Loading servlet class " + servletName);
        try {
            Class<?> servletClass = this.classloader.loadClass(servletName);
            this.servlet = (Servlet)servletClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Cannot load servlet " + servletName, (Throwable)e);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            this.initServlet();
            Object var8_8 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
    }

    protected void initServlet() throws ServletException {
        this.servlet.init(this.getServletConfig());
    }

    protected File getContextDir() throws ServletException {
        String result = this.getServletContext().getRealPath("/");
        if (result == null) {
            throw new ServletException(((Object)((Object)this)).getClass().getName() + " cannot run in an undeployed WAR file");
        }
        return new File(result);
    }

    protected URL[] getClassPath(File contextDir) throws ServletException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            File classDir = new File(contextDir + "/WEB-INF/classes");
            if (classDir.exists()) {
                if (!classDir.isDirectory()) {
                    throw new ServletException(classDir + " exists but is not a directory");
                }
                URL classURL = classDir.toURL();
                this.log("Adding class directory " + classURL);
                urlList.add(classURL);
            }
            File libDir = new File(contextDir + "/WEB-INF/lib");
            File[] libraries = libDir.listFiles(new JarFileFilter());
            int i = 0;
            while (i < libraries.length) {
                URL lib = libraries[i].toURL();
                this.log("Adding class library " + lib);
                urlList.add(lib);
                ++i;
            }
        }
        catch (MalformedURLException mue) {
            throw new ServletException((Throwable)mue);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return urls;
    }

    protected URL[] getClassPath(String externalClasspath, File contextDir) throws ServletException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        File file = new File(externalClasspath);
        if (!file.isAbsolute()) {
            file = new File(contextDir, externalClasspath);
        }
        this.log("Adding classpath from " + file);
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            LineNumberReader lineReader = new LineNumberReader(fileReader);
            do {
                if ((line = lineReader.readLine()) == null) continue;
                if (line.startsWith("class-dir:")) {
                    if ((line = line.substring("class-dir:".length()).trim()).startsWith(CONTEXT_PREFIX)) {
                        line = contextDir + line.substring(CONTEXT_PREFIX.length());
                    }
                    URL url = new File(line).toURL();
                    this.log("Adding class directory " + url);
                    urlList.add(url);
                    continue;
                }
                if (line.startsWith("lib-dir:")) {
                    if ((line = line.substring("lib-dir:".length()).trim()).startsWith(CONTEXT_PREFIX)) {
                        line = contextDir + line.substring(CONTEXT_PREFIX.length());
                    }
                    File dir = new File(line);
                    File[] libraries = dir.listFiles(new JarFileFilter());
                    this.log("Adding " + libraries.length + " libraries from " + dir.toURL());
                    int i = 0;
                    while (i < libraries.length) {
                        URL url = libraries[i].toURL();
                        urlList.add(url);
                        ++i;
                    }
                } else {
                    URL lib;
                    if (line.startsWith("#")) continue;
                    if (line.startsWith(CONTEXT_PREFIX)) {
                        line = "file:/" + contextDir + line.substring(CONTEXT_PREFIX.length()).trim();
                    }
                    if (line.indexOf(58) == -1) {
                        File entry = new File(line);
                        lib = entry.toURL();
                    } else {
                        lib = new URL(line);
                    }
                    this.log("Adding class URL " + lib);
                    urlList.add(lib);
                }
            } while (line != null);
            lineReader.close();
        }
        catch (IOException io) {
            throw new ServletException((Throwable)io);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return urls;
    }

    protected ClassLoader createClassLoader(String className, URL[] classPath) throws ServletException {
        if (className != null) {
            try {
                Class<?> classLoaderClass = Class.forName(className);
                Class[] parameterClasses = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ParanoidCocoonServlet.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
                Constructor<?> constructor = classLoaderClass.getConstructor(parameterClasses);
                Object[] parameters = new Object[]{((Object)((Object)this)).getClass().getClassLoader()};
                ClassLoader classloader = (ClassLoader)constructor.newInstance(parameters);
                return classloader;
            }
            catch (InstantiationException e) {
                throw new ServletException("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ServletException("", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("", (Throwable)e);
            }
            catch (SecurityException e) {
                throw new ServletException("", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ServletException("", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ServletException("", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ServletException("", (Throwable)e);
            }
        }
        return ParanoidClassLoader.newInstance(classPath, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected ClassLoader getClassLoader(File contextDir) throws ServletException {
        return this.createClassLoader(null, this.getClassPath(contextDir));
    }

    protected ClassLoader getClassLoader(String externalClasspath, File contextDir) throws ServletException {
        return this.createClassLoader(null, this.getClassPath(externalClasspath, contextDir));
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            this.servlet.service(request, response);
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
    }

    public void destroy() {
        if (this.servlet != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classloader);
                this.servlet.destroy();
                Object var3_2 = null;
                Thread.currentThread().setContextClassLoader(old);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Thread.currentThread().setContextClassLoader(old);
                throw throwable;
            }
        }
        super.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JarFileFilter
    implements FilenameFilter {
        private JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".zip") || name.endsWith(".jar");
        }
    }
}

