/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cocoon.components.flow.javascript.ScriptableResult;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class ScriptableConnection
extends ScriptableObject {
    Connection connection;
    Scriptable wrapper;

    static Object wrap(Scriptable wrapper, Scriptable wrapped, Object obj) {
        if (obj instanceof Function) {
            return ScriptableConnection.wrap(wrapper, wrapped, (Function)obj);
        }
        return obj;
    }

    static Function wrap(final Scriptable wrapper, final Scriptable wrapped, final Function fun) {
        return new Function(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
                if (thisObj == wrapper) {
                    thisObj = wrapped;
                }
                return fun.call(cx, scope, thisObj, args);
            }

            public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
                return fun.construct(cx, scope, args);
            }

            public String getClassName() {
                return fun.getClassName();
            }

            public Object get(String name, Scriptable start) {
                return fun.get(name, (Scriptable)fun);
            }

            public Object get(int index, Scriptable start) {
                return fun.get(index, (Scriptable)fun);
            }

            public boolean has(String name, Scriptable start) {
                return fun.has(name, start);
            }

            public boolean has(int index, Scriptable start) {
                return fun.has(index, start);
            }

            public void put(String name, Scriptable start, Object value) {
                fun.put(name, start, value);
            }

            public void put(int index, Scriptable start, Object value) {
                fun.put(index, start, value);
            }

            public void delete(String name) {
                fun.delete(name);
            }

            public void delete(int index) {
                fun.delete(index);
            }

            public Scriptable getPrototype() {
                return fun.getPrototype();
            }

            public void setPrototype(Scriptable prototype) {
            }

            public Scriptable getParentScope() {
                return fun.getParentScope();
            }

            public void setParentScope(Scriptable parent) {
            }

            public Object[] getIds() {
                return fun.getIds();
            }

            public Object getDefaultValue(Class hint) {
                return fun.getDefaultValue(hint);
            }

            public boolean hasInstance(Scriptable instance) {
                return fun.hasInstance(instance);
            }
        };
    }

    public String getClassName() {
        return "Database";
    }

    public ScriptableConnection() {
    }

    public static void finishInit(Scriptable proto) {
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        Connection conn = null;
        if (args.length > 0) {
            Object arg = args[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (arg instanceof Connection) {
                conn = (Connection)arg;
            }
        }
        if (conn == null) {
            throw new JavaScriptException((Object)"expected an instance of java.sql.Connection");
        }
        ScriptableConnection result = new ScriptableConnection((Scriptable)ctorObj, conn);
        return result;
    }

    public ScriptableConnection(Scriptable parent, Connection conn) {
        this.connection = conn;
        this.wrapper = Context.toObject((Object)this.connection, (Scriptable)parent);
    }

    public Object jsFunction_query(String sql, Object params, int startRow, int maxRows) throws JavaScriptException {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            Scriptable array = (Scriptable)params;
            if (array != Undefined.instance) {
                int len = (int)Context.toNumber((Object)ScriptableObject.getProperty((Scriptable)array, (String)"length"));
                for (int i = 0; i < len; ++i) {
                    Object val = ScriptableObject.getProperty((Scriptable)array, (int)i);
                    if (val instanceof Wrapper) {
                        val = ((Wrapper)val).unwrap();
                    }
                    if (val == Scriptable.NOT_FOUND) {
                        val = null;
                    }
                    stmt.setObject(i + 1, val);
                }
            }
            ResultSet rs = stmt.executeQuery();
            if (maxRows == 0) {
                maxRows = -1;
            }
            ScriptableResult s = new ScriptableResult((Scriptable)this, rs, startRow, maxRows);
            s.setParentScope(ScriptableConnection.getTopLevelScope((Scriptable)this));
            s.setPrototype(ScriptableConnection.getClassPrototype((Scriptable)this, (String)s.getClassName()));
            return s;
        }
        catch (Exception e) {
            throw new JavaScriptException((Object)e);
        }
    }

    public int jsFunction_update(String sql, Object params) throws JavaScriptException {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            Scriptable array = (Scriptable)params;
            if (array != Undefined.instance) {
                int len = (int)Context.toNumber((Object)ScriptableObject.getProperty((Scriptable)array, (String)"length"));
                for (int i = 0; i < len; ++i) {
                    Object val = ScriptableObject.getProperty((Scriptable)array, (int)i);
                    if (val instanceof Wrapper) {
                        val = ((Wrapper)val).unwrap();
                    }
                    if (val == Scriptable.NOT_FOUND) {
                        val = null;
                    }
                    stmt.setObject(i + 1, val);
                }
            }
            stmt.execute();
            return stmt.getUpdateCount();
        }
        catch (Exception e) {
            throw new JavaScriptException((Object)e);
        }
    }

    public Object get(String name, Scriptable start) {
        Object result;
        if (this.wrapper != null && (result = this.wrapper.get(name, this.wrapper)) != NOT_FOUND) {
            return ScriptableConnection.wrap((Scriptable)this, this.wrapper, result);
        }
        return super.get(name, start);
    }

    public boolean has(String name, Scriptable start) {
        if (this.wrapper != null && this.wrapper.has(name, this.wrapper)) {
            return true;
        }
        return super.has(name, start);
    }

    public boolean has(int index, Scriptable start) {
        if (this.wrapper != null && this.wrapper.has(index, start)) {
            return true;
        }
        return super.has(index, start);
    }

    public Object get(int index, Scriptable start) {
        Object result;
        if (this.wrapper != null && (result = this.wrapper.get(index, start)) != NOT_FOUND) {
            return ScriptableConnection.wrap((Scriptable)this, this.wrapper, result);
        }
        return super.get(index, start);
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.wrapper != null) {
            this.wrapper.put(name, this.wrapper, value);
            return;
        }
        super.put(name, start, value);
    }
}

