/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.pipeline.impl.NonCachingProcessingPipeline;
import org.apache.cocoon.components.profiler.EnvironmentInfo;
import org.apache.cocoon.components.profiler.Profiler;
import org.apache.cocoon.components.profiler.ProfilerData;
import org.apache.cocoon.components.profiler.ProfilingXMLPipe;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.sitemap.SitemapModelComponent;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.xml.sax.SAXException;

public class ProfilingNonCachingProcessingPipeline
extends NonCachingProcessingPipeline
implements Disposable {
    private Profiler profiler;
    private ProfilerData data = null;
    private int index = 0;

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        this.profiler = (Profiler)manager.lookup(Profiler.ROLE);
    }

    public void dispose() {
        if (this.profiler != null) {
            this.manager.release((Component)this.profiler);
            this.profiler = null;
        }
    }

    public void recycle() {
        this.data = null;
        this.index = 0;
        super.recycle();
    }

    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        super.setGenerator(role, source, param, hintParam);
        if (this.data == null) {
            this.data = new ProfilerData();
        }
        this.data.addComponent(this.generator, role, source);
    }

    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        super.addTransformer(role, source, param, hintParam);
        if (this.data == null) {
            this.data = new ProfilerData();
        }
        this.data.addComponent(this.transformers.get(this.transformers.size() - 1), role, source);
    }

    public void setSerializer(String role, String source, Parameters param, Parameters hintParam, String mimeType) throws ProcessingException {
        super.setSerializer(role, source, param, hintParam, mimeType);
        if (this.data == null) {
            this.data = new ProfilerData();
        }
        this.data.addComponent(this.serializer, role, source);
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws ProcessingException {
        super.setReader(role, source, param, mimeType);
        if (this.data == null) {
            this.data = new ProfilerData();
        }
        this.data.addComponent(this.reader, role, source);
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        block8: {
            try {
                long time = System.currentTimeMillis();
                this.generator.setup((SourceResolver)environment, environment.getObjectModel(), this.generatorSource, this.generatorParam);
                this.data.setSetupTime(0, System.currentTimeMillis() - time);
                Iterator transformerItt = this.transformers.iterator();
                Iterator transformerSourceItt = this.transformerSources.iterator();
                Iterator transformerParamItt = this.transformerParams.iterator();
                int index = 1;
                while (transformerItt.hasNext()) {
                    Transformer trans = (Transformer)transformerItt.next();
                    time = System.currentTimeMillis();
                    trans.setup((SourceResolver)environment, environment.getObjectModel(), (String)transformerSourceItt.next(), (Parameters)transformerParamItt.next());
                    this.data.setSetupTime(index++, System.currentTimeMillis() - time);
                }
                time = System.currentTimeMillis();
                if (this.serializer instanceof SitemapModelComponent) {
                    ((SitemapModelComponent)this.serializer).setup((SourceResolver)environment, environment.getObjectModel(), this.serializerSource, this.serializerParam);
                }
                this.data.setSetupTime(index++, System.currentTimeMillis() - time);
                String mimeType = this.serializer.getMimeType();
                if (mimeType != null) {
                    environment.setContentType(mimeType);
                    break block8;
                }
                if (this.serializerMimeType != null) {
                    environment.setContentType(this.serializerMimeType);
                    break block8;
                }
                if (this.sitemapSerializerMimeType != null) {
                    environment.setContentType(this.sitemapSerializerMimeType);
                    break block8;
                }
                String message = "Unable to determine MIME type for " + environment.getURIPrefix() + "/" + environment.getURI();
                throw new ProcessingException(message);
            }
            catch (SAXException e) {
                throw new ProcessingException("Could not setup pipeline.", (Throwable)e);
            }
            catch (IOException e) {
                throw new ProcessingException("Could not setup pipeline.", (Throwable)e);
            }
        }
    }

    public boolean process(Environment environment) throws ProcessingException {
        this.index = 0;
        if (this.data != null) {
            this.data.setEnvironmentInfo(new EnvironmentInfo(environment));
            long time = System.currentTimeMillis();
            boolean result = super.process(environment);
            this.data.setTotalTime(System.currentTimeMillis() - time);
            this.profiler.addResult(environment.getURI(), this.data);
            return result;
        }
        this.getLogger().warn("Profiler Data havn't any components to measure");
        return super.process(environment);
    }

    protected void connect(Environment environment, XMLProducer producer, XMLConsumer consumer) throws ProcessingException {
        ProfilingXMLPipe connector = new ProfilingXMLPipe();
        connector.setup(this.index, this.data);
        ++this.index;
        super.connect(environment, producer, (XMLConsumer)connector);
        super.connect(environment, (XMLProducer)connector, consumer);
    }
}

