/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.serialization.XMLSerializer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class QDoxSource
extends AbstractSource
implements XMLizable,
Recyclable {
    protected static final String ROOT_CLASSNAME = "java.lang.Object";
    protected static final String EMPTY = "";
    protected static final String NS_URI = "http://apache.org/cocoon/javadoc/1.0";
    protected static final String NS_PREFIX = "jd";
    protected static final String ATTR_TYPE = "NMTOKEN";
    protected static final Attributes EMPTY_ATTRS = new AttributesImpl();
    protected static final String CLASS_ELEMENT = "class";
    protected static final String CLASSNAME_ATTRIBUTE = "name";
    protected static final String PACKAGE_ATTRIBUTE = "package";
    protected static final String QNAME_ATTRIBUTE = "qname";
    protected static final String INHERIT_ELEMENT = "inherit";
    protected static final String INNERCLASSES_ELEMENT = "innerclasses";
    protected static final String NESTED_IN_ELEMENT = "nested-in";
    protected static final String IMPORTS_ELEMENT = "imports";
    protected static final String IMPORT_ELEMENT = "import";
    protected static final String IMPORT_ATTRIBUTE = "type";
    protected static final String IMPLEMENTS_ELEMENT = "implements";
    protected static final String INTERFACE_ELEMENT = "interface";
    protected static final String MODIFIERS_ELEMENT = "modifiers";
    protected static final String COMMENT_ELEMENT = "comment";
    protected static final String LINK_ELEMENT = "link";
    protected static final String LINK_CLASS_ATTRIBUTE = "class";
    protected static final String LINK_MEMBER_ATTRIBUTE = "member";
    protected static final String HREF_ATTRIBUTE = "uri";
    protected static final String TAGS_ELEMENT = "tags";
    protected static final String FIELDS_ELEMENT = "fields";
    protected static final String FIELD_ELEMENT = "field";
    protected static final String CONSTRUCTORS_ELEMENT = "constructors";
    protected static final String CONSTRUCTOR_ELEMENT = "constructor";
    protected static final String METHODS_ELEMENT = "methods";
    protected static final String METHOD_ELEMENT = "method";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String TYPE_ATTRIBUTE = "type";
    protected static final String DIMENSIONS_ATTRIBUTE = "dimensions";
    protected static final String SIGNATURE_ATTRIBUTE = "signature";
    protected static final String PARAMETERS_ELEMENT = "parameters";
    protected static final String PARAMETER_ELEMENT = "parameter";
    protected static final String THROWS_ELEMENT = "throws";
    protected static final String EXCEPTION_ELEMENT = "exception";
    protected static final int CONSTRUCTOR_MODE = 1;
    protected static final int METHOD_MODE = 2;
    protected static final int CLASS_INHERITANCE = 1;
    protected static final int INTERFACE_INHERITANCE = 2;
    protected static final int INNERCLASS_INHERITANCE = 3;
    protected static final int FIELD_INHERITANCE = 4;
    protected static final int CONSTRUCTOR_INHERITANCE = 5;
    protected static final int METHOD_INHERITANCE = 6;
    protected ServiceManager manager;
    protected Logger logger;
    protected Source javaSource;
    protected String javadocUri;
    protected String javadocClassName;
    protected JavaClass javadocClass;
    protected JavaClass containingJavadocClass;
    protected Map classMap;
    protected RE reLink;
    protected static final String RE_LINK = "\\{@link\\s+((([\\w.#,$&;\\s]+)|([\\w.#,$&;(\\s]+[\\w.#,$&;)\\s]+))\\s+([\\w()#.,$&;\\s]+)|([\\w.#,$&;\\s()]+))\\s*\\}";

    public QDoxSource(String location, Source javaSource, Logger logger, ServiceManager manager) {
        this.javadocUri = location;
        this.javaSource = javaSource;
        this.logger = logger;
        this.manager = manager;
        this.javadocClassName = this.javadocUri.substring(this.javadocUri.indexOf(58) + 1);
        try {
            this.createJavadocXml();
        }
        catch (SourceException se) {
            logger.error("Error reading source!", (Throwable)se);
        }
        catch (IOException ioe) {
            logger.error("Error reading source!", (Throwable)ioe);
        }
        try {
            this.reLink = new RE(RE_LINK);
        }
        catch (RESyntaxException rse) {
            logger.error("Regular Expression syntax error!", (Throwable)rse);
        }
    }

    public JavaClass getJavadocClass() {
        return this.javadocClass;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        if (this.javadocClass == null) {
            this.logger.error("No classfile loaded! Cannot output SAX events.");
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Outputting SAX events for class " + this.javadocClass.getFullyQualifiedName());
            this.logger.debug("  #fields: " + this.javadocClass.getFields().length);
            this.logger.debug("  #methods and constructors: " + this.javadocClass.getMethods().length);
        }
        handler.startDocument();
        handler.startPrefixMapping(NS_PREFIX, NS_URI);
        this.outputClassStartElement(handler, this.javadocClass);
        this.outputModifiers(handler, (AbstractJavaEntity)this.javadocClass);
        JavaSource parent = this.javadocClass.getParentSource();
        parent.addImport("java.lang.*");
        if (parent.getPackage().length() > 0) {
            parent.addImport(parent.getPackage() + ".*");
        } else {
            parent.addImport("*");
        }
        String[] imports = parent.getImports();
        this.saxStartElement(handler, IMPORTS_ELEMENT);
        int i = 0;
        while (i < imports.length) {
            if (imports[i].endsWith("*")) {
                this.saxStartElement(handler, IMPORT_ELEMENT, new String[][]{{"type", PACKAGE_ATTRIBUTE}});
                String imp = imports[i];
                while (imp.endsWith("*") || imp.endsWith(".")) {
                    imp = imp.substring(0, imp.length() - 1);
                }
                this.saxCharacters(handler, imp);
            } else {
                this.saxStartElement(handler, IMPORT_ELEMENT, new String[][]{{"type", "class"}});
                this.saxCharacters(handler, imports[i]);
            }
            this.saxEndElement(handler, IMPORT_ELEMENT);
            ++i;
        }
        this.saxEndElement(handler, IMPORTS_ELEMENT);
        if (!this.javadocClass.isInterface()) {
            this.outputSuperClassInheritance(handler, this.javadocClass, 1);
        }
        this.outputImplements(handler, this.javadocClass, true);
        if (this.containingJavadocClass != null) {
            this.saxStartElement(handler, NESTED_IN_ELEMENT);
            this.outputClassStartElement(handler, this.containingJavadocClass);
            this.outputModifiers(handler, (AbstractJavaEntity)this.containingJavadocClass);
            this.outputComment(handler, this.containingJavadocClass.getComment());
            this.outputTags(handler, (AbstractJavaEntity)this.containingJavadocClass);
            this.outputClassEndElement(handler, this.containingJavadocClass);
            this.saxEndElement(handler, NESTED_IN_ELEMENT);
        }
        this.outputComment(handler, this.javadocClass.getComment());
        this.outputTags(handler, (AbstractJavaEntity)this.javadocClass);
        this.outputInnerClasses(handler, this.javadocClass, true);
        this.outputFields(handler, this.javadocClass, true);
        this.outputMethods(handler, this.javadocClass, 1);
        this.outputMethods(handler, this.javadocClass, 2);
        this.outputClassEndElement(handler, this.javadocClass);
        handler.endPrefixMapping(NS_PREFIX);
        handler.endDocument();
    }

    public void recycle() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Recycling QDoxSource '" + this.javadocClassName + "'...");
        }
        this.manager = null;
        this.javaSource = null;
        this.javadocUri = null;
        this.javadocClassName = null;
        this.javadocClass = null;
        this.containingJavadocClass = null;
        this.classMap = null;
        this.logger = null;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return this.javaSource.getLastModified();
    }

    public String getMimeType() {
        return "text/xml";
    }

    public String getURI() {
        return this.javadocUri;
    }

    public SourceValidity getValidity() {
        return this.javaSource.getValidity();
    }

    public InputStream getInputStream() throws IOException, SourceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting InputStream for class " + this.javadocClass.getFullyQualifiedName());
        }
        XMLSerializer serializer = new XMLSerializer();
        ByteArrayInputStream inputStream = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);
            serializer.setOutputStream((OutputStream)outputStream);
            this.toSAX((ContentHandler)serializer);
            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (SAXException se) {
            this.logger.error("SAX exception!", (Throwable)se);
            throw new SourceException("Serializing SAX to a ByteArray failed!", (Throwable)se);
        }
        return inputStream;
    }

    protected void createJavadocXml() throws SourceException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Reading Java source " + this.javaSource.getURI());
        }
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource((Reader)new BufferedReader(new InputStreamReader(this.javaSource.getInputStream())));
        this.javadocClass = builder.getClassByName(this.javadocClassName);
        if (this.javadocClass == null) {
            int index = this.javadocUri.lastIndexOf(46);
            String containingClassName = this.javadocUri.substring(this.javadocUri.indexOf(58) + 1, index);
            String innerClassName = this.javadocUri.substring(index + 1);
            this.containingJavadocClass = builder.getClassByName(containingClassName);
            this.javadocClass = this.getJavadocInnerClass(this.containingJavadocClass, innerClassName);
        }
    }

    private String resolveMemberNameFromLink(String ref) {
        int hashIndex = ref.indexOf(35);
        if (hashIndex < 0) {
            return EMPTY;
        }
        return ref.substring(hashIndex + 1);
    }

    private String resolveClassNameFromLink(String ref) {
        String classPart = null;
        int hashIndex = ref.indexOf(35);
        classPart = hashIndex < 0 ? ref : ref.substring(0, hashIndex);
        return this.getQualifiedClassName(classPart);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getQualifiedClassName(String classPart) {
        if (classPart.length() == 0) {
            return this.javadocClass.getFullyQualifiedName();
        }
        if (classPart.equals("Object")) {
            return ROOT_CLASSNAME;
        }
        if (classPart.indexOf(46) >= 0) return classPart;
        String[] imports = this.javadocClass.getParentSource().getImports();
        ArrayList<String> classImports = new ArrayList<String>();
        ArrayList<String> packageImports = new ArrayList<String>();
        packageImports.add(this.javadocClass.getPackage());
        packageImports.add("java.lang");
        int i = 0;
        while (i < imports.length) {
            if (imports[i].endsWith(".*")) {
                packageImports.add(imports[i].substring(0, imports[i].length() - 2));
            } else if (imports[i].endsWith("*")) {
                packageImports.add(imports[i].substring(0, imports[i].length() - 1));
            } else {
                classImports.add(imports[i]);
            }
            ++i;
        }
        boolean found = false;
        int i2 = 0;
        while (!found && i2 < classImports.size()) {
            String name = (String)classImports.get(i2);
            if (name.endsWith(classPart)) {
                classPart = name;
                found = true;
            }
            ++i2;
        }
        if (found) return classPart;
        SourceResolver resolver = null;
        try {
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                int i3 = 0;
                while (!found && i3 < packageImports.size()) {
                    String name = (String)packageImports.get(i3);
                    name = name.length() == 0 ? classPart : name + '.' + classPart;
                    Source source = resolver.resolveURI("javadoc:" + name);
                    boolean bl = found = source != null && source instanceof QDoxSource;
                    if (found) {
                        classPart = name;
                    }
                    resolver.release(source);
                    ++i3;
                }
            }
            catch (ServiceException se) {
                this.logger.error("Could not find a SourceResolver!", (Throwable)se);
                Object var14_16 = null;
                if (resolver == null) return classPart;
                this.manager.release((Object)resolver);
                return classPart;
            }
            catch (MalformedURLException e) {
                Object var14_17 = null;
                if (resolver == null) return classPart;
                this.manager.release((Object)resolver);
                return classPart;
            }
            catch (SourceException e) {
                Object var14_18 = null;
                if (resolver == null) return classPart;
                this.manager.release((Object)resolver);
                return classPart;
            }
            catch (IOException e) {
                Object var14_19 = null;
                if (resolver == null) return classPart;
                this.manager.release((Object)resolver);
                return classPart;
            }
            Object var14_15 = null;
            if (resolver == null) return classPart;
            this.manager.release((Object)resolver);
            return classPart;
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (resolver == null) throw throwable;
            this.manager.release((Object)resolver);
            throw throwable;
        }
    }

    private void outputSuperClassInheritance(ContentHandler handler, JavaClass jClass, int mode) throws SAXException {
        JavaClass superClass = this.getJavadocSuperClass(jClass);
        if (superClass != null && this.hasInheritance(jClass, mode)) {
            this.outputClassInheritance(handler, superClass, mode);
        }
    }

    private void outputClassInheritance(ContentHandler handler, JavaClass jClass, int mode) throws SAXException {
        this.outputInheritStartElement(handler, jClass);
        switch (mode) {
            case 1: {
                this.outputSuperClassInheritance(handler, jClass, mode);
                break;
            }
            case 2: {
                this.outputImplements(handler, jClass, false);
                break;
            }
            case 3: {
                this.outputInnerClasses(handler, jClass, false);
                break;
            }
            case 4: {
                this.outputFields(handler, jClass, false);
                break;
            }
            case 6: {
                Type[] interfaces = jClass.getImplements();
                int i = 0;
                while (i < interfaces.length) {
                    this.logger.debug("inherit from " + interfaces[i].getValue());
                    this.outputClassInheritance(handler, this.getJavaClass(interfaces[i].getValue()), mode);
                    ++i;
                }
            }
            case 5: {
                if (mode != 6 || !jClass.isInterface()) {
                    this.outputSuperClassInheritance(handler, jClass, mode);
                }
                JavaMethod[] methods = jClass.getMethods();
                int i = 0;
                while (i < methods.length) {
                    if (mode == 6 && methods[i].getReturns() != null || mode == 5 && methods[i].getReturns() == null) {
                        this.outputMethodStartElement(handler, methods[i]);
                        this.outputMethodEndElement(handler, methods[i]);
                    }
                    ++i;
                }
                break;
            }
        }
        this.saxEndElement(handler, INHERIT_ELEMENT);
    }

    private boolean hasInheritance(JavaClass jClass, int mode) {
        JavaClass superClass = this.getJavadocSuperClass(jClass);
        boolean result = false;
        if (superClass != null) {
            switch (mode) {
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = superClass.getImplements().length > 0;
                    break;
                }
                case 3: {
                    result = superClass.getClasses().length > 0;
                    break;
                }
                case 4: {
                    result = superClass.getFields().length > 0;
                    break;
                }
                case 6: {
                    Type[] interfaces = jClass.getImplements();
                    int i = 0;
                    while (i < interfaces.length && !result) {
                        JavaClass iface = this.getJavaClass(interfaces[i].getValue());
                        result = iface != null && iface.getMethods().length > 0;
                        ++i;
                    }
                }
                case 5: {
                    JavaMethod[] methods = superClass.getMethods();
                    int i = 0;
                    while (i < methods.length && !result) {
                        result = mode == 6 && methods[i].getReturns() != null || mode == 5 && methods[i].getReturns() == null;
                        ++i;
                    }
                    break;
                }
            }
            if (!result) {
                result = this.hasInheritance(superClass, mode);
            }
        }
        return result;
    }

    private JavaClass getJavadocSuperClass(JavaClass jClass) {
        if (jClass == null) {
            throw new IllegalArgumentException("Argument 'jClass' must not be <null>!");
        }
        if (jClass.getFullyQualifiedName().equals(ROOT_CLASSNAME)) {
            return null;
        }
        JavaClass superClass = null;
        if (!jClass.isInterface()) {
            try {
                superClass = jClass.getSuperJavaClass();
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
        if (superClass == null) {
            String superJavadocClassName = null;
            if (jClass.isInterface()) {
                Type[] interfaces = jClass.getImplements();
                if (interfaces.length == 1) {
                    superJavadocClassName = interfaces[0].getValue();
                }
            } else {
                superJavadocClassName = jClass.getSuperClass().getValue();
                if (superJavadocClassName.indexOf(46) == -1 && this.getJavadocInnerClass(this.containingJavadocClass, superJavadocClassName) != null) {
                    superJavadocClassName = this.containingJavadocClass.getFullyQualifiedName() + '.' + superJavadocClassName;
                }
            }
            if (superJavadocClassName != null) {
                superClass = this.getJavaClass(superJavadocClassName);
            }
        }
        return superClass;
    }

    private JavaClass getJavadocInnerClass(JavaClass jClass, String className) {
        if (jClass != null) {
            JavaClass[] classes = jClass.getClasses();
            int i = 0;
            while (i < classes.length) {
                if (classes[i].getName().equals(className)) {
                    return classes[i];
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JavaClass getJavaClass(String className) {
        if (this.classMap != null && this.classMap.containsKey(className)) {
            return (JavaClass)this.classMap.get(className);
        }
        JavaClass jClass = null;
        SourceResolver resolver = null;
        try {
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                Source source = resolver.resolveURI("javadoc:" + className);
                if (source instanceof QDoxSource) {
                    QDoxSource javadocSource = (QDoxSource)source;
                    jClass = javadocSource.getJavadocClass();
                    if (this.classMap == null) {
                        this.classMap = new HashMap();
                    }
                    this.classMap.put(className, jClass);
                }
                resolver.release(source);
            }
            catch (ServiceException se) {
                this.logger.error("Couldn't return JavaClass!", (Throwable)se);
                Object var9_9 = null;
                if (resolver == null) return jClass;
                this.manager.release((Object)resolver);
                return jClass;
            }
            catch (MalformedURLException mue) {
                this.logger.error("Couldn't return JavaClass!", (Throwable)mue);
                Object var9_10 = null;
                if (resolver == null) return jClass;
                this.manager.release((Object)resolver);
                return jClass;
            }
            catch (SourceException se) {
                this.logger.error("Couldn't return JavaClass!", (Throwable)se);
                Object var9_11 = null;
                if (resolver == null) return jClass;
                this.manager.release((Object)resolver);
                return jClass;
            }
            catch (IOException ioe) {
                this.logger.error("Couldn't return JavaClass!", (Throwable)ioe);
                Object var9_12 = null;
                if (resolver == null) return jClass;
                this.manager.release((Object)resolver);
                return jClass;
            }
            Object var9_8 = null;
            if (resolver == null) return jClass;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (resolver == null) throw throwable;
            this.manager.release((Object)resolver);
            throw throwable;
        }
        this.manager.release((Object)resolver);
        return jClass;
    }

    private void outputModifiers(ContentHandler handler, AbstractJavaEntity entity) throws SAXException {
        String[] modifiers = entity.getModifiers();
        if (modifiers.length > 0) {
            this.saxStartElement(handler, MODIFIERS_ELEMENT);
            int i = 0;
            while (i < modifiers.length) {
                this.saxStartElement(handler, modifiers[i]);
                this.saxEndElement(handler, modifiers[i]);
                ++i;
            }
            this.saxEndElement(handler, MODIFIERS_ELEMENT);
        }
    }

    private void outputTags(ContentHandler handler, AbstractJavaEntity entity) throws SAXException {
        DocletTag[] tags = entity.getTags();
        boolean tagElementPassed = false;
        int i = 0;
        while (i < tags.length) {
            String tagName = tags[i].getName();
            String value = tags[i].getValue();
            if (!(tagElementPassed || tagName.equals(THROWS_ELEMENT) || tagName.equals("param"))) {
                this.saxStartElement(handler, TAGS_ELEMENT);
                tagElementPassed = true;
            }
            if (tagName.equals("see")) {
                this.saxStartElement(handler, tagName);
                this.outputLink(handler, value, null);
                this.saxEndElement(handler, tagName);
            } else if (!tagName.equals(THROWS_ELEMENT) && !tagName.equals("param")) {
                this.saxStartElement(handler, tagName);
                this.outputComment(handler, value);
                this.saxEndElement(handler, tagName);
            }
            ++i;
        }
        if (tagElementPassed) {
            this.saxEndElement(handler, TAGS_ELEMENT);
        }
    }

    private void outputComment(ContentHandler handler, String comment) throws SAXException {
        if (comment != null && comment.length() > 0) {
            this.saxStartElement(handler, COMMENT_ELEMENT);
            while (this.reLink.match(comment)) {
                String ref = null;
                String display = null;
                if (this.reLink.getParen(6) == null) {
                    ref = this.reLink.getParen(2);
                    display = this.reLink.getParen(5);
                } else {
                    ref = this.reLink.getParen(6);
                    display = EMPTY;
                }
                this.saxCharacters(handler, comment.substring(0, this.reLink.getParenStart(0)));
                this.outputLink(handler, ref, display);
                comment = comment.substring(this.reLink.getParenEnd(0));
            }
            this.saxCharacters(handler, comment);
            this.saxEndElement(handler, COMMENT_ELEMENT);
        }
    }

    private void outputLink(ContentHandler handler, String ref, String display) throws SAXException {
        String classPart = this.resolveClassNameFromLink(ref);
        String memberPart = this.resolveMemberNameFromLink(ref);
        String displayPart = display;
        ArrayList<String[]> attrs = new ArrayList<String[]>();
        if (classPart != null && classPart.length() > 0) {
            attrs.add(new String[]{"class", classPart});
        }
        if (memberPart != null && memberPart.length() > 0) {
            attrs.add(new String[]{LINK_MEMBER_ATTRIBUTE, memberPart});
        }
        if (display == null || display.length() == 0 && !ref.equals(classPart + "#" + memberPart)) {
            displayPart = ref.replace('#', '.');
        }
        this.saxStartElement(handler, LINK_ELEMENT, (String[][])attrs.toArray((T[])new String[][]{new String[0]}));
        this.saxCharacters(handler, displayPart);
        this.saxEndElement(handler, LINK_ELEMENT);
    }

    private void outputInnerClasses(ContentHandler handler, JavaClass jClass, boolean detailed) throws SAXException {
        JavaClass[] innerClasses = jClass.getClasses();
        if (innerClasses.length > 0 || this.hasInheritance(jClass, 3)) {
            if (detailed) {
                this.saxStartElement(handler, INNERCLASSES_ELEMENT);
            }
            this.outputSuperClassInheritance(handler, jClass, 3);
            int i = 0;
            while (i < innerClasses.length) {
                this.outputClassStartElement(handler, innerClasses[i]);
                if (detailed) {
                    this.outputModifiers(handler, (AbstractJavaEntity)innerClasses[i]);
                    this.outputComment(handler, innerClasses[i].getComment());
                    this.outputTags(handler, (AbstractJavaEntity)innerClasses[i]);
                }
                this.outputClassEndElement(handler, innerClasses[i]);
                ++i;
            }
            if (detailed) {
                this.saxEndElement(handler, INNERCLASSES_ELEMENT);
            }
        }
    }

    private void outputImplements(ContentHandler handler, JavaClass jClass, boolean detailed) throws SAXException {
        Type[] interfaces = jClass.getImplements();
        if (interfaces.length > 0 || this.hasInheritance(jClass, 2)) {
            if (detailed) {
                this.saxStartElement(handler, IMPLEMENTS_ELEMENT);
            }
            this.outputSuperClassInheritance(handler, jClass, 2);
            int i = 0;
            while (i < interfaces.length) {
                String name = interfaces[i].getValue().toString();
                String pckg = name.substring(0, name.lastIndexOf(46));
                name = name.substring(pckg.length() + 1);
                this.saxStartElement(handler, INTERFACE_ELEMENT, new String[][]{{"name", name}, {PACKAGE_ATTRIBUTE, pckg}, {QNAME_ATTRIBUTE, pckg + '.' + name}});
                this.saxEndElement(handler, INTERFACE_ELEMENT);
                ++i;
            }
            if (detailed) {
                this.saxEndElement(handler, IMPLEMENTS_ELEMENT);
            }
        }
    }

    private void outputFields(ContentHandler handler, JavaClass jClass, boolean detailed) throws SAXException {
        JavaField[] fields = jClass.getFields();
        if (fields.length > 0 || this.hasInheritance(jClass, 4)) {
            if (detailed) {
                this.saxStartElement(handler, FIELDS_ELEMENT);
            }
            this.outputSuperClassInheritance(handler, jClass, 4);
            int i = 0;
            while (i < fields.length) {
                this.saxStartElement(handler, FIELD_ELEMENT, new String[][]{{"name", fields[i].getName()}, {"type", fields[i].getType().getValue()}, {DIMENSIONS_ATTRIBUTE, Integer.toString(fields[i].getType().getDimensions())}});
                if (detailed) {
                    this.outputModifiers(handler, (AbstractJavaEntity)fields[i]);
                    this.outputComment(handler, fields[i].getComment());
                    this.outputTags(handler, (AbstractJavaEntity)fields[i]);
                }
                this.saxEndElement(handler, FIELD_ELEMENT);
                ++i;
            }
            if (detailed) {
                this.saxEndElement(handler, FIELDS_ELEMENT);
            }
        }
    }

    private void outputInheritStartElement(ContentHandler handler, JavaClass jClass) throws SAXException {
        this.saxStartElement(handler, INHERIT_ELEMENT, new String[][]{{"type", jClass.isInterface() ? INTERFACE_ELEMENT : "class"}, {"name", jClass.getName()}, {PACKAGE_ATTRIBUTE, jClass.getPackage()}, {QNAME_ATTRIBUTE, jClass.getFullyQualifiedName()}});
    }

    private void outputClassStartElement(ContentHandler handler, JavaClass jClass) throws SAXException {
        this.saxStartElement(handler, jClass.isInterface() ? INTERFACE_ELEMENT : "class", new String[][]{{"name", jClass.getName()}, {PACKAGE_ATTRIBUTE, jClass.getPackage()}, {QNAME_ATTRIBUTE, jClass.getFullyQualifiedName()}});
    }

    private void outputClassEndElement(ContentHandler handler, JavaClass jClass) throws SAXException {
        this.saxEndElement(handler, jClass.isInterface() ? INTERFACE_ELEMENT : "class");
    }

    private void outputMethods(ContentHandler handler, JavaClass jClass, int mode) throws SAXException {
        block24: {
            int i;
            String element;
            String elementGroup;
            int size = 0;
            JavaMethod[] methods = jClass.getMethods();
            if (mode == 1) {
                elementGroup = CONSTRUCTORS_ELEMENT;
                element = CONSTRUCTOR_ELEMENT;
                i = 0;
                while (i < methods.length) {
                    if (methods[i].getReturns() == null) {
                        ++size;
                    }
                    ++i;
                }
            } else {
                elementGroup = METHODS_ELEMENT;
                element = METHOD_ELEMENT;
                i = 0;
                while (i < methods.length) {
                    if (methods[i].getReturns() != null) {
                        ++size;
                    }
                    ++i;
                }
            }
            if (size <= 0 && (mode != 2 || !this.hasInheritance(jClass, 6)) && (mode != 1 || !this.hasInheritance(jClass, 5))) break block24;
            this.saxStartElement(handler, elementGroup);
            if (mode == 2) {
                this.outputSuperClassInheritance(handler, jClass, 6);
            } else {
                this.outputSuperClassInheritance(handler, jClass, 5);
            }
            i = 0;
            while (i < methods.length) {
                block27: {
                    Type[] exceptions;
                    int splitIndex;
                    block26: {
                        block25: {
                            if (mode != 2 || methods[i].getReturns() == null) break block25;
                            this.outputMethodStartElement(handler, methods[i]);
                            break block26;
                        }
                        if (mode != 1 || methods[i].getReturns() != null) break block27;
                        this.saxStartElement(handler, CONSTRUCTOR_ELEMENT, new String[][]{{"name", methods[i].getName()}, {SIGNATURE_ATTRIBUTE, this.getSignature(methods[i])}});
                    }
                    JavaParameter[] params = methods[i].getParameters();
                    DocletTag[] paramTags = methods[i].getTagsByName("param");
                    DocletTag[] throwsTags = methods[i].getTagsByName(THROWS_ELEMENT);
                    this.outputModifiers(handler, (AbstractJavaEntity)methods[i]);
                    this.outputComment(handler, methods[i].getComment());
                    this.outputTags(handler, (AbstractJavaEntity)methods[i]);
                    if (params.length > 0) {
                        this.saxStartElement(handler, PARAMETERS_ELEMENT);
                        int j = 0;
                        while (j < params.length) {
                            String paramName = params[j].getName();
                            this.saxStartElement(handler, PARAMETER_ELEMENT, new String[][]{{"name", paramName}, {"type", params[j].getType().getValue()}, {DIMENSIONS_ATTRIBUTE, Integer.toString(params[j].getType().getDimensions())}});
                            int k = 0;
                            while (k < paramTags.length) {
                                String paramValueName;
                                String paramValue = paramTags[k].getValue();
                                splitIndex = paramValue.indexOf(32);
                                String string = paramValueName = splitIndex > 0 ? paramValue.substring(0, splitIndex) : paramValue;
                                if (paramName.equals(paramValueName)) {
                                    this.outputComment(handler, splitIndex > 0 ? paramValue.substring(splitIndex + 1) : EMPTY);
                                }
                                ++k;
                            }
                            this.saxEndElement(handler, PARAMETER_ELEMENT);
                            ++j;
                        }
                        this.saxEndElement(handler, PARAMETERS_ELEMENT);
                    }
                    if ((exceptions = methods[i].getExceptions()).length + throwsTags.length > 0) {
                        this.saxStartElement(handler, THROWS_ELEMENT);
                        int j = 0;
                        while (j < exceptions.length) {
                            String exceptionName = exceptions[j].getValue();
                            this.saxStartElement(handler, EXCEPTION_ELEMENT, new String[][]{{"name", exceptionName}});
                            if (throwsTags.length > 0) {
                                String exceptionClassName = exceptionName.substring(exceptionName.lastIndexOf(46));
                                int k = 0;
                                while (k < throwsTags.length) {
                                    String excValueName;
                                    String excValue = throwsTags[k].getValue();
                                    int splitIndex2 = excValue.indexOf(32);
                                    String string = excValueName = splitIndex2 > 0 ? excValue.substring(0, splitIndex2) : excValue;
                                    if (exceptionClassName.equals(excValueName)) {
                                        this.outputComment(handler, splitIndex2 > 0 ? excValue.substring(splitIndex2 + 1) : EMPTY);
                                    }
                                    ++k;
                                }
                            }
                            this.saxEndElement(handler, EXCEPTION_ELEMENT);
                            ++j;
                        }
                        int j2 = 0;
                        while (j2 < throwsTags.length) {
                            String content = throwsTags[j2].getValue();
                            splitIndex = content.indexOf(32);
                            String exceptionName = content.substring(0, splitIndex);
                            String qualifiedExceptionName = this.getQualifiedClassName(exceptionName);
                            boolean found = false;
                            int k = 0;
                            while (!found && k < exceptions.length) {
                                found = qualifiedExceptionName.equals(exceptions[k].getValue());
                                ++k;
                            }
                            if (!found) {
                                this.saxStartElement(handler, EXCEPTION_ELEMENT, new String[][]{{"name", qualifiedExceptionName}});
                                this.outputComment(handler, splitIndex > 0 ? content.substring(splitIndex + 1) : EMPTY);
                                this.saxEndElement(handler, EXCEPTION_ELEMENT);
                            }
                            ++j2;
                        }
                        this.saxEndElement(handler, THROWS_ELEMENT);
                    }
                    this.saxEndElement(handler, element);
                }
                ++i;
            }
            this.saxEndElement(handler, elementGroup);
        }
    }

    private String getSignature(JavaMethod javaMethod) {
        StringBuffer sb = new StringBuffer(javaMethod.getName());
        sb.append('(');
        JavaParameter[] params = javaMethod.getParameters();
        int j = 0;
        while (j < params.length) {
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(params[j].getType().getValue());
            int dims = params[j].getType().getDimensions();
            int k = 0;
            while (k < dims) {
                sb.append("[]");
                ++k;
            }
            ++j;
        }
        sb.append(')');
        return sb.toString();
    }

    private void outputMethodStartElement(ContentHandler handler, JavaMethod javaMethod) throws SAXException {
        if (javaMethod.getReturns() != null) {
            this.saxStartElement(handler, METHOD_ELEMENT, new String[][]{{"name", javaMethod.getName()}, {"type", javaMethod.getReturns().getValue()}, {DIMENSIONS_ATTRIBUTE, Integer.toString(javaMethod.getReturns().getDimensions())}, {SIGNATURE_ATTRIBUTE, this.getSignature(javaMethod)}});
        } else {
            this.saxStartElement(handler, CONSTRUCTOR_ELEMENT, new String[][]{{"name", javaMethod.getName()}, {SIGNATURE_ATTRIBUTE, this.getSignature(javaMethod)}});
        }
    }

    private void outputMethodEndElement(ContentHandler handler, JavaMethod javaMethod) throws SAXException {
        if (javaMethod.getReturns() != null) {
            this.saxEndElement(handler, METHOD_ELEMENT);
        } else {
            this.saxEndElement(handler, CONSTRUCTOR_ELEMENT);
        }
    }

    private void saxStartElement(ContentHandler handler, String localName) throws SAXException {
        handler.startElement(NS_URI, localName, "jd:" + localName, EMPTY_ATTRS);
    }

    private void saxStartElement(ContentHandler handler, String localName, String[][] attrs) throws SAXException {
        AttributesImpl saxAttrs = new AttributesImpl();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].length == 2) {
                saxAttrs.addAttribute(EMPTY, attrs[i][0], attrs[i][0], ATTR_TYPE, attrs[i][1]);
            } else if (attrs[i].length == 5) {
                saxAttrs.addAttribute(attrs[i][0], attrs[i][1], attrs[i][2], attrs[i][3], attrs[i][4]);
            }
            ++i;
        }
        handler.startElement(NS_URI, localName, "jd:" + localName, saxAttrs);
    }

    private void saxEndElement(ContentHandler handler, String localName) throws SAXException {
        handler.endElement(NS_URI, localName, "jd:" + localName);
    }

    private void saxCharacters(ContentHandler handler, String text) throws SAXException {
        if (text != null && text.length() > 0) {
            handler.characters(text.toCharArray(), 0, text.length());
        }
    }

    public boolean exists() {
        return true;
    }
}

