/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.QDoxSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public final class QDoxSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable,
Configurable,
ThreadSafe {
    protected static final String INCLUDE_INHERITANCE_ELEMENT = "include-inheritance";
    protected static final String VALUE_ATTRIBUTE = "value";
    protected static final String SOURCE_GROUP_ELEMENT = "source-roots";
    protected static final String GROUP_ATTRIBUTE = "group";
    protected static final String SOURCE_ROOT_ELEMENT = "source-root";
    protected static final String URI_ATTRIBUTE = "uri";
    protected ServiceManager manager;
    protected List sourceRootUris;
    protected RE rePackageClass;
    protected RE rePackageClassInnerclass;

    public Source getSource(String location, Map parameters) throws MalformedURLException, IOException, SourceException {
        String className = location.substring(location.indexOf(58) + 1);
        Source javaSource = null;
        if (className.length() > 0) {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("getSource called with className=" + className);
                }
                javaSource = this.getSource(className);
            }
            catch (ServiceException se) {
                throw new SourceException("SourceResolver not found", (Throwable)se);
            }
        } else {
            throw new MalformedURLException();
        }
        Source result = null;
        if (javaSource != null) {
            return new QDoxSource(location, javaSource, this.getLogger(), this.manager);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("returning source=" + result + " for className=" + className);
        }
        return result;
    }

    public void service(ServiceManager manager) throws ServiceException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Composing the QDoxSourceFactory...");
        }
        this.manager = manager;
        try {
            this.rePackageClass = new RE("([$\\w.]+)\\.([$\\w]+)");
            this.rePackageClassInnerclass = new RE("([$\\w.]+)\\.([$\\w]+)\\.([$\\w]+)");
        }
        catch (RESyntaxException e) {
            this.getLogger().error("RegExp syntax error!", (Throwable)e);
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        Configuration[] sourceRootGroups = config.getChildren(SOURCE_GROUP_ELEMENT);
        this.sourceRootUris = new ArrayList();
        int i = 0;
        while (i < sourceRootGroups.length) {
            Configuration[] sourceRootConfigs = sourceRootGroups[i].getChildren(SOURCE_ROOT_ELEMENT);
            int j = 0;
            while (j < sourceRootConfigs.length) {
                String uri = sourceRootConfigs[j].getAttribute(URI_ATTRIBUTE);
                this.sourceRootUris.add(new SourceRoot(uri));
                ++j;
            }
            ++i;
        }
        if (this.sourceRootUris.size() == 0 && this.getLogger().isErrorEnabled()) {
            this.getLogger().error("No source roots configured!");
        }
    }

    public void release(Source source) {
    }

    private Source getSource(String className) throws ServiceException {
        SourceResolver resolver;
        String classFileName = className;
        String packageName = this.rePackageClass.match(className) ? this.rePackageClass.getParen(1) : "";
        Source source = this.getSource(classFileName = classFileName.replace('.', '/') + ".java", packageName, resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE));
        if (source == null && this.rePackageClassInnerclass.match(className)) {
            packageName = this.rePackageClassInnerclass.getParen(1);
            classFileName = className.substring(0, className.lastIndexOf(46)).replace('.', '/') + ".java";
            source = this.getSource(classFileName, packageName, resolver);
        }
        this.manager.release((Object)resolver);
        if (source == null && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("No source found for class '" + className + "'!");
        }
        return source;
    }

    private Source getSource(String classFileName, String packageName, SourceResolver resolver) {
        Iterator i = this.sourceRootUris.iterator();
        while (i.hasNext()) {
            String uri;
            Source source;
            SourceRoot sourceRoot = (SourceRoot)i.next();
            if (!sourceRoot.hasPackage(packageName) || (source = this.getSource(uri = sourceRoot.getUri() + classFileName, resolver)) == null) continue;
            return source;
        }
        Iterator i2 = this.sourceRootUris.iterator();
        while (i2.hasNext()) {
            SourceRoot sourceRoot = (SourceRoot)i2.next();
            String uri = sourceRoot.getUri() + classFileName;
            Source source = this.getSource(uri, resolver);
            if (source == null) continue;
            sourceRoot.addPackage(packageName);
            return source;
        }
        return null;
    }

    private Source getSource(String uri, SourceResolver resolver) {
        block5: {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Testing uri <" + uri + ">...");
            }
            try {
                Source source = resolver.resolveURI(uri);
                if (source != null && source.getInputStream() != null) {
                    return source;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("uri <" + uri + "> is invalid.");
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block5;
                this.getLogger().debug("uri <" + uri + "> is invalid: " + e.getClass().getName() + " says " + e.getMessage());
            }
        }
        return null;
    }

    protected final class SourceRoot {
        private List packages;
        private String sourceRootUri;

        protected SourceRoot(String uri) {
            if (!uri.endsWith(File.separator)) {
                uri = uri + '/';
            }
            this.sourceRootUri = uri;
            this.packages = new ArrayList();
        }

        protected void addPackage(String packageName) {
            this.packages.add(packageName);
        }

        protected boolean hasPackage(String packageName) {
            return this.packages.contains(packageName);
        }

        protected String getUri() {
            return this.sourceRootUri;
        }
    }
}

