/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.repository;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.repository.RepositoryInterceptor;
import org.apache.cocoon.components.repository.RepositoryInterceptorBase;
import org.apache.cocoon.components.repository.SourceRepository;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.TraversableSource;

public class SourceRepositoryImpl
extends AbstractLogEnabled
implements Serviceable,
ThreadSafe,
SourceRepository {
    private RepositoryInterceptor m_interceptor = new RepositoryInterceptorBase(){};
    private SourceResolver m_resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        if (manager.hasService(RepositoryInterceptor.ROLE)) {
            this.m_interceptor = (RepositoryInterceptor)manager.lookup(RepositoryInterceptor.ROLE);
        }
    }

    public int save(String in, String out) throws IOException, SourceException {
        int n;
        Source destination;
        block19: {
            boolean exists;
            Source source;
            block17: {
                int n2;
                block18: {
                    block15: {
                        int n3;
                        block16: {
                            Source parent;
                            block13: {
                                int n4;
                                block14: {
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("save: " + in + "/" + out);
                                    }
                                    source = null;
                                    destination = null;
                                    destination = this.m_resolver.resolveURI(out);
                                    if (destination instanceof ModifiableSource) break block13;
                                    String message = "Conflict during save(): protocol is not modifiable.";
                                    this.getLogger().warn("Conflict during save(): protocol is not modifiable.");
                                    n4 = 409;
                                    Object var10_11 = null;
                                    if (source == null) break block14;
                                    this.m_resolver.release(source);
                                }
                                if (destination != null) {
                                    this.m_resolver.release(destination);
                                }
                                return n4;
                            }
                            exists = destination.exists();
                            if (exists || (parent = ((TraversableSource)destination).getParent()).exists()) break block15;
                            String message = "Conflict during save(): parent does not exist.";
                            this.getLogger().warn("Conflict during save(): parent does not exist.");
                            n3 = 409;
                            Object var10_12 = null;
                            if (source == null) break block16;
                            this.m_resolver.release(source);
                        }
                        if (destination != null) {
                            this.m_resolver.release(destination);
                        }
                        return n3;
                    }
                    if (!(destination instanceof TraversableSource) || !((TraversableSource)destination).isCollection()) break block17;
                    String message = "Conflict during save(): destination is a collection.";
                    this.getLogger().warn("Conflict during save(): destination is a collection.");
                    n2 = 409;
                    Object var10_13 = null;
                    if (source == null) break block18;
                    this.m_resolver.release(source);
                }
                if (destination != null) {
                    this.m_resolver.release(destination);
                }
                return n2;
            }
            try {
                int status = exists ? 200 : 201;
                source = this.m_resolver.resolveURI(in);
                this.m_interceptor.preStoreSource(destination);
                SourceUtil.copy((Source)source, (Source)destination);
                this.m_interceptor.postStoreSource(destination);
                n = status;
                Object var10_14 = null;
                if (source == null) break block19;
            }
            catch (IOException e) {
                try {
                    this.getLogger().error("Unexpected exception during save().", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    block20: {
                        Object var10_15 = null;
                        if (source != null) {
                            this.m_resolver.release(source);
                        }
                        if (destination == null) break block20;
                        this.m_resolver.release(destination);
                    }
                    throw throwable;
                }
            }
            this.m_resolver.release(source);
        }
        if (destination != null) {
            this.m_resolver.release(destination);
        }
        return n;
    }

    public int makeCollection(String location) throws IOException, SourceException {
        int message4;
        Source parent;
        block19: {
            Source source;
            block17: {
                int n;
                block18: {
                    block15: {
                        int n2;
                        block16: {
                            block13: {
                                int n3;
                                block14: {
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("makeCollection: " + location);
                                    }
                                    source = null;
                                    parent = null;
                                    source = this.m_resolver.resolveURI(location);
                                    if (!source.exists()) break block13;
                                    String message2 = "makeCollection() is not allowed: the resource already exists.";
                                    this.getLogger().warn("makeCollection() is not allowed: the resource already exists.");
                                    n3 = 405;
                                    Object var7_12 = null;
                                    if (source == null) break block14;
                                    this.m_resolver.release(source);
                                }
                                if (parent != null) {
                                    this.m_resolver.release(parent);
                                }
                                return n3;
                            }
                            if (source instanceof ModifiableTraversableSource) break block15;
                            String message3 = "Conflict in makeCollection(): source is not modifiable traversable.";
                            this.getLogger().warn("Conflict in makeCollection(): source is not modifiable traversable.");
                            n2 = 409;
                            Object var7_13 = null;
                            if (source == null) break block16;
                            this.m_resolver.release(source);
                        }
                        if (parent != null) {
                            this.m_resolver.release(parent);
                        }
                        return n2;
                    }
                    parent = ((TraversableSource)source).getParent();
                    if (parent.exists()) break block17;
                    String message4 = "Conflict in makeCollection(): parent does not exist.";
                    this.getLogger().warn("Conflict in makeCollection(): parent does not exist.");
                    n = 409;
                    Object var7_14 = null;
                    if (source == null) break block18;
                    this.m_resolver.release(source);
                }
                if (parent != null) {
                    this.m_resolver.release(parent);
                }
                return n;
            }
            try {
                this.m_interceptor.preStoreSource(source);
                ((ModifiableTraversableSource)source).makeCollection();
                this.m_interceptor.postStoreSource(source);
                message4 = 201;
                Object var7_15 = null;
                if (source == null) break block19;
            }
            catch (IOException e) {
                try {
                    this.getLogger().error("Unexpected exception during makeCollection().", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    block20: {
                        Object var7_16 = null;
                        if (source != null) {
                            this.m_resolver.release(source);
                        }
                        if (parent == null) break block20;
                        this.m_resolver.release(parent);
                    }
                    throw throwable;
                }
            }
            this.m_resolver.release(source);
        }
        if (parent != null) {
            this.m_resolver.release(parent);
        }
        return message4;
    }

    public int remove(String location) throws IOException, SourceException {
        int message2;
        block7: {
            Source source;
            block5: {
                int n;
                block6: {
                    source = null;
                    source = this.m_resolver.resolveURI(location);
                    if (source.exists()) break block5;
                    String message2 = "Trying to remove a non-existing source.";
                    this.getLogger().warn("Trying to remove a non-existing source.");
                    n = 404;
                    Object var6_7 = null;
                    if (source == null) break block6;
                    this.m_resolver.release(source);
                }
                return n;
            }
            try {
                message2 = this.remove(source);
                Object var6_8 = null;
                if (source == null) break block7;
            }
            catch (IOException e) {
                try {
                    this.getLogger().error("Unexpected exception during remove().", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var6_9 = null;
                        if (source == null) break block8;
                        this.m_resolver.release(source);
                    }
                    throw throwable;
                }
            }
            this.m_resolver.release(source);
        }
        return message2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int remove(Source source) throws SourceException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("remove: " + source.getURI());
        }
        if (!(source instanceof ModifiableSource)) {
            String message = "Conflict in remove(): source is not modifiable";
            this.getLogger().warn("Conflict in remove(): source is not modifiable");
            return 409;
        }
        if (source instanceof TraversableSource && ((TraversableSource)source).isCollection()) {
            int status = 200;
            Iterator iter = ((TraversableSource)source).getChildren().iterator();
            while (iter.hasNext()) {
                Object var7_6;
                Source child;
                block8: {
                    int n;
                    block9: {
                        child = null;
                        try {
                            status = this.remove((Source)iter.next());
                            if (status == 200) break block8;
                            n = status;
                            var7_6 = null;
                            if (child == null) break block9;
                        }
                        catch (Throwable throwable) {
                            var7_6 = null;
                            if (child != null) {
                                this.m_resolver.release(child);
                            }
                            throw throwable;
                        }
                        this.m_resolver.release(child);
                    }
                    return n;
                }
                var7_6 = null;
                if (child == null) continue;
                this.m_resolver.release(child);
                {
                }
            }
        }
        this.m_interceptor.preRemoveSource(source);
        ((ModifiableSource)source).delete();
        this.m_interceptor.postRemoveSource(source);
        return 200;
    }

    public int move(String from, String to, boolean recurse, boolean overwrite) throws IOException, SourceException {
        int status = this.doCopy(from, to, recurse, overwrite);
        if (status == 201 || status == 204) {
            this.remove(from);
        }
        return status;
    }

    public int copy(String from, String to, boolean recurse, boolean overwrite) throws IOException, SourceException {
        return this.doCopy(from, to, recurse, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doCopy(String from, String to, boolean recurse, boolean overwrite) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("copy: " + from + " -> " + to + " (recurse=" + recurse + ", overwrite=" + overwrite + ")");
        }
        if (from != null && from.equals(to)) {
            String message = "copy() is forbidden: The source and destination URIs are the same.";
            this.getLogger().warn("copy() is forbidden: The source and destination URIs are the same.");
            return 403;
        }
        Source source = null;
        Source destination = null;
        try {
            int n;
            block20: {
                try {
                    int status;
                    source = this.m_resolver.resolveURI(from);
                    destination = this.m_resolver.resolveURI(to);
                    if (!source.exists()) {
                        String message = "Trying to copy a non-existing source.";
                        this.getLogger().warn("Trying to copy a non-existing source.");
                        int n2 = 404;
                        Object var14_15 = null;
                        if (source != null) {
                            this.m_resolver.release(source);
                        }
                        if (destination == null) return n2;
                        this.m_resolver.release(destination);
                        return n2;
                    }
                    if (destination.exists()) {
                        if (!overwrite) {
                            String message = "Failed precondition in copy(): Destination resource already exists.";
                            this.getLogger().warn("Failed precondition in copy(): Destination resource already exists.");
                            int n3 = 412;
                            Object var14_16 = null;
                            if (source != null) {
                                this.m_resolver.release(source);
                            }
                            if (destination == null) return n3;
                            this.m_resolver.release(destination);
                            return n3;
                        }
                        this.remove(destination);
                        status = 204;
                    } else {
                        Source parent;
                        block18: {
                            int n4;
                            block19: {
                                parent = null;
                                try {
                                    parent = this.getParent(destination);
                                    if (parent.exists()) break block18;
                                    String message = "Conflict in copy(): A resource cannot be created at the destination until one or more intermediate collections have been created.";
                                    this.getLogger().warn("Conflict in copy(): A resource cannot be created at the destination until one or more intermediate collections have been created.");
                                    n4 = 409;
                                    Object var12_23 = null;
                                    if (parent == null) break block19;
                                }
                                catch (Throwable throwable) {
                                    Object var12_25 = null;
                                    if (parent == null) throw throwable;
                                    this.m_resolver.release(parent);
                                    throw throwable;
                                }
                                this.m_resolver.release(parent);
                            }
                            Object var14_17 = null;
                            if (source != null) {
                                this.m_resolver.release(source);
                            }
                            if (destination == null) return n4;
                            this.m_resolver.release(destination);
                            return n4;
                        }
                        Object var12_24 = null;
                        if (parent != null) {
                            this.m_resolver.release(parent);
                        }
                        status = 201;
                    }
                    this.copy(source, destination, recurse);
                    n = status;
                    Object var14_18 = null;
                    if (source == null) break block20;
                }
                catch (IOException e) {
                    this.getLogger().error("Unexpected exception during copy().", (Throwable)e);
                    throw e;
                }
                this.m_resolver.release(source);
            }
            if (destination == null) return n;
            this.m_resolver.release(destination);
            return n;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (source != null) {
                this.m_resolver.release(source);
            }
            if (destination == null) throw throwable;
            this.m_resolver.release(destination);
            throw throwable;
        }
    }

    private int copy(Source source, Source destination, boolean recurse) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("copy: " + source.getURI() + " -> " + destination.getURI());
        }
        if (source instanceof TraversableSource) {
            TraversableSource origin = (TraversableSource)source;
            ModifiableTraversableSource target = null;
            if (origin.isCollection()) {
                if (!(destination instanceof ModifiableTraversableSource)) {
                    String message = "copy() is forbidden: Cannot create a collection at the indicated destination.";
                    this.getLogger().warn("copy() is forbidden: Cannot create a collection at the indicated destination.");
                    return 403;
                }
                target = (ModifiableTraversableSource)destination;
                this.m_interceptor.preStoreSource((Source)target);
                target.makeCollection();
                this.m_interceptor.postStoreSource((Source)target);
                if (recurse) {
                    Iterator children = origin.getChildren().iterator();
                    while (children.hasNext()) {
                        TraversableSource child = (TraversableSource)children.next();
                        int status = this.copy((Source)child, target.getChild(child.getName()), recurse);
                    }
                }
                return 201;
            }
        }
        if (!(destination instanceof ModifiableSource)) {
            String message = "copy() is forbidden: Cannot create a resource at the indicated destination.";
            this.getLogger().warn("copy() is forbidden: Cannot create a resource at the indicated destination.");
            return 403;
        }
        this.m_interceptor.preStoreSource(destination);
        SourceUtil.copy((Source)source, (Source)destination);
        this.m_interceptor.postStoreSource(destination);
        return 201;
    }

    private Source getParent(Source source) throws IOException {
        if (source instanceof TraversableSource) {
            return ((TraversableSource)source).getParent();
        }
        String uri = source.getURI();
        int index = uri.lastIndexOf(47);
        if (index != -1) {
            return this.m_resolver.resolveURI(uri.substring(index + 1));
        }
        return null;
    }
}

