/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.source.SourceInspector;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

public abstract class AbstractConfigurableSourceInspector
extends AbstractLogEnabled
implements SourceInspector,
Configurable {
    private Set m_properties;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] properties = configuration.getChildren("property");
        this.m_properties = new HashSet(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            String namespace = properties[i].getAttribute("namespace");
            String name = properties[i].getAttribute("name");
            if (namespace.indexOf(35) != -1 || name.indexOf(35) != -1) {
                String message = "Illegal character '#' in definition at " + properties[i].getLocation();
                throw new ConfigurationException(message);
            }
            String property = namespace + "#" + name;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Handling '" + property + "'");
            }
            this.m_properties.add(property);
        }
    }

    public SourceProperty[] getSourceProperties(Source source) throws SourceException {
        HashSet<SourceProperty> result = new HashSet<SourceProperty>();
        Iterator properties = this.m_properties.iterator();
        while (properties.hasNext()) {
            String name;
            int index;
            String property = (String)properties.next();
            String namespace = property.substring(0, index = property.indexOf(35));
            SourceProperty sp = this.doGetSourceProperty(source, namespace, name = property.substring(index + 1));
            if (sp == null) continue;
            result.add(sp);
        }
        return result.toArray(new SourceProperty[result.size()]);
    }

    public final SourceProperty getSourceProperty(Source source, String namespace, String name) throws SourceException {
        if (this.handlesProperty(namespace, name)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Getting property " + namespace + "#" + name + " for source " + source.getURI());
            }
            return this.doGetSourceProperty(source, namespace, name);
        }
        return null;
    }

    protected abstract SourceProperty doGetSourceProperty(Source var1, String var2, String var3) throws SourceException;

    public final boolean handlesProperty(String namespace, String name) {
        return this.m_properties.contains(namespace + "#" + name);
    }

    protected final Set getPropertyTypes() {
        return this.m_properties;
    }
}

