/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AbstractAggregatedValidity;

public class MultiSourceValidity
extends AbstractAggregatedValidity
implements SourceValidity {
    private long expiry;
    private long delay;
    private List uris = new ArrayList();
    private boolean isClosed = false;
    private transient SourceResolver resolver;

    public MultiSourceValidity(SourceResolver resolver, long delay) {
        this.resolver = resolver;
        this.expiry = System.currentTimeMillis() + delay;
        this.delay = delay;
    }

    public void addSource(Source src) {
        if (this.uris != null) {
            SourceValidity validity = src.getValidity();
            if (validity == null) {
                this.uris = null;
            } else {
                super.add(validity);
                this.uris.add(src.getURI());
            }
        }
    }

    public void close() {
        this.isClosed = true;
        this.resolver = null;
    }

    public int isValid() {
        if (System.currentTimeMillis() <= this.expiry) {
            return 1;
        }
        this.expiry = System.currentTimeMillis() + this.delay;
        if (this.uris == null || !this.isClosed) {
            return -1;
        }
        return this.computeStatus(null);
    }

    public int isValid(SourceValidity newValidity) {
        if (this.uris == null || !this.isClosed) {
            return -1;
        }
        if (newValidity instanceof MultiSourceValidity) {
            return this.computeStatus(((MultiSourceValidity)newValidity).resolver);
        }
        return -1;
    }

    private int computeStatus(SourceResolver resolver) {
        List validities = super.getValidities();
        block7: for (int i = 0; i < validities.size(); ++i) {
            SourceValidity validity = (SourceValidity)validities.get(i);
            switch (validity.isValid()) {
                case -1: {
                    return -1;
                }
                case 1: {
                    continue block7;
                }
                case 0: {
                    if (resolver == null) {
                        return 0;
                    }
                    try {
                        Source newSrc = resolver.resolveURI((String)this.uris.get(i));
                        int value = validity.isValid(newSrc.getValidity());
                        resolver.release(newSrc);
                        if (value == 1) continue block7;
                        return -1;
                    }
                    catch (IOException ioe) {
                        return -1;
                    }
                }
            }
        }
        return 1;
    }
}

