/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.source.InspectableSource;
import org.apache.cocoon.components.source.SourceDescriptor;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.cocoon.components.source.impl.SourceDescriptorManager;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;

public class RepositorySource
extends AbstractLogEnabled
implements Source,
ModifiableTraversableSource,
InspectableSource,
Recyclable {
    private final ModifiableTraversableSource m_delegate;
    private final ServiceManager m_manager;
    private final SourceDescriptor m_descriptor;

    public RepositorySource(ModifiableTraversableSource delegate, ServiceManager manager, Logger logger) throws SourceException {
        this.m_delegate = delegate;
        this.m_manager = manager;
        this.enableLogging(logger);
        try {
            this.m_descriptor = (SourceDescriptor)manager.lookup(SourceDescriptorManager.ROLE);
        }
        catch (ServiceException e) {
            throw new SourceException("Missing service", (Throwable)e);
        }
    }

    public void recycle() {
        if (this.m_delegate instanceof Recyclable) {
            ((Recyclable)this.m_delegate).recycle();
        }
    }

    public SourceProperty[] getSourceProperties() throws SourceException {
        ArrayList<SourceProperty> properties = new ArrayList<SourceProperty>();
        if (this.m_delegate instanceof InspectableSource) {
            properties.addAll(Arrays.asList(((InspectableSource)this.m_delegate).getSourceProperties()));
        }
        properties.addAll(Arrays.asList(this.m_descriptor.getSourceProperties((Source)this.m_delegate)));
        return properties.toArray(new SourceProperty[properties.size()]);
    }

    public SourceProperty getSourceProperty(String uri, String name) throws SourceException {
        SourceProperty property = null;
        if (this.m_delegate instanceof InspectableSource) {
            property = ((InspectableSource)this.m_delegate).getSourceProperty(uri, name);
        }
        if (property == null) {
            property = this.m_descriptor.getSourceProperty((Source)this.m_delegate, uri, name);
        }
        return property;
    }

    public void removeSourceProperty(String uri, String name) throws SourceException {
        if (this.m_delegate instanceof InspectableSource) {
            ((InspectableSource)this.m_delegate).removeSourceProperty(uri, name);
        }
        this.m_descriptor.removeSourceProperty((Source)this.m_delegate, uri, name);
    }

    public void setSourceProperty(SourceProperty property) throws SourceException {
        if (this.m_delegate instanceof InspectableSource) {
            ((InspectableSource)this.m_delegate).setSourceProperty(property);
        } else {
            this.m_descriptor.setSourceProperty((Source)this.m_delegate, property);
        }
    }

    public boolean exists() {
        return this.m_delegate.exists();
    }

    public long getContentLength() {
        return this.m_delegate.getContentLength();
    }

    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        return this.m_delegate.getInputStream();
    }

    public long getLastModified() {
        return this.m_delegate.getLastModified();
    }

    public String getMimeType() {
        return this.m_delegate.getMimeType();
    }

    public String getScheme() {
        return this.m_delegate.getScheme();
    }

    public String getURI() {
        return this.m_delegate.getURI();
    }

    public SourceValidity getValidity() {
        SourceValidity val2;
        SourceValidity val1 = this.m_delegate.getValidity();
        if (val1 != null && (val2 = this.m_descriptor.getValidity((Source)this.m_delegate)) != null) {
            AggregatedValidity result = new AggregatedValidity();
            result.add(val1);
            result.add(val2);
            return result;
        }
        return null;
    }

    public void refresh() {
        this.m_delegate.refresh();
    }

    public Source getChild(String name) throws SourceException {
        return new RepositorySource((ModifiableTraversableSource)this.m_delegate.getChild(name), this.m_manager, this.getLogger());
    }

    public Collection getChildren() throws SourceException {
        ArrayList<RepositorySource> result = new ArrayList<RepositorySource>();
        Iterator iter = this.m_delegate.getChildren().iterator();
        while (iter.hasNext()) {
            result.add(new RepositorySource((ModifiableTraversableSource)iter.next(), this.m_manager, this.getLogger()));
        }
        return result;
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public Source getParent() throws SourceException {
        return new RepositorySource((ModifiableTraversableSource)this.m_delegate.getParent(), this.m_manager, this.getLogger());
    }

    public boolean isCollection() {
        return this.m_delegate.isCollection();
    }

    public void makeCollection() throws SourceException {
        this.m_delegate.makeCollection();
    }

    public boolean canCancel(OutputStream out) {
        return this.m_delegate.canCancel(out);
    }

    public void cancel(OutputStream out) throws IOException {
        this.m_delegate.cancel(out);
    }

    public void delete() throws SourceException {
        this.m_delegate.delete();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.m_delegate.getOutputStream();
    }
}

