/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.RepositorySource;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;

public class RepositorySourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable,
Configurable,
ThreadSafe {
    private ServiceManager m_manager;
    private SourceResolver m_resolver;
    private String m_name;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_name = configuration.getAttribute("name");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
    }

    public Source getSource(String location, Map parameters) throws IOException, MalformedURLException {
        Source source;
        if (this.m_resolver == null) {
            try {
                this.m_resolver = (SourceResolver)this.m_manager.lookup(SourceResolver.ROLE);
            }
            catch (ServiceException e) {
                throw new IOException("Resolver service is not available: " + e.toString());
            }
        }
        if (!((source = this.m_resolver.resolveURI(location = location.substring(this.m_name.length() + 1))) instanceof ModifiableTraversableSource)) {
            String message = "Delegate should be a ModifiableTraversableSource";
            throw new SourceException("Delegate should be a ModifiableTraversableSource");
        }
        return new RepositorySource((ModifiableTraversableSource)source, this.m_manager, this.getLogger());
    }

    public void release(Source source) {
        ((RepositorySource)source).recycle();
    }
}

