/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.caching.EventAware;
import org.apache.cocoon.caching.validity.Event;
import org.apache.cocoon.caching.validity.EventValidity;
import org.apache.cocoon.caching.validity.NameValueEvent;
import org.apache.cocoon.components.source.SourceDescriptor;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.cocoon.components.source.impl.AbstractConfigurableSourceDescriptor;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;

public class SimpleJdbcSourceDescriptor
extends AbstractConfigurableSourceDescriptor
implements SourceDescriptor,
Serviceable,
Configurable,
Initializable,
ThreadSafe {
    private static final String STMT_SELECT_SINGLE = "SELECT value FROM sourceprops WHERE source=? AND namespace=? AND name=?;";
    private static final String STMT_SELECT_ALL = "SELECT namespace, name, value FROM sourceprops WHERE source=?;";
    private static final String STMT_INSERT = "INSERT INTO sourceprops (source,namespace,name,value) VALUES (?,?,?,?);";
    private static final String STMT_DELETE = "DELETE FROM sourceprops WHERE source=? AND namespace=? AND name=?;";
    private ServiceManager m_manager;
    private EventAware m_cache;
    private DataSourceComponent m_datasource;
    private String m_datasourceName;
    private String m_eventName;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        if (manager.hasService(Cache.ROLE + "/EventAware")) {
            this.m_cache = (EventAware)manager.lookup(Cache.ROLE + "/EventAware");
        } else {
            this.getLogger().warn("EventAware cache was not found: sources won't be cacheable.");
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.m_datasourceName = configuration.getChild("datasource", true).getValue("cocoondb");
    }

    public void initialize() throws Exception {
        ServiceSelector datasources = (ServiceSelector)this.m_manager.lookup(DataSourceComponent.ROLE + "Selector");
        this.m_datasource = (DataSourceComponent)datasources.select((Object)this.m_datasourceName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceProperty[] getSourceProperties(Source source) throws SourceException {
        SourceProperty[] sourcePropertyArray;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            try {
                connection = this.m_datasource.getConnection();
                stmt = connection.prepareStatement(STMT_SELECT_ALL);
                stmt.setString(1, source.getURI());
                ResultSet result = stmt.executeQuery();
                ArrayList<SourceProperty> properties = new ArrayList<SourceProperty>();
                while (result.next()) {
                    SourceProperty property = new SourceProperty(result.getString(1), result.getString(2), result.getString(3));
                    if (!this.handlesProperty(property.getNamespace(), property.getName())) continue;
                    properties.add(property);
                }
                result.close();
                stmt.close();
                sourcePropertyArray = properties.toArray(new SourceProperty[properties.size()]);
                Object var8_8 = null;
                if (connection == null) return sourcePropertyArray;
            }
            catch (SQLException e) {
                throw new SourceException("Error retrieving properties from database", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e2) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            // empty catch block
            return sourcePropertyArray;
        }
        connection.close();
        return sourcePropertyArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceProperty doGetSourceProperty(Source source, String namespace, String name) throws SourceException {
        SourceProperty sourceProperty;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            try {
                connection = this.m_datasource.getConnection();
                stmt = connection.prepareStatement(STMT_SELECT_SINGLE);
                stmt.setString(1, source.getURI());
                stmt.setString(2, namespace);
                stmt.setString(3, name);
                ResultSet result = stmt.executeQuery();
                SourceProperty property = null;
                if (result.next()) {
                    property = new SourceProperty(namespace, name, result.getString(1));
                }
                result.close();
                stmt.close();
                sourceProperty = property;
                Object var10_10 = null;
                if (connection == null) return sourceProperty;
            }
            catch (SQLException e) {
                throw new SourceException("Error retrieving property from database", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e2) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            // empty catch block
            return sourceProperty;
        }
        connection.close();
        return sourceProperty;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSetSourceProperty(Source source, SourceProperty property) throws SourceException {
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            try {
                connection = this.m_datasource.getConnection();
                stmt = connection.prepareStatement(STMT_DELETE);
                stmt.setString(1, source.getURI());
                stmt.setString(2, property.getNamespace());
                stmt.setString(3, property.getName());
                int count = stmt.executeUpdate();
                stmt.close();
                stmt = connection.prepareStatement(STMT_INSERT);
                stmt.setString(1, source.getURI());
                stmt.setString(2, property.getNamespace());
                stmt.setString(3, property.getName());
                stmt.setString(4, property.getValueAsString());
                stmt.close();
                connection.commit();
                if (this.m_cache != null && (count += stmt.executeUpdate()) > 0) {
                    this.m_cache.processEvent((Event)new NameValueEvent(this.m_eventName, source.getURI()));
                }
            }
            catch (SQLException e) {
                throw new SourceException("Error setting property", (Throwable)e);
            }
            Object var7_7 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        connection.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRemoveSourceProperty(Source source, String namespace, String name) throws SourceException {
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            try {
                connection = this.m_datasource.getConnection();
                stmt = connection.prepareStatement(STMT_DELETE);
                stmt.setString(1, source.getURI());
                stmt.setString(2, namespace);
                stmt.setString(3, name);
                int count = stmt.executeUpdate();
                stmt.close();
                connection.commit();
                if (this.m_cache != null && count > 0) {
                    this.m_cache.processEvent((Event)new NameValueEvent(this.m_eventName, source.getURI()));
                }
            }
            catch (SQLException e) {
                throw new SourceException("Error removing propery", (Throwable)e);
            }
            Object var8_8 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        connection.close();
        return;
    }

    public SourceValidity getValidity(Source source) {
        if (this.m_cache != null) {
            return new EventValidity((Event)new NameValueEvent(this.getEventName(), source.getURI()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getEventName() {
        if (this.m_eventName != null) return this.m_eventName;
        Connection connection = null;
        connection = this.m_datasource.getConnection();
        String catalogName = connection.getCatalog();
        this.m_eventName = catalogName != null ? catalogName + "/sourceprops" : "sourceprops";
        Object var4_4 = null;
        if (connection == null) return this.m_eventName;
        try {
            connection.close();
            return this.m_eventName;
        }
        catch (SQLException e2) {}
        return this.m_eventName;
        {
            catch (SQLException e) {
                this.getLogger().warn("Error getting catalog name from jdbc connection.", (Throwable)e);
                this.m_eventName = "sourceprops";
                Object var4_5 = null;
                if (connection == null) return this.m_eventName;
                try {
                    connection.close();
                    return this.m_eventName;
                }
                catch (SQLException e2) {}
                return this.m_eventName;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

