/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.source.InspectableSource;
import org.apache.cocoon.components.source.RestrictableSource;
import org.apache.cocoon.components.source.helpers.SourceCredential;
import org.apache.cocoon.components.source.helpers.SourcePermission;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.httpclient.HttpException;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.apache.util.HttpURL;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WebDAVSource
extends AbstractLogEnabled
implements Source,
RestrictableSource,
ModifiableTraversableSource,
InspectableSource {
    private static final String NAMESPACE = "http://apache.org/cocoon/webdav/1.0";
    private static final String PREFIX = "webdav";
    private static final String RESOURCE_NAME = "resource";
    private static final String COLLECTION_NAME = "collection";
    private String systemId;
    private String location;
    private String principal;
    private String password;
    private SourceValidity validity = null;
    private long cachedLastModificationDate;
    private SourceCredential sourcecredential = null;
    private WebdavResource resource = null;
    private String protocol;

    private WebDAVSource(String location, String principal, String password, String protocol, boolean createNew) throws HttpException, IOException {
        this.location = location;
        this.principal = principal;
        this.password = password;
        this.protocol = protocol;
        this.systemId = "http://" + location;
        HttpURL httpURL = new HttpURL(this.systemId);
        httpURL.setUserInfo(principal, password);
        this.resource = createNew ? new WebdavResource(httpURL, 1, 1) : new WebdavResource(httpURL);
    }

    /*
     * WARNING - void declaration
     */
    public static WebDAVSource newWebDAVSource(String location, String principal, String password, String protocol, Logger logger) throws SourceException {
        void var5_5;
        WebDAVSource source;
        try {
            source = new WebDAVSource(location, principal, password, protocol, false);
        }
        catch (HttpException he) {
            try {
                source = new WebDAVSource(location, principal, password, protocol, true);
            }
            catch (HttpException finalHe) {
                String message = "Error creating the source.";
                throw new SourceException("Error creating the source.", (Throwable)finalHe);
            }
            catch (IOException e) {
                String message = "Error creating the source.";
                throw new SourceException("Error creating the source.", (Throwable)e);
            }
        }
        catch (IOException e) {
            String message = "Error creating the source.";
            throw new SourceException("Error creating the source.", (Throwable)e);
        }
        var5_5.enableLogging(logger);
        return var5_5;
    }

    private WebDAVSource(WebdavResource source) throws HttpException, IOException {
        this.resource = source;
        this.systemId = source.getHttpURL().getURI();
        if (this.resource.isCollection() && !this.systemId.endsWith("/")) {
            this.systemId = this.systemId + "/";
            HttpURL httpURL = new HttpURL(this.systemId);
            this.resource.setHttpURL(httpURL);
        }
    }

    public String getScheme() {
        return this.protocol;
    }

    public InputStream getInputStream() throws IOException, SourceException {
        try {
            if (this.resource.isCollection()) {
                WebdavResource[] resources = this.resource.listWebdavResources();
                return this.resourcesToXml(resources);
            }
            BufferedInputStream bi = null;
            bi = new BufferedInputStream(this.resource.getMethodData());
            if (!this.resource.exists()) {
                throw new HttpException(this.systemId + " does not exist");
            }
            return bi;
        }
        catch (HttpException he) {
            throw new SourceException("Could not get WebDAV resource " + this.getSecureURI(), (Throwable)he);
        }
        catch (Exception e) {
            throw new SourceException("Could not get WebDAV resource" + this.getSecureURI(), (Throwable)e);
        }
    }

    public String getURI() {
        if (this.principal != null) {
            return "webdav://" + this.principal + ":" + this.password + "@" + this.systemId.substring(7);
        }
        return "webdav://" + this.systemId.substring(7);
    }

    protected String getSecureURI() {
        return "webdav://" + this.systemId.substring(7);
    }

    public SourceValidity getValidity() {
        long lm = this.getLastModified();
        if (lm > 0L) {
            if (lm == this.cachedLastModificationDate) {
                return this.validity;
            }
            this.cachedLastModificationDate = lm;
            this.validity = new TimeStampValidity(lm);
            return this.validity;
        }
        return null;
    }

    public void refresh() {
        try {
            this.resource = new WebdavResource(this.systemId);
            if (this.sourcecredential != null) {
                this.resource.setUserInfo(this.sourcecredential.getPrincipal(), this.sourcecredential.getPassword());
            }
        }
        catch (HttpException he) {
            throw new IllegalStateException(he.getMessage());
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe.getMessage());
        }
        this.validity = null;
    }

    public String getMimeType() {
        return this.resource.getGetContentType();
    }

    public long getContentLength() {
        if (this.resource.isCollection()) {
            return -1L;
        }
        return this.resource.getGetContentLength();
    }

    public long getLastModified() {
        return this.resource.getGetLastModified();
    }

    public String getParameter(String name) {
        return null;
    }

    public long getParameterAsLong(String name) {
        return -1L;
    }

    public Iterator getParameterNames() {
        return null;
    }

    public boolean exists() {
        return this.resource.getExistence();
    }

    public OutputStream getOutputStream() throws IOException {
        return new WebDAVSourceOutputStream(this.resource);
    }

    public boolean canCancel(OutputStream stream) {
        return true;
    }

    public void cancel(OutputStream stream) throws SourceException {
    }

    public SourceCredential getSourceCredential() throws SourceException {
        return this.sourcecredential;
    }

    public void setSourceCredential(SourceCredential sourcecredential) throws SourceException {
        this.sourcecredential = sourcecredential;
        if (sourcecredential == null) {
            return;
        }
        try {
            HttpURL httpURL = new HttpURL(this.systemId);
            httpURL.setUserInfo(sourcecredential.getPrincipal(), sourcecredential.getPassword());
            this.resource = new WebdavResource(httpURL);
        }
        catch (HttpException he) {
            throw new SourceException("Could not set credentials", (Throwable)he);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe.getMessage());
        }
    }

    public void setSourcePermission(SourcePermission sourcepermission) throws SourceException {
    }

    public SourcePermission[] getSourcePermissions() throws SourceException {
        return null;
    }

    public void addSourcePermission(SourcePermission sourcepermission) throws SourceException {
    }

    public void removeSourcePermission(SourcePermission sourcepermission) throws SourceException {
    }

    private InputStream resourcesToXml(WebdavResource[] resources) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        TransformerHandler th = ((SAXTransformerFactory)tf).newTransformerHandler();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(bOut);
        th.setResult(result);
        th.startDocument();
        th.startPrefixMapping(PREFIX, NAMESPACE);
        th.startElement(NAMESPACE, COLLECTION_NAME, "webdav:collection", new AttributesImpl());
        this.resourcesToSax(resources, th);
        th.endElement(NAMESPACE, COLLECTION_NAME, "webdav:collection");
        th.endPrefixMapping(PREFIX);
        th.endDocument();
        return new ByteArrayInputStream(bOut.toByteArray());
    }

    private void resourcesToSax(WebdavResource[] resources, ContentHandler handler) throws SAXException {
        for (int i = 0; i < resources.length; ++i) {
            if (this.getLogger().isDebugEnabled()) {
                String message = "RESOURCE: " + resources[i].getDisplayName();
                this.getLogger().debug(message);
            }
            if (resources[i].isCollection()) {
                String message;
                try {
                    WebdavResource[] childs = resources[i].listWebdavResources();
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addAttribute(NAMESPACE, COLLECTION_NAME, "webdav:name", "CDATA", resources[i].getDisplayName());
                    handler.startElement(NAMESPACE, COLLECTION_NAME, "webdav:collection", attrs);
                    this.resourcesToSax(childs, handler);
                    handler.endElement(NAMESPACE, COLLECTION_NAME, "webdav:collection");
                }
                catch (HttpException e) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    message = "Unable to get WebDAV children. Server responded " + e.getReasonCode() + " (" + e.getReason() + ") - " + e.getMessage();
                    this.getLogger().debug(message);
                }
                catch (SAXException e) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    message = "Unable to get WebDAV children: " + e.getMessage();
                    this.getLogger().debug(message, (Throwable)e);
                }
                catch (IOException e) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    message = "Unable to get WebDAV children: " + e.getMessage();
                    this.getLogger().debug(message, (Throwable)e);
                }
                catch (Exception e) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    message = "Unable to get WebDAV children: " + e.getMessage();
                    this.getLogger().debug(message, (Throwable)e);
                }
                continue;
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(NAMESPACE, "name", "webdav:name", "CDATA", resources[i].getDisplayName());
            handler.startElement(NAMESPACE, RESOURCE_NAME, "webdav:resource", attrs);
            handler.endElement(NAMESPACE, RESOURCE_NAME, "webdav:resource");
        }
    }

    public Source getChild(String childName) throws SourceException {
        String childLocation = this.location + "/" + childName;
        WebDAVSource source = WebDAVSource.newWebDAVSource(childLocation, this.principal, this.password, this.protocol, this.getLogger());
        source.setSourceCredential(this.getSourceCredential());
        return source;
    }

    public Collection getChildren() throws SourceException {
        ArrayList<WebDAVSource> children = new ArrayList<WebDAVSource>();
        try {
            WebdavResource[] resources = this.resource.listWebdavResources();
            for (int i = 0; i < resources.length; ++i) {
                WebDAVSource src = new WebDAVSource(resources[i]);
                children.add(src);
            }
        }
        catch (HttpException e) {
            if (this.getLogger().isDebugEnabled()) {
                String message = "Unable to get WebDAV children. Server responded " + e.getReasonCode() + " (" + e.getReason() + ") - " + e.getMessage();
                this.getLogger().debug(message);
            }
            throw new SourceException("Failed to get WebDAV collection children.", (Throwable)e);
        }
        catch (IOException e) {
            throw new SourceException("Failed to get WebDAV collection children.", (Throwable)e);
        }
        return children;
    }

    public String getName() {
        return this.resource.getDisplayName();
    }

    public Source getParent() throws SourceException {
        int last = this.location.lastIndexOf("/");
        String myLocation = this.location.substring(0, last);
        WebDAVSource wds = WebDAVSource.newWebDAVSource(myLocation, this.principal, this.password, this.protocol, this.getLogger());
        wds.setSourceCredential(this.getSourceCredential());
        return wds;
    }

    public boolean isCollection() {
        return this.resource.isCollection();
    }

    public void delete() throws SourceException {
        try {
            this.resource.deleteMethod();
        }
        catch (HttpException e) {
            throw new SourceException("Unable to delete source: " + this.getSecureURI(), (Throwable)e);
        }
        catch (IOException e) {
            throw new SourceException("Unable to delete source: " + this.getSecureURI(), (Throwable)e);
        }
    }

    public void makeCollection() throws SourceException {
        if (this.resource.exists()) {
            return;
        }
        try {
            this.resource.mkcolMethod();
        }
        catch (HttpException e) {
            throw new SourceException("Unable to create collection(s) " + this.getSecureURI(), (Throwable)e);
        }
        catch (IOException e) {
            throw new SourceException("Unable to create collection(s)" + this.getSecureURI(), (Throwable)e);
        }
    }

    public SourceProperty[] getSourceProperties() throws SourceException {
        Vector<SourceProperty> sourceproperties = new Vector<SourceProperty>();
        Enumeration props = null;
        Property prop = null;
        try {
            Enumeration responses = this.resource.propfindMethod(0);
            while (responses.hasMoreElements()) {
                ResponseEntity response = (ResponseEntity)responses.nextElement();
                props = response.getProperties();
                while (props.hasMoreElements()) {
                    prop = (Property)props.nextElement();
                    SourceProperty srcProperty = new SourceProperty(prop.getElement());
                    sourceproperties.addElement(srcProperty);
                }
            }
        }
        catch (Exception e) {
            throw new SourceException("Error getting properties", (Throwable)e);
        }
        SourceProperty[] sourcepropertiesArray = new SourceProperty[sourceproperties.size()];
        for (int i = 0; i < sourceproperties.size(); ++i) {
            sourcepropertiesArray[i] = (SourceProperty)sourceproperties.elementAt(i);
        }
        return sourcepropertiesArray;
    }

    public SourceProperty getSourceProperty(String namespace, String name) throws SourceException {
        Vector<PropertyName> propNames = new Vector<PropertyName>(1);
        propNames.add(new PropertyName(namespace, name));
        Enumeration props = null;
        Property prop = null;
        try {
            Enumeration responses = this.resource.propfindMethod(0, propNames);
            while (responses.hasMoreElements()) {
                ResponseEntity response = (ResponseEntity)responses.nextElement();
                props = response.getProperties();
                if (!props.hasMoreElements()) continue;
                prop = (Property)props.nextElement();
                return new SourceProperty(prop.getElement());
            }
        }
        catch (Exception e) {
            throw new SourceException("Error getting property: " + name, (Throwable)e);
        }
        return null;
    }

    public void removeSourceProperty(String namespace, String name) throws SourceException {
        try {
            this.resource.proppatchMethod(new PropertyName(namespace, name), "", false);
        }
        catch (Exception e) {
            throw new SourceException("Could not remove property ", (Throwable)e);
        }
    }

    public void setSourceProperty(SourceProperty sourceproperty) throws SourceException {
        try {
            Node node = null;
            NodeList list = sourceproperty.getValue().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if ((!(list.item(i) instanceof Text) || "".equals(list.item(i).getNodeValue())) && !(list.item(i) instanceof Element)) continue;
                node = list.item(i);
                break;
            }
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("omit-xml-declaration", "yes");
            String prop = XMLUtils.serializeNode((Node)node, (Properties)format);
            this.resource.proppatchMethod(new PropertyName(sourceproperty.getNamespace(), sourceproperty.getName()), prop, true);
        }
        catch (HttpException e) {
            String message = "Unable to set property. Server responded " + e.getReasonCode() + " (" + e.getReason() + ") - " + e.getMessage();
            this.getLogger().debug(message);
            throw new SourceException("Could not set property ", (Throwable)e);
        }
        catch (Exception e) {
            throw new SourceException("Could not set property ", (Throwable)e);
        }
    }

    static {
        WebdavResource.setGetUseDisk((boolean)false);
    }

    public class WebDAVSourceOutputStream
    extends ByteArrayOutputStream {
        private WebdavResource resource = null;

        protected WebDAVSourceOutputStream(WebdavResource resource) {
            this.resource = resource;
            WebdavResource.setGetUseDisk((boolean)false);
        }

        public void close() throws IOException {
            super.close();
            try {
                this.resource.putMethod(this.toByteArray());
            }
            catch (HttpException he) {
                String message = "Unable to close output stream. Server responded " + he.getReasonCode() + " (" + he.getReason() + ") - " + he.getMessage();
                WebDAVSource.this.getLogger().debug(message);
                throw new IOException(he.getMessage());
            }
        }
    }
}

