/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.WebDAVSource;
import org.apache.commons.httpclient.HttpURL;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceParameters;

public class WebDAVSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
ThreadSafe {
    public Source getSource(String location, Map parameters) throws MalformedURLException, IOException, SourceException {
        if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating source object for " + location);
        }
        String protocol = location.substring(0, location.indexOf(58));
        HttpURL url = new HttpURL("http://" + location.substring(location.indexOf(58) + 3));
        String principal = url.getUser();
        String password = url.getPassword();
        location = url.getHost() + ":" + url.getPort();
        if (url.getPathQuery() != null) {
            location = location + url.getPathQuery();
        }
        if (principal == null || password == null) {
            String queryString = url.getQuery();
            SourceParameters locationParameters = new SourceParameters(queryString);
            principal = locationParameters.getParameter("principal", principal);
            password = locationParameters.getParameter("password", password);
        }
        WebDAVSource source = WebDAVSource.newWebDAVSource(location, principal, password, protocol, this.getLogger());
        return source;
    }

    public void release(Source source) {
    }
}

