/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.OptionsMethod;
import org.apache.webdav.lib.methods.SearchMethod;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DASLTransformer
extends AbstractSAXTransformer {
    static final String PREFIX = "dasl";
    static final String QUERY_TAG = "query";
    static final String DASL_QUERY_NS = "http://cocoon.apache.org/webdav/dasl/1.0";
    static final String TARGET_URL = "target";
    static final String WEBDAV_SCHEME = "webdav://";
    static final String RESULT_ROOT_TAG = "query-result";
    static final String SUBSTITUTE_TAG = "substitute-value";
    static final String SUBSTITUTE_TAG_NAME_ATTRIBUTE = "name";
    protected static final String PATH_NODE_NAME = "path";
    protected static final String RESOURCE_NODE_NAME = "resource";
    String targetUrl;

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (name.equals(QUERY_TAG) && uri.equals(DASL_QUERY_NS)) {
            this.startRecording();
            this.targetUrl = attr.getValue(TARGET_URL);
            if (this.targetUrl == null) {
                throw new IllegalStateException("The query element must contain a \"target\" attribute");
            }
            if (this.targetUrl.startsWith(WEBDAV_SCHEME)) {
                this.targetUrl = "http://" + this.targetUrl.substring(WEBDAV_SCHEME.length());
            }
            if (!this.targetUrl.startsWith("http")) {
                throw new SAXException("Illegal value for target, must be an http:// or webdav:// URL");
            }
        } else if (name.equals(SUBSTITUTE_TAG) && uri.equals(DASL_QUERY_NS)) {
            String parName = attr.getValue(DASL_QUERY_NS, SUBSTITUTE_TAG_NAME_ATTRIBUTE);
            if (parName == null) {
                throw new IllegalStateException("Substitute value elements must have a name attribute");
            }
            String substitute = this.parameters.getParameter(parName, null);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("SUBSTITUTE VALUE " + substitute);
            }
            super.characters(substitute.toCharArray(), 0, substitute.length());
        } else {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (name.equals(QUERY_TAG) && uri.equals(DASL_QUERY_NS)) {
            DocumentFragment frag = this.endRecording();
            try {
                Properties props = XMLUtils.createPropertiesForXML((boolean)false);
                props.put("encoding", "ISO-8859-1");
                String query = XMLUtils.serializeNode((Node)frag, (Properties)props);
                this.performSearchMethod(query);
            }
            catch (ProcessingException e) {
                throw new SAXException("Unable to fetch the query data:", (Exception)((Object)e));
            }
        } else if (!name.equals(SUBSTITUTE_TAG) || !uri.equals(DASL_QUERY_NS)) {
            super.endElement(uri, name, raw);
        }
    }

    protected void performSearchMethod(String query) throws SAXException {
        try {
            DOMStreamer propertyStreamer = new DOMStreamer(this.xmlConsumer);
            OptionsMethod optionsMethod = new OptionsMethod(this.targetUrl);
            SearchMethod searchMethod = new SearchMethod(this.targetUrl, query);
            HttpURL url = new HttpURL(this.targetUrl);
            HttpState state = new HttpState();
            state.setCredentials(null, (Credentials)new UsernamePasswordCredentials(url.getUser(), url.getPassword()));
            HttpConnection conn = new HttpConnection(url.getHost(), url.getPort());
            WebdavResource resource = new WebdavResource(new HttpURL(this.targetUrl));
            if (!resource.exists()) {
                throw new SAXException("The WebDAV resource don't exist");
            }
            optionsMethod.execute(state, conn);
            if (!optionsMethod.isAllowed("SEARCH")) {
                throw new SAXException("The server don't support the SEARCH method");
            }
            searchMethod.execute(state, conn);
            Enumeration enumeration = searchMethod.getAllResponseURLs();
            this.contentHandler.startElement(DASL_QUERY_NS, RESULT_ROOT_TAG, "dasl:query-result", XMLUtils.EMPTY_ATTRIBUTES);
            while (enumeration.hasMoreElements()) {
                String path = (String)enumeration.nextElement();
                Enumeration properties = searchMethod.getResponseProperties(path);
                AttributesImpl attr = new AttributesImpl();
                attr.addAttribute(DASL_QUERY_NS, PATH_NODE_NAME, "dasl:path", "CDATA", path);
                this.contentHandler.startElement(DASL_QUERY_NS, RESOURCE_NODE_NAME, "dasl:resource", attr);
                while (properties.hasMoreElements()) {
                    BaseProperty metadata = (BaseProperty)properties.nextElement();
                    Element propertyElement = metadata.getElement();
                    propertyStreamer.stream((Node)propertyElement);
                }
                this.contentHandler.endElement(DASL_QUERY_NS, RESOURCE_NODE_NAME, "dasl:resource");
            }
            this.contentHandler.endElement(DASL_QUERY_NS, RESULT_ROOT_TAG, "dasl:query-result");
        }
        catch (SAXException e) {
            throw new SAXException("Unable to fetch the query data:", e);
        }
        catch (HttpException e1) {
            this.getLogger().error("Unable to contact Webdav server", (Throwable)e1);
            throw new SAXException("Unable to connect with server: ", (Exception)((Object)e1));
        }
        catch (IOException e2) {
            throw new SAXException("Unable to connect with server: ", e2);
        }
        catch (NullPointerException e) {
            throw new SAXException("Unable to fetch the query data:", e);
        }
        catch (Exception e) {
            throw new SAXException("Generic Error:", e);
        }
    }
}

