/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.repository.impl;

import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.repository.helpers.CredentialsToken;
import org.apache.cocoon.components.repository.helpers.RepositoryTransactionHelper;
import org.apache.cocoon.components.repository.impl.WebDAVRepository;
import org.apache.cocoon.components.webdav.WebDAVUtil;
import org.apache.commons.httpclient.HttpException;

public class WebDAVRepositoryTransactionHelper
extends AbstractLogEnabled
implements RepositoryTransactionHelper,
Serviceable,
Disposable,
Component {
    private ServiceManager manager;
    private WebDAVRepository repo;
    private CredentialsToken credentials;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void dispose() {
        this.manager = null;
    }

    public WebDAVRepositoryTransactionHelper(CredentialsToken credentials, WebDAVRepository repo) {
        this.credentials = credentials;
        this.repo = repo;
    }

    public boolean beginTran() {
        throw new UnsupportedOperationException();
    }

    public boolean commitTran() {
        throw new UnsupportedOperationException();
    }

    public boolean rollbackTran() {
        throw new UnsupportedOperationException();
    }

    public boolean lock(String uri) {
        try {
            return WebDAVUtil.getWebdavResource(this.repo.getAbsoluteURI(uri)).lockMethod();
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error locking " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error locking " + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean lock(String uri, int timeout) {
        try {
            return WebDAVUtil.getWebdavResource(this.repo.getAbsoluteURI(uri)).lockMethod(this.credentials.getPrincipal().getName(), timeout);
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error locking " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error locking " + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean unlock(String uri) {
        try {
            return WebDAVUtil.getWebdavResource(this.repo.getAbsoluteURI(uri)).unlockMethod();
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error unlocking " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error unlocking " + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsLocking() {
        return true;
    }
}

