/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem;

import codes.derive.foldem.Suit;

public class Card {
    public static final char[] LABEL = new char[]{'A', '2', '3', '4', '5', '6', '7', '8', '9', 'T', 'J', 'Q', 'K'};
    public static final int ACE = 0;
    public static final int DEUCE = 1;
    public static final int TREY = 2;
    public static final int FOUR = 3;
    public static final int FIVE = 4;
    public static final int SIX = 5;
    public static final int SEVEN = 6;
    public static final int EIGHT = 7;
    public static final int NINE = 8;
    public static final int TEN = 9;
    public static final int JACK = 10;
    public static final int QUEEN = 11;
    public static final int KING = 12;
    private final int value;
    private final Suit suit;

    public Card(int value, Suit suit) {
        this.value = value;
        this.suit = suit;
    }

    public Card(String text) {
        char[] values = text.toCharArray();
        if (values.length != 2) {
            throw new IllegalArgumentException("Invalid hand length '" + text + "'");
        }
        int value = -1;
        for (int i = 0; i < LABEL.length; ++i) {
            if (LABEL[i] != values[0]) continue;
            value = i;
            break;
        }
        if (value == -1) {
            throw new IllegalArgumentException("Invalid card shorthand '" + values[0] + "'");
        }
        this.value = value;
        Suit suit = null;
        for (Suit s : Suit.values()) {
            if (s.getShorthand() != values[1]) continue;
            suit = s;
            break;
        }
        if (suit == null) {
            throw new IllegalArgumentException("Invalid suit shorthand '" + values[1] + "'");
        }
        this.suit = suit;
    }

    public int getValue() {
        return this.value;
    }

    public Suit getSuit() {
        return this.suit;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Card other = (Card)obj;
        if (this.suit != other.suit) {
            return false;
        }
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.suit.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    public String toString() {
        return "" + LABEL[this.value] + this.suit.getShorthand();
    }
}

