/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem;

import codes.derive.foldem.Card;
import codes.derive.foldem.Hand;
import codes.derive.foldem.Suit;
import codes.derive.foldem.util.RandomContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class Deck {
    private final Card[] cards = new Card[52];
    private int currentIndex = 0;

    public Deck() {
        int offset = 0;
        for (Suit suit : Suit.values()) {
            for (int num = 0; num <= 12; ++num) {
                this.cards[offset++] = new Card(num, suit);
            }
        }
    }

    public Deck shuffle() {
        return this.shuffle(RandomContext.get());
    }

    public Deck shuffle(Random random) {
        if (this.currentIndex > 0) {
            throw new IllegalStateException("Deck cannot be shuffled after pop()");
        }
        Collections.shuffle(Arrays.asList(this.cards), random);
        return this;
    }

    public Card pop(Card c) {
        int index = 0;
        for (int i = 0; i < this.cards.length; ++i) {
            if (!this.cards[i].equals(c)) continue;
            index = i;
            break;
        }
        if (index < this.currentIndex) {
            throw new IllegalArgumentException("Card already dealt");
        }
        if (index > 0) {
            Card temp = this.cards[index];
            this.cards[index] = this.cards[this.currentIndex];
            this.cards[this.currentIndex] = temp;
        }
        return this.pop();
    }

    public Hand pop(Hand h) {
        for (Card c : h.cards()) {
            this.pop(c);
        }
        return h;
    }

    public Card pop() {
        if (this.currentIndex >= this.cards.length) {
            throw new IllegalStateException("No cards, you can use remaining() to check");
        }
        return this.cards[this.currentIndex++];
    }

    public Card peek() {
        return this.cards[this.currentIndex];
    }

    public int remaining() {
        return 52 - this.currentIndex;
    }

    public boolean dealt(Card c) {
        for (int i = 0; i < this.cards.length; ++i) {
            if (!this.cards[i].equals(c)) continue;
            return i < this.currentIndex;
        }
        throw new AssertionError((Object)("Card " + c + " was not found in the deck"));
    }

    public Card[] toArray() {
        return this.cards;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.cards);
        result = 31 * result + this.currentIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Deck other = (Deck)obj;
        if (!Arrays.equals(this.cards, other.cards)) {
            return false;
        }
        return this.currentIndex == other.currentIndex;
    }

    public String toString() {
        return Deck.class.getName() + " [dealt=" + this.currentIndex + "]";
    }
}

