/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem;

import codes.derive.foldem.Card;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Hand {
    private final List<Card> cards = new ArrayList<Card>(2);

    public Hand(Card ... cards) {
        if (cards.length != 2) {
            throw new IllegalArgumentException("Illegal number of cards");
        }
        this.cards.addAll(Arrays.asList(cards));
    }

    public Hand(String cards) {
        this(new Card(cards.substring(0, 2)), new Card(cards.substring(2, 4)));
    }

    public Collection<Card> cards() {
        return Collections.unmodifiableCollection(this.cards);
    }

    public boolean suited() {
        return this.cards.get(0).getSuit().equals((Object)this.cards.get(1).getSuit());
    }

    public String toString() {
        return this.cards.get(0).toString().concat(this.cards.get(1).toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cards.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hand other = (Hand)obj;
        return this.cards.containsAll(other.cards);
    }
}

