/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem;

import codes.derive.foldem.Card;
import codes.derive.foldem.Constants;
import codes.derive.foldem.Deck;
import codes.derive.foldem.Hand;
import codes.derive.foldem.Range;
import codes.derive.foldem.Suit;
import codes.derive.foldem.board.Board;
import codes.derive.foldem.board.Boards;
import codes.derive.foldem.board.Street;
import codes.derive.foldem.eval.DefaultEvaluator;
import codes.derive.foldem.eval.Evaluator;
import codes.derive.foldem.eval.HandValue;
import codes.derive.foldem.tool.EquityCalculationBuilder;
import codes.derive.foldem.util.PrettyFormat;
import codes.derive.foldem.util.RandomContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class Poker {
    private Poker() {
    }

    public static Card card(int value, Suit suit) {
        return new Card(value, suit);
    }

    public static Card card(String text) {
        return new Card(text);
    }

    public static Card card(Deck deck) {
        return deck.pop();
    }

    public static Collection<Card> cards() {
        ArrayList<Card> cards = new ArrayList<Card>();
        for (Suit suit : Suit.values()) {
            for (int value = 0; value <= 12; ++value) {
                cards.add(new Card(value, suit));
            }
        }
        return cards;
    }

    public static Collection<Card> cards(String shorthand) {
        if (shorthand.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid shorthand");
        }
        ArrayList<Card> cards = new ArrayList<Card>();
        for (int i = 0; i < shorthand.length(); i += 2) {
            cards.add(Poker.card(shorthand.substring(i, i + 2)));
        }
        return cards;
    }

    public static Hand hand(Card ... cards) {
        return new Hand(cards);
    }

    public static Hand hand(Deck deck) {
        return Poker.hand(deck.pop(), deck.pop());
    }

    public static Hand hand(String cards) {
        return new Hand(cards);
    }

    public static Collection<Hand> hands() {
        ArrayList<Hand> hands = new ArrayList<Hand>();
        for (Card a : Poker.cards()) {
            for (Card b : Poker.cards()) {
                Hand h = Poker.hand(a, b);
                if (a.equals(b) || hands.contains(h)) continue;
                hands.add(h);
            }
        }
        return hands;
    }

    public static Collection<Hand> handGroup(String shorthand) {
        ArrayList<Hand> hands = new ArrayList<Hand>();
        int a = -1;
        int b = -1;
        for (int i = 0; i < Card.LABEL.length; ++i) {
            if (Card.LABEL[i] == shorthand.charAt(0)) {
                a = i;
            }
            if (Card.LABEL[i] != shorthand.charAt(1)) continue;
            b = i;
        }
        int length = shorthand.length();
        if (length == 2 || length == 3 && shorthand.charAt(2) == 's') {
            if (a != b) {
                for (Suit suit : Suit.values()) {
                    hands.add(Poker.hand(Poker.card(a, suit), Poker.card(b, suit)));
                }
            } else if (length == 3) {
                throw new IllegalArgumentException("A hand cannot have identical cards of the same suit");
            }
        }
        if (length == 2 || length == 3 && shorthand.charAt(2) == 'o') {
            for (Suit suit : Constants.OFFSUIT_COMBINATIONS) {
                Hand h = Poker.hand(Poker.card(a, suit[0]), Poker.card(b, suit[1]));
                if (!hands.contains(h)) {
                    hands.add(Poker.hand(Poker.card(a, suit[0]), Poker.card(b, suit[1])));
                }
                if (a == b) continue;
                hands.add(Poker.hand(Poker.card(a, suit[1]), Poker.card(b, suit[0])));
            }
        }
        return hands;
    }

    public static Range range() {
        return new Range();
    }

    public static Range range(Hand ... hands) {
        return Poker.range().define(hands);
    }

    public static Board board(Card ... cards) {
        return Boards.board(cards);
    }

    public static Board board(String cards) {
        return Boards.board(cards);
    }

    public static Board board(Deck deck, Street street) {
        return Boards.board(deck, street);
    }

    public static Deck deck() {
        return new Deck();
    }

    public static Deck shuffledDeck() {
        return new Deck().shuffle(RandomContext.get());
    }

    public static HandValue value(Hand hand, Board board) {
        return new DefaultEvaluator().value(hand, board);
    }

    public static Map<Hand, EquityCalculationBuilder.Equity> equity(Hand ... hands) {
        return Poker.calculationBuilder().calculate(hands);
    }

    public static Map<Hand, EquityCalculationBuilder.Equity> equity(Board board, Hand ... hands) {
        return Poker.calculationBuilder().useBoard(board).calculate(hands);
    }

    public static Map<Range, EquityCalculationBuilder.Equity> equity(Range ... ranges) {
        return Poker.calculationBuilder().calculate(ranges);
    }

    public static Map<Range, EquityCalculationBuilder.Equity> equity(Board board, Range ... ranges) {
        return Poker.calculationBuilder().useBoard(board).calculate(ranges);
    }

    public static char format(Suit suit) {
        return PrettyFormat.get(suit);
    }

    public static String format(Card card) {
        return PrettyFormat.get(card);
    }

    public static String format(Hand hand) {
        return PrettyFormat.get(hand);
    }

    public static String format(Board board) {
        return PrettyFormat.get(board);
    }

    public static String format(EquityCalculationBuilder.Equity equity) {
        StringBuilder b = new StringBuilder();
        b.append("Win: ").append(Poker.percent(equity.win())).append("% ");
        b.append("Lose: ").append(Poker.percent(equity.lose())).append("% ");
        b.append("Split: ").append(Poker.percent(equity.split())).append("%");
        return b.toString();
    }

    public static double percent(double d) {
        return new BigDecimal(d * 100.0).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public static Evaluator evaluator() {
        return new DefaultEvaluator();
    }

    public static EquityCalculationBuilder calculationBuilder() {
        return new EquityCalculationBuilder();
    }
}

