/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem;

import codes.derive.foldem.Hand;
import codes.derive.foldem.util.RandomContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Range {
    private final Map<Double, List<Hand>> weighted = new HashMap<Double, List<Hand>>();
    private final List<Hand> constant = new ArrayList<Hand>();

    public Range define(Hand hand) {
        if (this.contains(hand)) {
            throw new IllegalArgumentException("Hand already exists within range");
        }
        this.constant.add(hand);
        return this;
    }

    public Range define(Hand ... hands) {
        for (Hand hand : hands) {
            this.define(hand);
        }
        return this;
    }

    public Range define(Collection<Hand> hands) {
        return this.define(hands.toArray(new Hand[0]));
    }

    public Range define(double weight, Hand hand) {
        List<Hand> hands;
        if (weight <= 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("Weight out of bounds");
        }
        for (List<Hand> hands2 : this.weighted.values()) {
            if (!hands2.contains(hand)) continue;
            hands2.remove(hand);
        }
        if (!this.weighted.containsKey(weight)) {
            this.weighted.put(weight, new ArrayList());
        }
        if (!(hands = this.weighted.get(weight)).contains(hand)) {
            hands.add(hand);
        }
        return this;
    }

    public Range define(double weight, Hand ... hands) {
        for (Hand hand : hands) {
            this.define(weight, hand);
        }
        return this;
    }

    public Range define(double weight, Collection<Hand> hands) {
        return this.define(weight, hands.toArray(new Hand[0]));
    }

    public boolean contains(Hand hand) {
        for (List<Hand> hands : this.weighted.values()) {
            if (!hands.contains(hand)) continue;
            return true;
        }
        return this.constant.contains(hand);
    }

    public double weight(Hand hand) {
        for (double weight : this.weighted.keySet()) {
            if (!this.weighted.get(weight).contains(hand)) continue;
            return weight;
        }
        return this.constant.contains(hand) ? 1.0 : 0.0;
    }

    public Hand sample(Random random) {
        double weightTotal = this.constant.size();
        for (Double weight : this.weighted.keySet()) {
            weightTotal += weight.doubleValue();
        }
        if (weightTotal < 1.0) {
            throw new IllegalStateException("Too few hands for accurate sample");
        }
        List<Hand> candidates = this.constant;
        double p = Math.random();
        double c = 0.0;
        for (double w : this.weighted.keySet()) {
            if (!(p <= (c += w))) continue;
            candidates = this.weighted.get(w);
            break;
        }
        return candidates.get(random.nextInt(candidates.size()));
    }

    public Hand sample() {
        return this.sample(RandomContext.get());
    }

    public Collection<Hand> all() {
        ArrayList<Hand> hands = new ArrayList<Hand>();
        hands.addAll(this.constant);
        for (List<Hand> l : this.weighted.values()) {
            hands.addAll(l);
        }
        return Collections.unmodifiableCollection(hands);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder().append(Range.class.getName());
        bldr.append("[");
        for (Hand hand : this.constant) {
            bldr.append(hand);
            bldr.append(",");
        }
        Iterator<Object> iterator = this.weighted.keySet().iterator();
        while (iterator.hasNext()) {
            double weight = (Double)iterator.next();
            bldr.append(this.weighted.get(weight)).append(" ").append(weight);
            bldr.append(",");
        }
        bldr.deleteCharAt(bldr.length() - 1);
        return bldr.append("]").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.constant.hashCode();
        result = 31 * result + this.weighted.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (!this.constant.containsAll(other.constant)) {
            return false;
        }
        return this.weighted.equals(other.weighted);
    }
}

