/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem.board;

import codes.derive.foldem.Card;
import codes.derive.foldem.Deck;
import codes.derive.foldem.Poker;
import codes.derive.foldem.board.Board;
import codes.derive.foldem.board.Flop;
import codes.derive.foldem.board.GenericBoard;
import codes.derive.foldem.board.River;
import codes.derive.foldem.board.Street;
import codes.derive.foldem.board.Turn;

public class Boards {
    public static Board board(Card ... cards) {
        for (Street street : Street.values()) {
            if (cards.length != street.cardCount()) continue;
            return new GenericBoard(street, cards);
        }
        throw new IllegalArgumentException("No board for card count " + cards.length);
    }

    public static Board board(String shorthand) {
        return Boards.board(Poker.cards(shorthand).toArray(new Card[0]));
    }

    public static Board board(Deck deck, Street street) {
        Card[] cards = new Card[street.cardCount()];
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = deck.pop();
        }
        return Boards.board(cards);
    }

    public static Flop flop(Card ... cards) {
        return new Flop(cards);
    }

    public static Turn turn(Card ... cards) {
        return new Turn(cards);
    }

    public static River river(Card ... cards) {
        return new River(cards);
    }

    public static Board flop(Deck deck) {
        Card[] cards = new Card[3];
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = deck.pop();
        }
        return new Flop(cards);
    }

    public static Board turn(Deck deck) {
        Card[] cards = new Card[4];
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = deck.pop();
        }
        return new Turn(cards);
    }

    public static Board river(Deck deck) {
        Card[] cards = new Card[5];
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = deck.pop();
        }
        return new River(cards);
    }

    public static Board convert(Board board, Street street) {
        if (street.cardCount() > board.getStreet().cardCount()) {
            throw new IllegalArgumentException("new street has more cards than input");
        }
        Card[] original = board.cards().toArray(new Card[0]);
        Card[] cards = new Card[street.cardCount()];
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = original[i];
        }
        return new GenericBoard(street, cards);
    }

    public static Board convert(Board board, Street street, Card ... cards) {
        int i;
        if (street.cardCount() < board.getStreet().cardCount()) {
            return Boards.convert(board, street);
        }
        Card[] original = board.cards().toArray(new Card[0]);
        Card[] newCards = new Card[street.cardCount()];
        for (i = 0; i < original.length; ++i) {
            newCards[i] = original[i];
        }
        i = original.length;
        int ib = 0;
        while (i < newCards.length) {
            newCards[i] = cards[ib];
            ++i;
            ++ib;
        }
        return new GenericBoard(street, newCards);
    }

    public static Board convert(Board board, Street street, Deck deck) {
        if (street.cardCount() < board.getStreet().cardCount()) {
            return Boards.convert(board, street);
        }
        Card[] cards = new Card[street.cardCount() - board.getStreet().cardCount()];
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = deck.pop();
        }
        return Boards.convert(board, street, cards);
    }
}

