/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem.eval;

import codes.derive.foldem.Card;
import codes.derive.foldem.Hand;
import codes.derive.foldem.board.Board;
import codes.derive.foldem.eval.Evaluator;
import codes.derive.foldem.eval.HandValue;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DefaultEvaluator
implements Evaluator {
    private static final int SUITED_MASK = Integer.MIN_VALUE;
    private static final int DISTINCT_VALUES = 7462;
    private static final int PRIME_DEUCE = 2;
    private static final int PRIME_TREY = 3;
    private static final int PRIME_FOUR = 5;
    private static final int PRIME_FIVE = 7;
    private static final int PRIME_SIX = 11;
    private static final int PRIME_SEVEN = 13;
    private static final int PRIME_EIGHT = 17;
    private static final int PRIME_NINE = 19;
    private static final int PRIME_TEN = 23;
    private static final int PRIME_JACK = 29;
    private static final int PRIME_QUEEN = 31;
    private static final int PRIME_KING = 37;
    private static final int PRIME_ACE = 41;
    protected static final int[] CARD_RANKS = new int[]{41, 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37};
    private static final Map<Integer, Short> rankings = new HashMap<Integer, Short>();

    @Override
    public int rank(Hand h, Board b) {
        ArrayList<Card[]> hands = new ArrayList<Card[]>(21);
        ArrayList<Card> original = new ArrayList<Card>();
        original.addAll(h.cards());
        original.addAll(b.cards());
        int n = original.size();
        int k = 5;
        int[] bitVector = new int[6];
        for (int i = 0; i <= 5; ++i) {
            bitVector[i] = i;
        }
        int endIndex = 1;
        while (endIndex != 0 && 5 <= n) {
            int i;
            Card[] currentCombination = new Card[5];
            for (i = 1; i <= 5; ++i) {
                int index = bitVector[i] - 1;
                currentCombination[i - 1] = (Card)original.get(index);
            }
            endIndex = 5;
            while (bitVector[endIndex] == n - 5 + endIndex && --endIndex != 0) {
            }
            int n2 = endIndex;
            bitVector[n2] = bitVector[n2] + 1;
            for (i = endIndex + 1; i <= 5; ++i) {
                bitVector[i] = bitVector[i - 1] + 1;
            }
            hands.add(currentCombination);
        }
        short rank = 7462;
        for (Card[] cards : hands) {
            short r;
            boolean suited = true;
            int value = CARD_RANKS[cards[0].getValue()];
            for (int i = 1; i < cards.length; ++i) {
                value *= CARD_RANKS[cards[i].getValue()];
                if (cards[i].getSuit().equals((Object)cards[0].getSuit())) continue;
                suited = false;
            }
            if (suited) {
                value |= Integer.MIN_VALUE;
            }
            if ((r = rankings.get(value).shortValue()) >= rank) continue;
            rank = r;
        }
        return rank;
    }

    @Override
    public HandValue value(Hand hand, Board board) {
        int rank = this.rank(hand, board);
        if (rank >= 6185) {
            return HandValue.HIGH_CARD;
        }
        if (rank >= 3325) {
            return HandValue.PAIR;
        }
        if (rank >= 2467) {
            return HandValue.TWO_PAIR;
        }
        if (rank >= 1609) {
            return HandValue.THREE_OF_A_KIND;
        }
        if (rank >= 1599) {
            return HandValue.STRAIGHT;
        }
        if (rank >= 322) {
            return HandValue.FLUSH;
        }
        if (rank >= 166) {
            return HandValue.FULL_HOUSE;
        }
        if (rank >= 10) {
            return HandValue.FOUR_OF_A_KIND;
        }
        return HandValue.STRAIGHT_FLUSH;
    }

    static {
        try (DataInputStream din = new DataInputStream(DefaultEvaluator.class.getResourceAsStream("rank_data"));){
            for (short i = 0; i < 7462; i = (short)(i + 1)) {
                rankings.put(din.readInt(), i);
            }
            din.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load rank_data resource, make sure Foldem was built correctly", e);
        }
    }
}

