/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem.example;

import codes.derive.foldem.Card;
import codes.derive.foldem.Hand;
import codes.derive.foldem.Poker;
import codes.derive.foldem.Range;
import codes.derive.foldem.board.Board;
import codes.derive.foldem.tool.EquityCalculationBuilder;
import java.util.Map;

public class EquitiesExample {
    public static void main(String ... args) {
        EquityCalculationBuilder calc = Poker.calculationBuilder();
        Hand aces = Poker.hand("AcAh");
        Hand kings = Poker.hand("KcKh");
        Map<Hand, EquityCalculationBuilder.Equity> equities = calc.calculate(aces, kings);
        System.out.println("Aces win " + Poker.percent(equities.get(aces).win()) + "%");
        System.out.println("Kings win " + Poker.percent(equities.get(kings).win()) + "%");
        Board board = Poker.board("Ks7h6d");
        calc.useBoard(board);
        equities = calc.calculate(aces, kings);
        System.out.println("On board " + Poker.format(board) + ":");
        System.out.println("Aces win " + Poker.percent(equities.get(aces).win()) + "%");
        System.out.println("Kings win " + Poker.percent(equities.get(kings).win()) + "%");
        Range a = Poker.range().define(Poker.handGroup("AA")).define(Poker.handGroup("72o"));
        Range b = Poker.range().define(Poker.handGroup("KK"));
        calc.useBoard(Poker.board(new Card[0]));
        Map<Range, EquityCalculationBuilder.Equity> rangeEquities = calc.calculate(a, b);
        System.out.println("Aces/72o wins " + Poker.percent(rangeEquities.get(a).win()) + "%");
        System.out.println("Kings win " + Poker.percent(rangeEquities.get(b).win()) + "%");
    }
}

