/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem.example;

import codes.derive.foldem.Card;
import codes.derive.foldem.Hand;
import codes.derive.foldem.Poker;
import codes.derive.foldem.Range;
import codes.derive.foldem.Suit;
import codes.derive.foldem.board.Board;
import codes.derive.foldem.eval.HandValue;
import codes.derive.foldem.tool.EquityCalculationBuilder;
import codes.derive.foldem.tool.TextureAnalysisBuilder;
import java.util.Collection;
import java.util.Map;

public class MainExample {
    public static void main(String ... args) {
        Card aceOfHearts = Poker.card(0, Suit.HEARTS);
        Card aceOfSpades = Poker.card("As");
        Hand aces = Poker.hand(aceOfHearts, aceOfSpades);
        Hand kings = Poker.hand("KhKs");
        Map<Hand, EquityCalculationBuilder.Equity> equities = Poker.equity(aces, kings);
        System.out.println(aces + ": " + Poker.format(equities.get(aces)));
        System.out.println(kings + ": " + Poker.format(equities.get(kings)));
        Board board = Poker.board("Kc7d2h");
        equities = Poker.calculationBuilder().useBoard(board).calculate(aces, kings);
        System.out.println("-- On board " + Poker.format(board));
        System.out.println(Poker.format(aces) + ": " + Poker.format(equities.get(aces)));
        System.out.println(Poker.format(kings) + ": " + Poker.format(equities.get(kings)));
        Collection<Hand> allAces = Poker.handGroup("AA");
        Range a = Poker.range().define(allAces).define(Poker.handGroup("72o"));
        Range b = Poker.range().define(Poker.handGroup("KK")).define(0.7, Poker.handGroup("QQ"));
        Map<Range, EquityCalculationBuilder.Equity> rangeEquities = Poker.equity(a, b);
        System.out.println("Range A: " + Poker.format(rangeEquities.get(a)));
        System.out.println("Range B: " + Poker.format(rangeEquities.get(b)));
        TextureAnalysisBuilder bldr = new TextureAnalysisBuilder();
        bldr.useBoard(Poker.board("7h7dAc"));
        Map<HandValue, Double> frequencies = bldr.frequencies(a);
        for (HandValue value : frequencies.keySet()) {
            double frequency = frequencies.get((Object)value);
            System.out.println((Object)((Object)value) + ": " + Poker.percent(frequency) + "%");
        }
    }
}

