/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem.tool;

import codes.derive.foldem.Card;
import codes.derive.foldem.Deck;
import codes.derive.foldem.Hand;
import codes.derive.foldem.Poker;
import codes.derive.foldem.Range;
import codes.derive.foldem.board.Board;
import codes.derive.foldem.board.Boards;
import codes.derive.foldem.board.Street;
import codes.derive.foldem.eval.DefaultEvaluator;
import codes.derive.foldem.eval.Evaluator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.IntStream;

public class EquityCalculationBuilder {
    public static final int DEFAULT_SAMPLE_SIZE = 25000;
    public static final Evaluator DEFAULT_EVALUATOR = new DefaultEvaluator();
    private final List<Card> dead = new ArrayList<Card>();
    private Board board = Boards.board(new Card[0]);
    private int sampleSize = 25000;
    private Evaluator evaluator = DEFAULT_EVALUATOR;

    public Map<Hand, Equity> calculate(Hand ... hands) {
        Map<Hand, Equity> equities = this.createBaseEquityMap(hands);
        Random random = new Random(Arrays.hashCode(hands));
        IntStream.range(0, this.sampleSize).parallel().forEach(i -> this.simulate(equities, random));
        for (Equity equity : equities.values()) {
            equity.complete();
        }
        return equities;
    }

    public Map<Range, Equity> calculate(Range ... ranges) {
        CopyOnWriteArrayList<Range> unchecked = new CopyOnWriteArrayList<Range>();
        for (Range range : ranges) {
            unchecked.add(range);
        }
        for (Range a : unchecked) {
            for (Range range : unchecked) {
                boolean usable = false;
                if (a.equals(range)) continue;
                ArrayList<Hand> combined = new ArrayList<Hand>();
                combined.addAll(a.all());
                combined.addAll(range.all());
                block3: for (Card card : Poker.cards()) {
                    for (Hand hand : combined) {
                        if (hand.cards().contains(card)) continue;
                        usable = true;
                        break block3;
                    }
                }
                if (usable) continue;
                throw new IllegalArgumentException("These ranges cannot be used beause all hands in one or more of them have a card in common");
            }
            boolean usable = false;
            for (Hand hand : a.all()) {
                if (!Collections.disjoint(hand.cards(), this.board.cards())) continue;
                usable = true;
                break;
            }
            if (!usable) {
                throw new IllegalArgumentException("A provided range does not have any hands with cards that are not the set board");
            }
            unchecked.remove(a);
            if (unchecked.size() != 1) continue;
            break;
        }
        Map<Range, Equity> equities = this.createBaseEquityMap(ranges);
        Random random = new Random(Arrays.hashCode(ranges));
        IntStream.range(0, this.sampleSize).parallel().forEach(i -> {
            HashMap<Hand, Equity> hands = new HashMap<Hand, Equity>();
            while (hands.size() < equities.size()) {
                for (Range range : ranges) {
                    Hand sampled = range.sample(random);
                    boolean collision = false;
                    for (Hand hand : hands.keySet()) {
                        for (Card card : this.dead) {
                            if (!hand.cards().contains(card)) continue;
                            collision = true;
                            break;
                        }
                        if (!Collections.disjoint(hand.cards(), sampled.cards())) {
                            collision = true;
                            break;
                        }
                        if (Collections.disjoint(this.board.cards(), hand.cards())) continue;
                        collision = true;
                        break;
                    }
                    if (collision) continue;
                    hands.put(sampled, (Equity)equities.get(range));
                }
            }
            this.simulate(hands, random);
        });
        for (Equity equity : equities.values()) {
            equity.complete();
        }
        return equities;
    }

    public EquityCalculationBuilder useSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
        return this;
    }

    public EquityCalculationBuilder useEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    public EquityCalculationBuilder useDeadCards(Card ... cards) {
        for (Card card : cards) {
            this.dead.add(card);
        }
        return this;
    }

    public EquityCalculationBuilder useBoard(Board board) {
        this.board = board;
        return this;
    }

    private <T> Map<T, Equity> createBaseEquityMap(T[] data) {
        HashMap<T, Equity> equities = new HashMap<T, Equity>();
        for (T t : data) {
            equities.put(t, new Equity());
        }
        return equities;
    }

    private void simulate(Map<Hand, Equity> equities, Random random) {
        Deck deck = Poker.deck().shuffle(random);
        for (Hand hand : equities.keySet()) {
            deck.pop(hand);
        }
        for (Card card : this.dead) {
            deck.pop(card);
        }
        for (Card card : this.board.cards()) {
            deck.pop(card);
        }
        Board board = Boards.convert(this.board, Street.RIVER, deck);
        LinkedList<Hand> best = new LinkedList<Hand>();
        int currentBest = Integer.MAX_VALUE;
        for (Hand hand : equities.keySet()) {
            int rank = this.evaluator.rank(hand, board);
            if (rank < currentBest) {
                best.clear();
                best.add(hand);
                currentBest = rank;
                continue;
            }
            if (rank != currentBest) continue;
            best.add(hand);
        }
        for (Hand hand : equities.keySet()) {
            if (best.contains(hand)) continue;
            Equity equity = equities.get(hand);
            equity.lose = equity.lose + 1.0;
        }
        if (best.size() > 1) {
            for (Hand hand : best) {
                Equity equity = equities.get(hand);
                equity.split = equity.split + 1.0;
            }
        } else {
            Equity equity = equities.get(best.get(0));
            equity.win = equity.win + 1.0;
        }
    }

    public class Equity {
        private double win = 0.0;
        private double lose = 0.0;
        private double split = 0.0;

        private Equity() {
        }

        public double win() {
            return this.win;
        }

        public double lose() {
            return this.lose;
        }

        public double split() {
            return this.split;
        }

        private void complete() {
            this.win /= (double)EquityCalculationBuilder.this.sampleSize;
            this.lose /= (double)EquityCalculationBuilder.this.sampleSize;
            this.split /= (double)EquityCalculationBuilder.this.sampleSize;
        }

        public String toString() {
            return "[win=" + this.win + " lose=" + this.lose + " split=" + this.split + "]";
        }
    }
}

