/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem.tool;

import codes.derive.foldem.Hand;
import codes.derive.foldem.Poker;
import codes.derive.foldem.Range;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collection;

public class HandMatrixBuilder {
    private static final int MATRIX_SIZE = 13;
    private static final int SIZE_PX = 390;
    private static final char[] LABELS = new char[]{'A', 'K', 'Q', 'J', 'T', '9', '8', '7', '6', '5', '4', '3', '2'};

    public BufferedImage build(Range range) {
        BufferedImage image = new BufferedImage(391, 391, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int boxSize = 30;
        for (int x = 0; x < 13; ++x) {
            int drawX = x * boxSize;
            for (int y = 0; y < 13; ++y) {
                int drawY = y * boxSize;
                String label = HandMatrixBuilder.label(x, y);
                Collection<Hand> hands = Poker.handGroup(label);
                float weight = 0.0f;
                for (Hand hand : hands) {
                    double w = 0.0;
                    if (range.contains(hand)) {
                        w = range.weight(hand);
                    }
                    weight = (float)((double)weight + w / (double)hands.size());
                }
                double wr = 2.0 * (1.0 - (double)weight);
                double wg = 2.0 * (double)weight;
                if (wg > 1.0) {
                    wg = 1.0;
                }
                if (wr > 1.0) {
                    wr = 1.0;
                }
                Color color = new Color((int)(255.0 * wr), (int)(255.0 * wg), 0);
                g.setColor(color);
                int fillX = drawX;
                int fillY = drawY + boxSize - (int)((float)boxSize * weight);
                int fillHeight = (int)((float)boxSize * weight);
                Paint original = g.getPaint();
                g.setPaint(new GradientPaint(new Point(fillX, fillY), color, new Point(fillX + boxSize, fillY + fillHeight), color.darker()));
                g.fillRect(fillX, fillY, boxSize, fillHeight);
                g.setPaint(original);
                FontMetrics metrics = g.getFontMetrics();
                int labelX = drawX + 1 + (boxSize - 1 - metrics.stringWidth(label)) / 2;
                int labelY = drawY + 1 + (boxSize - 1 + metrics.getMaxAscent()) / 2;
                g.setColor(Color.BLACK);
                g.drawString(label, labelX, labelY);
                g.drawRect(drawX, drawY, boxSize, boxSize);
            }
        }
        return image;
    }

    private static String label(int x, int y) {
        StringBuilder bldr = new StringBuilder();
        if (x < y) {
            bldr.append(LABELS[x]).append(LABELS[y]);
        } else {
            bldr.append(LABELS[y]).append(LABELS[x]);
        }
        if (x + y > x * 2) {
            bldr.append("o");
        } else if (x + y < x * 2) {
            bldr.append("s");
        }
        return bldr.toString();
    }
}

