/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem.tool;

import codes.derive.foldem.Card;
import codes.derive.foldem.Hand;
import codes.derive.foldem.Range;
import codes.derive.foldem.board.Board;
import codes.derive.foldem.board.Boards;
import codes.derive.foldem.board.Street;
import codes.derive.foldem.eval.DefaultEvaluator;
import codes.derive.foldem.eval.Evaluator;
import codes.derive.foldem.eval.HandValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TextureAnalysisBuilder {
    public static final int DEFAULT_SAMPLE_SIZE = 25000;
    public static final Evaluator DEFAULT_EVALUATOR = new DefaultEvaluator();
    private Board board = Boards.board(new Card[0]);
    private Evaluator evaluator = DEFAULT_EVALUATOR;

    public Map<HandValue, Double> frequencies(Range range) {
        if (this.board.getStreet().equals((Object)Street.PREFLOP)) {
            throw new IllegalStateException("Board is not set to a postflop board");
        }
        ArrayList<Hand> usable = new ArrayList<Hand>();
        for (Hand hand : range.all()) {
            if (!Collections.disjoint(hand.cards(), this.board.cards())) continue;
            usable.add(hand);
        }
        if (usable.size() == 0) {
            throw new IllegalArgumentException("No viable hands in range to use on the board");
        }
        HashMap<HandValue, Double> results = new HashMap<HandValue, Double>();
        for (HandValue value : HandValue.values()) {
            results.put(value, 0.0);
        }
        for (Hand hand : usable) {
            HandValue value = this.evaluator.value(hand, this.board);
            results.put(value, (Double)results.get((Object)value) + range.weight(hand) / (double)usable.size());
        }
        return results;
    }

    public TextureAnalysisBuilder useEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    public TextureAnalysisBuilder useBoard(Board board) {
        this.board = board;
        return this;
    }
}

