/*
 * Decompiled with CFR 0.152.
 */
package codes.derive.foldem.util;

import codes.derive.foldem.Card;
import codes.derive.foldem.Hand;
import codes.derive.foldem.Suit;
import codes.derive.foldem.board.Board;

public class PrettyFormat {
    public static char get(Suit suit) {
        switch (suit) {
            case SPADES: {
                return '\u2660';
            }
            case CLUBS: {
                return '\u2663';
            }
            case DIAMONDS: {
                return '\u2666';
            }
            case HEARTS: {
                return '\u2764';
            }
        }
        throw new IllegalArgumentException("Invalid suit");
    }

    public static String get(Card card) {
        return "" + Card.LABEL[card.getValue()] + PrettyFormat.get(card.getSuit());
    }

    public static String get(Hand hand) {
        StringBuilder bldr = new StringBuilder();
        for (Card card : hand.cards()) {
            bldr.append(PrettyFormat.get(card)).append(',');
        }
        return bldr.substring(0, bldr.length() - 1).toString();
    }

    public static String get(Board board) {
        StringBuilder bldr = new StringBuilder();
        for (Card card : board.cards()) {
            bldr.append(PrettyFormat.get(card)).append(", ");
        }
        if (bldr.length() < 2) {
            return "";
        }
        return bldr.substring(0, bldr.length() - 2).toString();
    }
}

