/*
 * Decompiled with CFR 0.152.
 */
package codes.rafael.asmjdkbridge;

import codes.rafael.asmjdkbridge.JdkClassReader;
import codes.rafael.asmjdkbridge.JdkClassWriter;
import codes.rafael.asmjdkbridge.ProbingResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ProbingClassReader {
    private final ProbingResolver resolver;

    public ProbingClassReader(byte[] classFile, Attribute ... attributePrototypes) {
        this.resolver = ProbingResolver.ofClassFile(classFile, attributePrototypes);
    }

    public ProbingClassReader(InputStream inputStream, Attribute ... attributePrototypes) throws IOException {
        this(ProbingClassReader.readAllBytes(inputStream), attributePrototypes);
    }

    public ProbingClassReader(String className, Attribute ... attributePrototypes) throws IOException {
        byte[] classFile;
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(className.replace('.', '/') + ".class");){
            classFile = ProbingClassReader.readAllBytes(inputStream);
        }
        this.resolver = ProbingResolver.ofClassFile(classFile, attributePrototypes);
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        return outputStream.toByteArray();
    }

    public int getAccess() {
        return this.resolver.getAccess();
    }

    public String getClassName() {
        return this.resolver.getClassName();
    }

    public String getSuperName() {
        return this.resolver.getSuperName();
    }

    public String[] getInterfaces() {
        return this.resolver.getInterfaces();
    }

    public void accept(ClassVisitor classVisitor, int flags) {
        this.resolver.accept(classVisitor, flags);
    }

    public ClassWriterContainer<?> toClassWriter(int flags) {
        return this.resolver.toClassWriter(flags);
    }

    public static abstract class ClassWriterContainer<T extends ClassVisitor> {
        final T delegate;

        ClassWriterContainer(T delegate) {
            this.delegate = delegate;
        }

        public ClassVisitor getClassVisitor() {
            return this.delegate;
        }

        public abstract byte[] toByteArray();

        static class OfJdk
        extends ClassWriterContainer<JdkClassWriter> {
            OfJdk(JdkClassReader classReader, int flags) {
                super(new JdkClassWriter(classReader, flags));
            }

            @Override
            public byte[] toByteArray() {
                return ((JdkClassWriter)this.delegate).toByteArray();
            }
        }

        static class OfAsm
        extends ClassWriterContainer<ClassWriter> {
            OfAsm(ClassReader classReader, int flags) {
                super(new ClassWriter(classReader, flags));
            }

            @Override
            public byte[] toByteArray() {
                return ((ClassWriter)this.delegate).toByteArray();
            }
        }
    }
}

