/*
 * Decompiled with CFR 0.152.
 */
package codes.rafael.asmjdkbridge;

import codes.rafael.asmjdkbridge.JdkClassWriter;
import codes.rafael.asmjdkbridge.ProbingResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ProbingClassWriter
extends ClassVisitor {
    private final int flags;
    private final Function<String, String> getSuperClass;

    public ProbingClassWriter(int flags) {
        super(589824);
        this.flags = flags;
        this.getSuperClass = null;
    }

    public ProbingClassWriter(int flags, Method getSuperClass, Object target) {
        super(589824);
        this.flags = flags;
        this.getSuperClass = getSuperClass == null ? null : name -> {
            try {
                return (String)getSuperClass.invoke(target, name);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public ProbingClassWriter(int flags, Function<String, String> getSuperClass) {
        super(589824);
        this.flags = flags;
        this.getSuperClass = getSuperClass;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cv = ProbingResolver.ofVersion(this.flags, version, this.getSuperClass);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public byte[] toByteArray() {
        if (this.cv instanceof JdkClassWriter) {
            return ((JdkClassWriter)this.cv).toByteArray();
        }
        if (this.cv instanceof ClassWriter) {
            return ((ClassWriter)this.cv).toByteArray();
        }
        if (this.cv instanceof ProbingClassWriter) {
            return ((ProbingClassWriter)this.cv).toByteArray();
        }
        if (this.cv == null) {
            throw new IllegalStateException("No version discovered");
        }
        throw new IllegalStateException("Unexpected type: " + this.cv.getClass().getTypeName());
    }
}

