package com.darts.sdk.client;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.util.Log;
import android.widget.RemoteViews;

import com.darts.sdk.Model.Notification;
import com.darts.sdk.Model.PersistentPush;
import com.darts.sdk.common.Configuration;

import java.security.InvalidParameterException;

/**
 *  You should subclass SDKClient and implement the interfaces (mysdkClient)
 *  add to the manifest:
 *  {@code <meta-data android:name="darts_clientClass" android:value="com.mycompany.myapp.mysdkClient"/>}
*
 */
public abstract   class DartsClient extends BroadcastReceiver implements INotifications, ISDKCore, IUIStrings, IGeolocation
{
	private static final String TAG = "SDKClient";

	private static DartsClient _me;


	public DartsClient()
	{

	}



	public final static DartsClient instance(Context context)
	{
		return instance(context,null);
	}

	public final static DartsClient instance(Context context, ApplicationInfo info)
	{
		Context c = context;


		if( context != null)
		{
			context.getApplicationContext();
		}
		if( _me == null)
		{
			Log.d(TAG, "instance: creating from context");
			if( c == null)
			{
				Log.w(TAG, "instance: no context!!!!!" );
				return new DartsClientDefaultImplementation();

			}

			String name = null;
			if( info != null)
			{
				Log.d(TAG, "instance: initiating from "+ info);
				name = Configuration.getClientClassName(c,info	);
			}
			else
			{
				name = Configuration.getClientClassName(c);
			}
			if( name != null)
			{

				Log.d(TAG, "client class: "+name);
				try
				{
					_me = (DartsClient) Class.forName(name).newInstance();
					_me.performSetup(context);
				} catch (InstantiationException e)
				{
					e.printStackTrace();
					Log.e("DartsSDK:Config", "Please check <meta-data android:name=\"darts_clientClass\" android:value=\"com.yourcompany.YourClientClass\"/> in your Application section of your AndroidManifest.xml file.");

					throw new InvalidParameterException("Error instantiating "+name);
				} catch (IllegalAccessException e)
				{
					e.printStackTrace();
					Log.e("DartsSDK:Config", "Please check <meta-data android:name=\"darts_clientClass\" android:value=\"com.yourcompany.YourClientClass\"/> in your Application section of your AndroidManifest.xml file.");
					throw  new InvalidParameterException("Illegal Access instantiating "+name);
				} catch (ClassNotFoundException e)
				{
					e.printStackTrace();
					Log.e("DartsSDK:Config", "Please check <meta-data android:name=\"darts_clientClass\" android:value=\"com.yourcompany.YourClientClass\"/> in your Application section of your AndroidManifest.xml file.");
					throw new InvalidParameterException("could not find "+name);
				}
				catch (Exception e)
				{
					throw new InvalidParameterException("Exception instantiating "+name);
				}
			}
			else
			{
				Log.w(TAG, "could not get client class");
			}
			if( _me == null)
			{
				_me = new DartsClientDefaultImplementation();
			}
		}
		return _me;
	}



	@Override
	public final void onReceive(Context context, Intent intent)
	{
		if(intent!=null)
		{

			String action = intent.getAction();


			if ("com.darts.sdk.CLEAR_PUSHES".equalsIgnoreCase(action))
			{

				PersistentPush.clear(context);
				Log.i(TAG,"clearing push list");
				if( intent.hasExtra("dismiss"))
				{
					int id = intent.getIntExtra("dismiss", -1);
					if( id != -1)
					{

						NotificationManager manager =
								(NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
						manager.cancel(id);
						//manager.cancel(PushController.SINGLE_ID);// ¿cancell all???

					}
				}

				try
				{
					logEvent("Push","clear list from push", "");
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
				onNotificationListCleared();
				return;



			}

		}
	}

	/**
	 * Called when the user has rejected location permission, do not make any further UI interaction with the user regarding location permission
	 */
	@Override
	public void onUserRejectedLocationPermission()
	{

	}

	/**
	 * Called when the user has accepted location permission, note that asking for permissions depends on several factors and is not always asked to the user.
	 */
	@Override
	public void onUserAcceptedLocationPermission()
	{

	}

	/**
	 * To send a remote exception to your desired server
	 * e.g.: {@code Crashlytics.logException(e);}
	 *
	 * @param e the exception to be logged
	 */
	@Override
	public void remoteLogException(Exception e)
	{

	}

	/**
	 * Called to log events, for example to use analytics
	 * {@code
	 * Tracker _t = OnpublicoApplication.getPushTracker();
	 * if (_t != null)
	 * {
	 * _t.send(new HitBuilders.EventBuilder().setCategory("Push")
	 * .setNonInteraction(true)
	 * .setAction("errorRegister").setLabel(e.getMessage()).build());
	 * }
	 * }
	 *
	 * @param category category
	 * @param type     type
	 * @param message  message
	 */
	@Override
	public void logEvent(String category, String type, String message)
	{

	}

	/**
	 * Called when the SDK is initialized
	 * <p>
	 * Do any customization here like Sdk.alwaysShowLastNotification:
	 * <p>
	 * {@code Sdk.alwaysShowLastNotification(false);}
	 *
	 * @param context context to be used, for example to get string resources
	 */
	@Override
	public void performSetup(Context context)
	{

	}



	/**
	 * Called when a notification is showed to the user
	 *
	 * @param notification
	 */
	@Override
	public void onNotificationShowed(Notification notification)
	{

	}

	/**
	 * Called when a notification is showed to the user in the stacked notification
	 *
	 * @param notification
	 */
	@Override
	public void onNotificationShowedInList(Notification notification)
	{

	}

	/**
	 * Called when a notification is received in the device
	 *
	 * @param notification
	 * @return
	 */
	@Override
	public boolean onNotificationReceived(Notification notification)
	{
		return false;
	}

	/**
	 * Called when a showed notification is clicked
	 *
	 * @param notification
	 * @return
	 */
	@Override
	public boolean onNotificationClicked(Notification notification)
	{
		return false;
	}

	/**
	 * Called when the notification list is cleared
	 *
	 * @return
	 */
	@Override
	public boolean onNotificationListCleared()
	{
		return false;
	}

	/**
	 * Open the notification, start your desired intent configured properly, return true
	 * <p>
	 * to override deep url launching.
	 *
	 * @param notification the clicked notification
	 * @param context      context to be used
	 * @return true if client opens the notification overriding SDK default behabiour
	 */
	@Override
	public boolean openNotification(Notification notification, Context context)
	{
		return false;
	}

	/**
	 * Start the proper intent to show notification list, the user has clicked on stacked notification
	 *
	 * @param context context to be used
	 */
	@Override
	public void openNotificationList(Context context)
	{

	}

	/**
	 * Return true if the notification should have an image
	 *
	 * @param notification notification containing data to build the notification
	 * @return true if the notification should contain a custom image.
	 */
	@Override
	public boolean notificationHasImage(Notification notification)
	{
		return false;
	}

	/**
	 * if you need to load some data could be done later, return immediately,
	 * override if you want to provide your custom notification view when collapsed
	 *
	 * @param notification
	 * @param context
	 * @return
	 */
	@Override
	public RemoteViews getCustomNotificationSmallView(Notification notification, Context context)
	{
		return null;
	}

	/**
	 * you should also return a view on getCustomNotificationSmallView
	 * if you need to load some data could be done later, return immediately
	 * override if you want to provide your large custom notification view when expanded
	 *
	 * @param notification
	 * @param context
	 * @return
	 */
	@Override
	public RemoteViews getCustomNotificationLargeView(Notification notification, Context context)
	{
		return null;
	}

	/**
	 * Called to start all your background custom notification loading, return immediately.
	 * <p>
	 * You MUST call listener.revertToStandardNotification() or listener.customNotificationsReady()
	 * once.
	 *
	 * @param listener     listener to call when you are ready
	 * @param notification notification to load data
	 * @param rv           RemoteViews to be filled
	 * @param rvBig        RemoteViews to be filled
	 * @param context      context to use
	 */
	@Override
	public void loadBackgroundCustomNotificationData(IBackgroundCustomNotificationLoaderListener listener, Notification notification, RemoteViews rv, RemoteViews rvBig, Context context)
	{

	}

	/**
	 * Return a CharSequence explaining to the user why your app uses location and why permission should be granted.
	 * the returned value should be multilanguage aware.
	 *
	 * @param context context to be used to access string resources
	 * @return the message to be shown to the user when required in the correct language
	 */
	@Override
	public CharSequence getLocationExplanation(Context context)
	{
		return null;
	}

	//throw new UnsupportedOperationException("Not yet implemented: derive from SDKClient and override getGCMDefaultSenderId");

}
