/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.Model;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tendarts.sdk.Model.Notification;
import com.tendarts.sdk.client.TendartsClient;
import com.tendarts.sdk.common.Configuration;
import com.tendarts.sdk.common.PushController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

public class PersistentPush {
    static ArrayList<Notification> a = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeById(String id, Context context) {
        Log.i((String)"Persistent Push", (String)("Remove id:" + id));
        if (id == null || id.isEmpty()) {
            return;
        }
        PersistentPush.getStored(context);
        ArrayList<Notification> arrayList = a;
        synchronized (arrayList) {
            for (int i = 0; i < a.size(); ++i) {
                Notification notification = a.get(i);
                String string2 = notification.getString("id");
                Log.d((String)"Persistent Push", (String)("checking id " + string2));
                if (!id.equals(string2)) continue;
                Log.d((String)"Persistent Push", (String)"match, removing");
                notification.deleted = true;
                JSONArray jSONArray = PersistentPush.a(a);
                Configuration.instance(context).savePrivate("sdk_stored_pushes", jSONArray.toString());
                return;
            }
        }
    }

    public static PendingIntent buildPendingIntent(Notification push, Context context, boolean single) {
        return PersistentPush.buildPendingIntent(push, context, 0x14000000, single);
    }

    public static PendingIntent buildPendingIntent(Notification push, Context context, int flags, boolean single) {
        Intent intent = PersistentPush.buildIntent(push, context, flags);
        if (intent == null) {
            return null;
        }
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)(single ? PushController.getNotificationId(push) : 5525), (Intent)intent, (int)0x8000000);
        return pendingIntent;
    }

    public static boolean isDestinationRootWindow(String dst) {
        if (dst != null) {
            switch (dst) {
                case "hot": 
                case "tag": 
                case "trks": 
                case "trn": {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isDestinationRootWindow(Notification push) {
        if (push != null) {
            String string2 = push.getString("dst");
            return PersistentPush.isDestinationRootWindow(string2);
        }
        return false;
    }

    @Nullable
    public static Intent buildIntent(Notification push, Context context, int flags) {
        Intent intent = PersistentPush.buildIntent(context, flags, push);
        if (intent == null) {
            return null;
        }
        return intent;
    }

    @Nullable
    public static Intent buildIntent(Context context, int flags, Notification push) {
        Intent intent = new Intent();
        Configuration.instance(context);
        String string2 = Configuration.getAccessToken(context);
        if (string2 == null) {
            Log.d((String)"Persistent Push", (String)"notifyList: not access token");
            return null;
        }
        intent.setAction("com.darts.sdk.OPEN_PUSH");
        intent.putExtra("sorg", string2.hashCode());
        push.serializeToExtras(intent);
        intent.addFlags(flags);
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPush(Notification push, Context context) {
        ArrayList<Notification> arrayList = a;
        synchronized (arrayList) {
            for (int i = 0; i < a.size(); ++i) {
                Notification notification = a.get(i);
                String string2 = notification.getUID();
                String string3 = push.getUID();
                if (string3 == null || !string3.equals(string2)) continue;
                Log.d((String)"Persistent Push", (String)"adding existing");
                TendartsClient.instance(context).logEvent("PUSH", "duplicate push received, ignoring", string3);
                return;
            }
            a.add(push);
        }
        PersistentPush.save(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Context context) {
        try {
            PersistentPush.removeDeleted(context);
            ArrayList<Notification> arrayList = a;
            synchronized (arrayList) {
                JSONArray jSONArray = PersistentPush.a(a);
                Log.d((String)"Persistent Push", (String)("save: " + jSONArray));
                Configuration.instance(context).savePrivate("sdk_stored_pushes", jSONArray.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDeleted(Context context) {
        ArrayList<Notification> arrayList = a;
        synchronized (arrayList) {
            ArrayList<Notification> arrayList2 = new ArrayList<Notification>();
            for (int i = 0; i < a.size(); ++i) {
                Notification notification = a.get(i);
                long l = new Date().getTime() - notification.timestamp.getTime();
                if (!notification.deleted || l <= 172800000L) continue;
                arrayList2.add(notification);
            }
            Log.d((String)"Persistent Push", (String)("removeDeleted past 48 h" + arrayList2));
            a.removeAll(arrayList2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(Context context) {
        PersistentPush.getStored(context);
        ArrayList<Notification> arrayList = a;
        synchronized (arrayList) {
            for (int i = 0; i < a.size(); ++i) {
                Notification notification = a.get(i);
                notification.deleted = true;
            }
        }
        PersistentPush.save(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Notification> getStored(Context context) {
        block8: {
            try {
                Object object;
                String string2 = Configuration.instance(context).loadPrivate("sdk_stored_pushes");
                if (string2 == null) break block8;
                if (string2.isEmpty()) {
                    a = new ArrayList();
                } else {
                    object = new JSONArray(string2);
                    ArrayList<Notification> arrayList = a;
                    synchronized (arrayList) {
                        a = PersistentPush.a((JSONArray)object);
                    }
                }
                object = new ArrayList();
                for (int i = 0; i < a.size(); ++i) {
                    Notification notification = a.get(i);
                    if (notification.deleted) continue;
                    ((ArrayList)object).add(notification);
                }
                return object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        a = new ArrayList();
        return a;
    }

    private static JSONArray a(ArrayList<Notification> arrayList) {
        JSONArray jSONArray = new JSONArray();
        for (Notification notification : arrayList) {
            if (notification.message == null) continue;
            jSONArray.put((Object)notification.serialize());
        }
        return jSONArray;
    }

    private static ArrayList<Notification> a(JSONArray jSONArray) {
        ArrayList<Notification> arrayList = new ArrayList<Notification>();
        try {
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                Notification notification = new Notification(null, null);
                notification.deserialize(jSONObject);
                arrayList.add(notification);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Collections.sort(arrayList, new Comparator<Notification>(){

            public int a(Notification notification, Notification notification2) {
                return (int)(notification2.timestamp.getTime() - notification.timestamp.getTime());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Notification)object, (Notification)object2);
            }
        });
        return arrayList;
    }

    public static boolean alreadyContains(Notification push, Context context) {
        for (int i = 0; i < a.size(); ++i) {
            Notification notification = a.get(i);
            String string2 = notification.getUID();
            String string3 = push.getUID();
            if (string3 == null || !string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAllIds(Context context) {
        PersistentPush.getStored(context);
        StringBuilder stringBuilder = new StringBuilder("[");
        ArrayList<Notification> arrayList = a;
        synchronized (arrayList) {
            for (int i = 0; i < a.size(); ++i) {
                Notification notification = a.get(i);
                String string2 = notification.getCode();
                stringBuilder.append(string2).append(", ");
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

