/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.Model;

import android.content.Intent;
import android.util.Log;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class Push {
    public Map<String, String> extras = new HashMap<String, String>();
    public String title;
    public String message;
    public String contentId;
    public String contentType;
    public Date timestamp;
    public boolean deleted = false;
    public int notId;
    public String userData = null;
    public boolean read;
    public String imageUrl;
    public String avatarUrl;

    Push(String title, String message) {
        this.title = title;
        this.message = message;
        this.timestamp = new Date();
        this.deleted = false;
        this.read = false;
    }

    public Push(Intent intent) {
        if (intent.hasExtra("serializedPush")) {
            try {
                String string2 = intent.getStringExtra("serializedPush");
                this.deserialize(new JSONObject(string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.extras = new HashMap<String, String>();
            this.title = "";
            this.message = "";
            this.timestamp = new Date();
            this.deleted = false;
        }
    }

    public static boolean canDeserialize(Intent intent) {
        return intent.hasExtra("serializedPush");
    }

    public void serializeToExtras(Intent intent) {
        String string2 = this.serialize().toString();
        intent.putExtra("serializedPush", string2);
    }

    public String getFullText() {
        String string2 = this.message;
        if (this.title != null && this.title.length() > 0) {
            string2 = this.title + string2;
        }
        return string2;
    }

    public String getDeepUrl() {
        return this.getString("dl");
    }

    public String getUID() {
        return this.getString("not");
    }

    public String getCode() {
        return this.getString("id");
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void putExtra(String key, String value) {
        this.extras.put(key, value);
    }

    public String getString(String key) {
        return this.extras.get(key);
    }

    public JSONObject serialize() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("title", (Object)this.title);
            jSONObject.put("message", (Object)this.message);
            if (this.timestamp != null) {
                jSONObject.put("timestamp", this.timestamp.getTime());
            }
            if (this.imageUrl != null) {
                jSONObject.put("imageUrl", (Object)this.imageUrl);
            }
            if (this.avatarUrl != null) {
                jSONObject.put("avatarUrl", (Object)this.avatarUrl);
            }
            JSONArray jSONArray = new JSONArray();
            for (String string2 : this.extras.keySet()) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("key", (Object)string2);
                String string3 = this.extras.get(string2);
                if (string3 == null) {
                    string3 = "";
                }
                jSONObject2.put("value", (Object)string3.toString());
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("extras", (Object)jSONArray);
            jSONObject.put("contentId", (Object)this.contentId);
            jSONObject.put("contentType", (Object)this.contentType);
            jSONObject.put("notId", this.notId);
            jSONObject.put("deleted", this.deleted);
            jSONObject.put("userData", (Object)this.userData);
            return jSONObject;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void deserialize(JSONObject object) {
        try {
            Log.i((String)"STORED PUSH", (String)("Deserialize: " + object));
            this.title = object.isNull("title") ? null : object.getString("title");
            this.message = object.getString("message");
            JSONArray jSONArray = object.getJSONArray("extras");
            this.extras = new HashMap<String, String>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                try {
                    this.extras.put(jSONObject.getString("key"), jSONObject.getString("value"));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.imageUrl = !object.isNull("imageUrl") ? object.getString("imageUrl") : null;
            if (!object.isNull("avatarUrl")) {
                this.avatarUrl = object.getString("avatarUrl");
            }
            if (!object.isNull("timestamp")) {
                long l = object.getLong("timestamp");
                this.timestamp = new Date(l);
            }
            if (!object.isNull("contentId")) {
                this.contentId = object.getString("contentId");
            }
            if (!object.isNull("contentType")) {
                this.contentType = object.getString("contentType");
            }
            if (!object.isNull("notId")) {
                this.notId = object.getInt("notId");
            }
            if (!object.isNull("deleted")) {
                this.deleted = object.getBoolean("deleted");
            }
            if (!object.isNull("userData")) {
                this.userData = object.getString(this.userData);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        JSONObject jSONObject = this.serialize();
        if (jSONObject != null) {
            return jSONObject.toString();
        }
        return "null";
    }

    public static interface IImageUrlObserver {
        public void onNoImage();

        public void onImage(String var1, Push var2);
    }
}

