/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import com.tendarts.sdk.Model.Notification;
import com.tendarts.sdk.Model.PersistentPush;
import com.tendarts.sdk.R;
import com.tendarts.sdk.client.TendartsClient;
import com.tendarts.sdk.common.Configuration;
import com.tendarts.sdk.common.PendingCommunicationController;
import com.tendarts.sdk.common.PushController;
import com.tendarts.sdk.common.Util;
import com.tendarts.sdk.communications.Communications;
import com.tendarts.sdk.communications.ICommunicationObserver;
import com.tendarts.sdk.communications.PendingCommunicationsService;
import com.tendarts.sdk.gcm.GCMListenerService;
import com.tendarts.sdk.gcm.GCMRegistrationIntentService;
import com.tendarts.sdk.geo.GoogleUpdates;
import java.lang.ref.WeakReference;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONObject;

public class TendartsSDK {
    static TendartsSDK a;
    boolean b = false;
    boolean c = true;
    boolean d = true;
    boolean e = false;
    int f = 8;
    int g = 23;
    int h = R.color.notification_color;
    private int k = 17301598;
    private int l = 0;
    private String m;
    private CharSequence n;
    private int o = 17301591;
    private CharSequence p;
    private int q = 17301560;
    private CharSequence r;
    public static final int REQUEST_LOCATION = 333;
    private static Date s;
    static GoogleUpdates i;
    private static boolean t;
    private static WeakReference<IGeoLocationReceiver> u;
    static int j;

    public static TendartsSDK instance() {
        if (a == null) {
            a = new TendartsSDK();
        }
        return a;
    }

    private TendartsSDK() {
    }

    public TendartsSDK stackNotifications(boolean stackNotifications) {
        this.b = stackNotifications;
        return this;
    }

    public boolean getStackNotifications() {
        return this.b;
    }

    public TendartsSDK alwaysShowLastNotification(boolean alwaysShowLastNotification) {
        this.c = alwaysShowLastNotification;
        return this;
    }

    public boolean getAlwaysSowLastNotification() {
        return this.c;
    }

    public TendartsSDK limitNotificationSoundAndVibrationTime(boolean limitNotificationSoundAndVibrationTime) {
        this.d = limitNotificationSoundAndVibrationTime;
        return this;
    }

    public boolean getLimitNotificationSoundAndVibrationTime() {
        return this.d;
    }

    public TendartsSDK notificationSoundAndVibrationFirstHour(int firstHour) {
        this.f = firstHour;
        return this;
    }

    public int getNotificationSoundAndVibrationFirstHour() {
        return this.f;
    }

    public TendartsSDK notificationSoundAndVibrationLastHour(int lastHour) {
        this.g = lastHour;
        return this;
    }

    public int getNotificationSoundAndVibrationLastHour() {
        return this.g;
    }

    public TendartsSDK notificationColorResource(int colorResource) {
        this.h = colorResource;
        return this;
    }

    public int getNotificationColorResource() {
        return this.h;
    }

    public TendartsSDK setSmallIconResource(int smallIconResource) {
        this.k = smallIconResource;
        return this;
    }

    public int getSmallIconResource() {
        return this.k;
    }

    public TendartsSDK setOnlySmallIcon(boolean onlySmallIcon) {
        this.e = onlySmallIcon;
        return this;
    }

    public TendartsSDK setLargeIconResource(int largeIconResource) {
        this.l = largeIconResource;
        return this;
    }

    public int getLargeIconResource() {
        return this.l;
    }

    public Bitmap getLargeIcon(Context context) {
        try {
            if (this.e) {
                return null;
            }
            if (context == null || this.l != 0) {
                return BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.l);
            }
            int n = context.getApplicationInfo().icon;
            if (n != 0) {
                return BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
            }
            Drawable drawable2 = context.getPackageManager().getApplicationIcon(context.getApplicationInfo());
            if (drawable2 != null) {
                BitmapDrawable bitmapDrawable;
                Bitmap bitmap = null;
                if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null && !bitmapDrawable.getBitmap().isRecycled()) {
                    return bitmapDrawable.getBitmap();
                }
                bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmapDrawable = new Canvas(bitmap);
                drawable2.setBounds(0, 0, bitmapDrawable.getWidth(), bitmapDrawable.getHeight());
                drawable2.draw((Canvas)bitmapDrawable);
                return bitmap;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.mipmap.ic_not_large_icon);
    }

    public TendartsSDK stackedNotificationTitle(CharSequence title) {
        this.n = title;
        return this;
    }

    public CharSequence getStackedNotificationTitle() {
        return this.n;
    }

    public TendartsSDK stackedNotificationContent(String content) {
        this.m = content;
        return this;
    }

    public String getStackedNotificationContent(int size) {
        if (this.m != null) {
            if (this.m.contains("%d")) {
                return String.format(this.m, size);
            }
            return this.m;
        }
        return this.m;
    }

    public TendartsSDK viewStackedIconResource(int iconResource) {
        this.o = iconResource;
        return this;
    }

    public int getViewStackedIconResource() {
        return this.o;
    }

    public TendartsSDK viewStackdString(CharSequence string2) {
        this.p = string2;
        return this;
    }

    public CharSequence getViewStackedString() {
        return this.p;
    }

    public TendartsSDK cancelStackedIconResource(int iconResource) {
        this.q = iconResource;
        return this;
    }

    public int getCancelStackedIconResource() {
        return this.q;
    }

    public TendartsSDK cancelStackedString(CharSequence string2) {
        this.r = string2;
        return this;
    }

    public CharSequence getCancelStackedString() {
        return this.r;
    }

    @TargetApi(value=23)
    public static void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults, Context context) {
        switch (requestCode) {
            case 333: {
                TendartsSDK.i.asking = false;
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    try {
                        if (i != null) {
                            i.startLocationUpdates(false);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    TendartsClient.instance(context).onUserAcceptedLocationPermission();
                } else {
                    try {
                        TendartsClient.instance(context).onUserRejectedLocationPermission();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return;
            }
        }
    }

    public static void onResume(final Context context) {
        Log.d((String)"sdk", (String)("onResume, access sent: " + t));
        if (i != null) {
            i.onResume();
        }
        if (Configuration.getAccessToken(context) == null) {
            return;
        }
        String string2 = Configuration.instance(context).getPushCode();
        if (string2 != null && !t) {
            t = true;
            try {
                Communications.postData(String.format("https://10darts.com/api/v1/devices/%s/access/", Configuration.instance(context).getPushCode()), Util.getProvider(), 0, new ICommunicationObserver(){

                    @Override
                    public void onSuccess(int operationId, JSONObject data) {
                        Log.d((String)"DARTS", (String)"sent device access");
                        TendartsClient.instance(context).logEvent("App", "sent device access", "");
                    }

                    @Override
                    public void onFail(int operationId, String reason, Communications.PendingCommunication pc) {
                        String string2;
                        Log.d((String)"DARTS", (String)("could not send device access: " + reason));
                        TendartsClient.instance(context).logEvent("App", "Can't device access", "" + reason);
                        Util.checkUnauthorized(reason, context);
                        if (reason != null && reason.contains("404") && (string2 = Configuration.instance(context.getApplicationContext()).getPush()) != null) {
                            PushController.sendTokenAndVersion(string2, context.getApplicationContext(), true);
                        }
                    }
                }, "");
            }
            catch (Exception exception) {
                Log.i((String)"DARTS", (String)("send device access error: " + exception.getMessage()));
                TendartsClient.instance(context).remoteLogException(exception);
                exception.printStackTrace();
            }
        }
    }

    public static void onPause() {
        try {
            if (i != null) {
                i.onPause();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void onStart() {
        try {
            try {
                Context context = Configuration.getWeakContext();
                if (context != null && Configuration.shouldSendGeostats(context) && Configuration.getAccessToken(context) != null) {
                    Communications.sendGeoStats(Util.getProvider());
                    Configuration.notifyGeostatsSent(context);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (i != null) {
                i.onStart();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void onStop() {
        try {
            if (i != null) {
                i.onStop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void onDestroy() {
        if (i != null) {
            i.onDestroy();
        }
    }

    public static void onCreate(Bundle savedInstanceState, Activity activity, final ILocationAlerter locationAlerter) {
        TendartsSDK.initCommunications(activity.getApplicationContext());
        if (activity == null) {
            throw new InvalidParameterException("activity should not be null, pass your main activity");
        }
        if (locationAlerter == null) {
            throw new InvalidParameterException("you should provide an instance that implements ILocationAlerter");
        }
        Communications.setLocationAlerter(new Communications.ILocationAlerter(){

            @Override
            public void alertNotEnabled(Activity parent) {
                locationAlerter.alertNotEnabled(parent);
            }
        });
        try {
            if (TendartsSDK.a(activity)) {
                Intent intent = new Intent(activity.getApplicationContext(), GCMRegistrationIntentService.class);
                activity.startService(intent);
            }
        }
        catch (Exception exception) {
            Log.e((String)"", (String)"Error requesting play services");
            exception.printStackTrace();
        }
        try {
            i = new GoogleUpdates(activity.getApplicationContext(), activity);
            boolean bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = Configuration.instance(activity.getApplicationContext()).getPush();
        if (string2 != null) {
            PushController.sendTokenAndVersion(string2, activity.getApplicationContext());
        }
        try {
            Date date = new Date();
            long l = date.getTime() - s.getTime();
            if (l > 8600000L) {
                s = date;
                activity.sendBroadcast(new Intent("com.google.android.intent.action.GTALK_HEARTBEAT"));
                activity.sendBroadcast(new Intent("com.google.android.intent.action.MCS_HEARTBEAT"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (Configuration.shouldSendGeostats(activity.getApplicationContext()) && Configuration.getAccessToken(activity.getApplicationContext()) != null) {
                Communications.sendGeoStats(Util.getProvider());
                Configuration.notifyGeostatsSent(activity.getApplicationContext());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PendingCommunicationsService.startPendingCommunications(activity.getApplicationContext());
    }

    public static void initCommunications(Context context) {
        Communications.init(context);
    }

    private static boolean a(Activity activity) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(activity.getApplicationContext());
        if (n != 0) {
            if (googleApiAvailability.isUserResolvableError(n)) {
                googleApiAvailability.getErrorDialog(activity, n, 9000).show();
            }
            return false;
        }
        return true;
    }

    public static void deleteNotificationFromList(String notificationCode, Context context) {
        PersistentPush.removeById(notificationCode, context);
    }

    public static void deleteAllNotifications(Context context) {
        PersistentPush.clear(context);
    }

    public static ArrayList<Notification> getNotificationsList(Context context) {
        return PersistentPush.getStored(context);
    }

    public static void showStackedNotificationstNotification(Context context) {
        GCMListenerService.notifyList(context, (NotificationManager)context.getSystemService("notification"), null, PersistentPush.getStored(context));
    }

    public static void notifyNotificationRead(String notificationCode, final Context context) {
        if (Configuration.getAccessToken(context) == null) {
            return;
        }
        String string2 = Util.getDeviceJson(context);
        String string3 = String.format("https://10darts.com/api/v1/pushes/%s/read/", notificationCode);
        Log.d((String)"NET", (String)("sending pchd: " + string3 + "\n" + string2));
        Communications.patchData(string3, Util.getProvider(), 0, new ICommunicationObserver(){

            @Override
            public void onSuccess(int operationId, JSONObject data) {
                TendartsClient.instance(context).logEvent("Push", "succesfully notified read", "");
                Log.d((String)"DARTS", (String)"push read notified");
            }

            @Override
            public void onFail(int operationId, String reason, Communications.PendingCommunication pending) {
                Util.checkUnauthorized(reason, context);
                TendartsClient.instance(context).logEvent("App", "can't notify read", "" + reason);
                Log.d((String)"DARTS", (String)("push read failed: " + reason));
                PendingCommunicationController.addPending(pending, context);
            }
        }, string2, false);
    }

    public static void notifyAllNotificationsRead(final Context context) {
        if (Configuration.getAccessToken(context) == null) {
            return;
        }
        String string2 = Util.getDeviceJson(context);
        Log.d((String)"NET", (String)("sending pchd: " + string2));
        Communications.patchData("https://10darts.com/api/v1/pushes/all_read/", Util.getProvider(), 0, new ICommunicationObserver(){

            @Override
            public void onSuccess(int operationId, JSONObject data) {
                TendartsClient.instance(context).logEvent("App", "push all read notified", "");
                Log.d((String)"DARTS", (String)"push all read notified");
            }

            @Override
            public void onFail(int operationId, String reason, Communications.PendingCommunication pending) {
                Util.checkUnauthorized(reason, context);
                TendartsClient.instance(context).logEvent("App", "push all read failed", "" + reason);
                Log.d((String)"DARTS", (String)("push all read failed: " + reason));
                PendingCommunicationController.addPending(pending, context);
            }
        }, string2, false);
    }

    public static void onNewLocation() {
        if (u == null) {
            return;
        }
        IGeoLocationReceiver iGeoLocationReceiver = (IGeoLocationReceiver)u.get();
        if (iGeoLocationReceiver == null) {
            return;
        }
        iGeoLocationReceiver.onNewLocation(new GeoLocation(Communications.getLatitude(), Communications.getLongitude(), Communications.getLastPrecission(), Communications.getLastProvider(), Communications.getLastSource()));
    }

    public static String getDeviceCode(Context context) {
        return Configuration.instance(context).getPushCode();
    }

    public static GeoLocation getCurrentGeoLocation() {
        i.getLocationUpdates(true, false);
        return new GeoLocation(Communications.getLatitude(), Communications.getLongitude(), Communications.getLastPrecission(), Communications.getLastProvider(), Communications.getLastSource());
    }

    public static void registerGeoLocationReceiver(IGeoLocationReceiver receiver) {
        u = new WeakReference<IGeoLocationReceiver>(receiver);
    }

    public static void unregisterGeoLocationReceiver() {
        u = null;
    }

    public static void disableGeolocationUpdates() {
        if (i != null) {
            i.onPause();
        }
    }

    public static void enableGeolocationUpdates() {
        if (i != null) {
            i.startLocationUpdates();
        }
    }

    public static void changeNotificationsEnabled(boolean enabled, Context context) {
        Configuration.instance(context).setNotificationsEnabled(enabled);
        TendartsSDK.a(enabled, context);
    }

    public static boolean getNotificationsEnabled(Context context) {
        boolean bl = Configuration.instance(context).getNotificationsEnabled();
        TendartsSDK.a(bl, context);
        return bl;
    }

    private static void a(final boolean bl, final Context context) {
        Configuration.instance(context).setNotificationsEnabled(bl);
        try {
            if (Configuration.getAccessToken(context) == null) {
                return;
            }
            JSONObject jSONObject = new JSONObject();
            String string2 = Configuration.instance(context).getPushCode();
            try {
                jSONObject.put("disabled", !bl);
                Communications.addGeoData(jSONObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (string2 == null) {
                TendartsClient.instance(context).logEvent("Notifications", "senabled config change not set due to device not registered yet", "" + bl);
                return;
            }
            Log.d((String)"net", (String)("PtcD: " + jSONObject));
            Communications.patchData(String.format("https://10darts.com/api/v1/devices/%s/", string2), Util.getProvider(), 0, new ICommunicationObserver(){

                @Override
                public void onSuccess(int operationId, JSONObject data) {
                    TendartsClient.instance(context).logEvent("Notifications", "successfully sent notification enabled config change", "" + bl);
                    Log.i((String)"NOT", (String)("notificationChange pushed" + data));
                }

                @Override
                public void onFail(int operationId, String reason, Communications.PendingCommunication pc) {
                    Util.checkUnauthorized(reason, context);
                    TendartsClient.instance(context).logEvent("Notifications", "error sending notification enabled config change", "" + reason);
                    Log.i((String)"NOT", (String)("notificationChange failed" + reason));
                }
            }, jSONObject.toString(), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void notificationClicked(String notificationCode, final Context context) {
        if (Configuration.getAccessToken(context) == null) {
            return;
        }
        String string2 = Util.getDeviceJson(context);
        String string3 = String.format("https://10darts.com/api/v1/pushes/%s/follow/", notificationCode);
        Log.d((String)"NET", (String)("sending pchd: " + string3 + "\n" + string2));
        Communications.patchData(string3, Util.getProvider(), 0, new ICommunicationObserver(){

            @Override
            public void onSuccess(int operationId, JSONObject data) {
                TendartsClient.instance(context).logEvent("Push", "succesfully notified follow", "");
                Log.d((String)"DARTS", (String)"push read notified");
            }

            @Override
            public void onFail(int operationId, String reason, Communications.PendingCommunication pending) {
                Util.checkUnauthorized(reason, context);
                TendartsClient.instance(context).logEvent("App", "can't notify follow", "" + reason);
                PendingCommunicationController.addPending(pending, context);
                Log.d((String)"DARTS", (String)("push read failed: " + reason));
            }
        }, string2, false);
    }

    public static void linkDeviceWithUserIdentifier(final IResponseObserver observer, final Context context, String userIdentifier) {
        try {
            if (Configuration.getAccessToken(context) == null) {
                if (observer != null) {
                    observer.onFail("SDK not properly initialized");
                }
                return;
            }
            String string2 = Configuration.instance(context).getPushCode();
            if (string2 == null || string2.length() < 3) {
                PendingCommunicationController.setPendingLink(userIdentifier, context);
                String string3 = Configuration.instance(context).getPush();
                if (string3 != null && string3.length() > 3) {
                    PushController.sendTokenAndVersion(string3, context);
                }
                if (observer != null) {
                    observer.onFail("Device not registered yet, try a few seconds later");
                }
                return;
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("client_data", (Object)userIdentifier);
            String string4 = String.format("/api/v1/devices/%s/", Configuration.instance(context).getPushCode());
            jSONObject.put("device", (Object)string4);
            Communications.postData("https://10darts.com/api/v1/devices/links/", Util.getProvider(), 0, new ICommunicationObserver(){

                @Override
                public void onSuccess(int operationId, JSONObject data) {
                    if (data.has("persona") && !data.isNull("persona")) {
                        try {
                            String string2 = data.getString("persona");
                            Configuration.instance(context).setUserCode(string2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (observer != null) {
                        observer.onOk();
                    }
                }

                @Override
                public void onFail(int operationId, String reason, Communications.PendingCommunication pc) {
                    PendingCommunicationController.addPending(pc, context);
                    Util.checkUnauthorized(reason, context);
                    if (observer != null) {
                        observer.onFail(reason);
                    }
                }
            }, jSONObject.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void linkUserToDevice(final IResponseObserver observer, final Context context) {
        if (observer == null) {
            throw new InvalidParameterException("observer can't be null");
        }
        if (Configuration.getAccessToken(context) == null) {
            if (observer != null) {
                observer.onFail("SDK not properly initialized");
            }
            return;
        }
        String string2 = Configuration.instance(context).getUserCode();
        if (string2 == null) {
            throw new IllegalStateException("the user should be already registered");
        }
        try {
            JSONObject jSONObject = new JSONObject();
            String string3 = Configuration.instance(context).getPushCode();
            if (string3 == null) {
                observer.onFail("device not yet registered");
                return;
            }
            try {
                jSONObject.put("persona", (Object)string2);
                Communications.addGeoData(jSONObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Log.d((String)"net", (String)("PtcD: " + jSONObject));
            Communications.patchData(String.format("https://10darts.com/api/v1/devices/%s/", string3), Util.getProvider(), 0, new ICommunicationObserver(){

                @Override
                public void onSuccess(int operationId, JSONObject data) {
                    observer.onOk();
                    Log.i((String)"NOT", (String)("device linked" + data));
                }

                @Override
                public void onFail(int operationId, String reason, Communications.PendingCommunication pc) {
                    Util.checkUnauthorized(reason, context);
                    observer.onFail(reason);
                    Log.i((String)"NOT", (String)("device link failed" + reason));
                }
            }, jSONObject.toString(), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void registerUser(String email, String firstName, String lastName, String password, final IResponseObserver observer, final Context context) {
        if (email == null || email.length() < 4 || !email.contains("@")) {
            throw new InvalidParameterException("provide a valid email");
        }
        if (observer == null) {
            throw new InvalidParameterException("provide an observer");
        }
        if (Configuration.getAccessToken(context) == null) {
            if (observer != null) {
                observer.onFail("SDK not properly initialized");
            }
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("email", (Object)email);
            if (firstName != null && firstName.length() > 0) {
                jSONObject.put("first_name", (Object)firstName);
            }
            if (lastName != null && lastName.length() > 0) {
                jSONObject.put("last_name", (Object)lastName);
            }
            if (password != null && password.length() > 0) {
                jSONObject.put("password", (Object)password);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Log.d((String)"USR", (String)("sending registration: " + jSONObject));
        Communications.postData("https://10darts.com/api/v1/personas/", Util.getProvider(), 0, new ICommunicationObserver(){

            @Override
            public void onSuccess(int operationId, JSONObject data) {
                Log.d((String)"USR", (String)("successfuly registered:" + data));
                observer.onOk();
            }

            @Override
            public void onFail(int operationId, String reason, Communications.PendingCommunication pc) {
                Util.checkUnauthorized(reason, context);
                Log.d((String)"USR", (String)("failed registration: " + reason));
                observer.onFail(reason);
            }
        }, jSONObject.toString(), false);
    }

    public static void delayedInit(String accessToken, String gcmSenderId, String clientClassName, Context context) {
        TendartsClient.refreshInstance();
        Configuration.instance(context).setSoftAccessToken(accessToken);
        Configuration.instance(context).setAccessToken(accessToken);
        Configuration.instance(context).setSoftClientClassName(clientClassName);
        Configuration.instance(context).setSoftGCMDefaultSenderId(gcmSenderId);
        Intent intent = new Intent(context.getApplicationContext(), GCMRegistrationIntentService.class);
        context.startService(intent);
    }

    public static void modifyUser(String email, String firstName, String lastName, String password, final IResponseObserver observer, final Context context) {
        if (observer == null) {
            throw new InvalidParameterException("provide an observer");
        }
        if (Configuration.getAccessToken(context) == null) {
            if (observer != null) {
                observer.onFail("SDK not properly initialized");
            }
            return;
        }
        if (Configuration.instance(context).getUserCode() == null) {
            observer.onFail("User not yet registered, please register first");
            return;
        }
        String string2 = Configuration.instance(context).getUserCode();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("email", (Object)email);
            if (firstName != null && firstName.length() > 0) {
                jSONObject.put("first_name", (Object)firstName);
            }
            if (lastName != null && lastName.length() > 0) {
                jSONObject.put("last_name", (Object)lastName);
            }
            if (password != null && password.length() > 0) {
                jSONObject.put("password", (Object)password);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Log.d((String)"USR", (String)("sending modification: " + jSONObject));
        Communications.patchData(string2, Util.getProvider(), 0, new ICommunicationObserver(){

            @Override
            public void onSuccess(int operationId, JSONObject data) {
                Log.d((String)"USR", (String)("successfuly modified:" + data));
                observer.onOk();
            }

            @Override
            public void onFail(int operationId, String reason, Communications.PendingCommunication pc) {
                Util.checkUnauthorized(reason, context);
                Log.d((String)"USR", (String)("failed modification: " + reason));
                observer.onFail(reason);
            }
        }, jSONObject.toString(), false);
    }

    static {
        s = new Date(0L);
        t = false;
        j = 0;
    }

    public static interface ILocationAlerter {
        public void alertNotEnabled(Activity var1);
    }

    public static interface IResponseObserver {
        public void onOk();

        public void onFail(String var1);
    }

    public static interface IGeoLocationReceiver {
        public void onNewLocation(GeoLocation var1);
    }

    public static class GeoLocation {
        public double latitude;
        public double longitude;
        public double precision;
        public String provider;
        public String source;

        public GeoLocation(double latitude, double longitude, double precision, String provider, String source) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.precision = precision;
            this.provider = provider;
            this.source = source;
        }
    }
}

