/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.client;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.util.Log;
import android.widget.RemoteViews;
import com.tendarts.sdk.Model.Notification;
import com.tendarts.sdk.Model.PersistentPush;
import com.tendarts.sdk.client.IGeolocation;
import com.tendarts.sdk.client.INotifications;
import com.tendarts.sdk.client.ISDKCore;
import com.tendarts.sdk.client.IUIStrings;
import com.tendarts.sdk.client.a;
import com.tendarts.sdk.common.Configuration;
import java.security.InvalidParameterException;

public abstract class TendartsClient
extends BroadcastReceiver
implements IGeolocation,
INotifications,
ISDKCore,
IUIStrings {
    private static TendartsClient a;

    public static final void refreshInstance() {
        a = null;
    }

    public static final TendartsClient instance(Context context) {
        return TendartsClient.instance(context.getApplicationContext(), null);
    }

    public static final TendartsClient instance(Context context, ApplicationInfo info) {
        Context context2 = context;
        if (context != null) {
            context2 = context.getApplicationContext();
        }
        if (a == null) {
            Log.d((String)"SDKClient", (String)"instance: creating from context");
            if (context2 == null) {
                Log.w((String)"SDKClient", (String)"instance: no context!!!!!");
                return new a();
            }
            String string = null;
            if (info != null) {
                Log.d((String)"SDKClient", (String)("instance: initiating from " + info));
                string = Configuration.getClientClassName(context2, info);
            } else {
                string = Configuration.getClientClassName(context2);
            }
            if (string != null && string.length() > 0) {
                Log.d((String)"SDKClient", (String)("client class: " + string));
                try {
                    a = (TendartsClient)Class.forName(string).newInstance();
                    a.performSetup(context);
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    Log.e((String)"DartsSDK:Config", (String)"Please add  tendarts_sdk_client_class:\\\"com.yourcompany.YourClientClass\\\" in manifestPlaceholders");
                    throw new InvalidParameterException("Error instantiating " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    Log.e((String)"DartsSDK:Config", (String)"Please add  tendarts_sdk_client_class:\\\"com.yourcompany.YourClientClass\\\" in manifestPlaceholders");
                    throw new InvalidParameterException("Illegal Access instantiating " + string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    Log.e((String)"DartsSDK:Config", (String)"Please add  tendarts_sdk_client_class:\\\"com.yourcompany.YourClientClass\\\" in manifestPlaceholders");
                    throw new InvalidParameterException("could not find " + string);
                }
                catch (Exception exception) {
                    throw new InvalidParameterException("Exception instantiating " + string);
                }
            } else {
                Log.w((String)"SDKClient", (String)("could not get client class: " + string));
            }
            if (a == null) {
                a = new a();
            }
        }
        return a;
    }

    public final void onReceive(Context context, Intent intent) {
        String string;
        if (intent != null && "com.darts.sdk.CLEAR_PUSHES".equalsIgnoreCase(string = intent.getAction())) {
            int n;
            PersistentPush.clear(context);
            Log.i((String)"SDKClient", (String)"clearing push list");
            if (intent.hasExtra("dismiss") && (n = intent.getIntExtra("dismiss", -1)) != -1) {
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                notificationManager.cancel(n);
            }
            try {
                this.logEvent("Push", "clear list from push", "");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.onNotificationListCleared();
            return;
        }
    }

    @Override
    public void onUserRejectedLocationPermission() {
    }

    @Override
    public void onUserAcceptedLocationPermission() {
    }

    @Override
    public void remoteLogException(Exception e) {
    }

    @Override
    public void logEvent(String category, String type, String message) {
    }

    @Override
    public void performSetup(Context context) {
    }

    @Override
    public void onNotificationShowed(Notification notification) {
    }

    @Override
    public void onNotificationShowedInList(Notification notification) {
    }

    @Override
    public boolean onNotificationReceived(Notification notification) {
        return false;
    }

    @Override
    public boolean onNotificationClicked(Notification notification) {
        return false;
    }

    @Override
    public boolean onNotificationListCleared() {
        return false;
    }

    @Override
    public boolean openNotification(Notification notification, Context context) {
        return false;
    }

    @Override
    public void openNotificationList(Context context) {
    }

    @Override
    public boolean notificationHasImage(Notification notification) {
        return false;
    }

    @Override
    public RemoteViews getCustomNotificationSmallView(Notification notification, Context context) {
        return null;
    }

    @Override
    public RemoteViews getCustomNotificationLargeView(Notification notification, Context context) {
        return null;
    }

    @Override
    public void loadBackgroundCustomNotificationData(INotifications.IBackgroundCustomNotificationLoaderListener listener, Notification notification, RemoteViews rv, RemoteViews rvBig, Context context) {
    }

    @Override
    public CharSequence getLocationExplanation(Context context) {
        return null;
    }

    @Override
    public void onUserLinkedToDevice() {
    }
}

