/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.util.Log;
import com.tendarts.sdk.Model.Notification;
import com.tendarts.sdk.TendartsSDK;
import com.tendarts.sdk.client.TendartsClient;
import com.tendarts.sdk.common.Configuration;
import com.tendarts.sdk.common.PendingCommunicationController;
import com.tendarts.sdk.common.Util;
import com.tendarts.sdk.communications.Communications;
import com.tendarts.sdk.communications.ICommunicationObserver;
import java.util.Locale;
import org.json.JSONObject;

public class PushController {
    private static PushController a;
    public static final int NOTIFICATION_ID = 5525;
    public static final int SINGLE_ID = 5526;

    public static int getNotificationId(Notification notification) {
        String string;
        if (!TendartsSDK.instance().getStackNotifications() && notification != null && (string = notification.getCode()) != null) {
            return string.hashCode();
        }
        return 5526;
    }

    private PushController() {
    }

    public static PushController instance() {
        if (a == null) {
            a = new PushController();
        }
        return a;
    }

    public static void sendRegistrationToken(String token, Context context) {
        if (token == null) {
            return;
        }
        Configuration.instance(context).setPush(token);
        PushController.sendTokenAndVersion(token, context);
    }

    public static void sendTokenAndVersion(String token, Context context) {
        PushController.sendTokenAndVersion(token, context, false);
    }

    public static void sendTokenAndVersion(String token, final Context context, boolean force) {
        Object object;
        TendartsSDK.initCommunications(context);
        if (Configuration.getAccessToken(context) == null) {
            return;
        }
        int n = 0;
        String string = "";
        try {
            if (Configuration.instance(context).getNotificationsEnabled()) {
                n = 1;
            }
            n += 10 * Util.isNotificationEnabled(context);
            if (Util.isGooglePlayServicesAvailable(context)) {
                n += 100;
            }
            n += 1000 * Util.isPrimaryAccountConfigured(context);
            n += 1000000 * Util.getSDKLevel();
            string = Build.MANUFACTURER + "|" + Build.MODEL;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = "";
        if (context != null) {
            try {
                object = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                string2 = ((PackageInfo)object).versionName;
            }
            catch (Exception exception) {
                Log.e((String)"SDK:PUSH", (String)exception.getMessage());
            }
        }
        object = token + string2;
        String string3 = null;
        try {
            string3 = Locale.getDefault().getLanguage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!((String)object).equals(Configuration.instance(context).getPushSentToken()) || force || Configuration.instance(context).getPushCode() == null) {
            Object object2;
            String string4 = Configuration.instance(context).getPushCode();
            String string5 = "{ \"token\":\"" + token + "\", \"platform\":\"android\" , \"version\":\"" + string2 + "\", \"push_status\":" + n + " }";
            try {
                object2 = new JSONObject();
                object2.put("token", (Object)token);
                object2.put("platform", (Object)"android");
                object2.put("version", (Object)string2);
                object2.put("push_status", n);
                object2.put("model", (Object)string);
                object2.put("source", (Object)Configuration.instance(context).getInstallSource());
                PendingCommunicationController.addPendingTokenInfo(object2, context);
                if (string3 != null) {
                    object2.put("language", (Object)string3);
                }
                Communications.addGeoData(object2);
                string5 = object2.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Log.d((String)"SDK:PUSH", (String)("sendTokenAndVersion: " + string5));
            object2 = string5;
            boolean bl = string4 != null;
            ICommunicationObserver iCommunicationObserver = new ICommunicationObserver((String)object, bl, token, (String)object2, force){
                final /* synthetic */ String b;
                final /* synthetic */ boolean c;
                final /* synthetic */ String d;
                final /* synthetic */ String e;
                final /* synthetic */ boolean f;
                {
                    this.b = string;
                    this.c = bl;
                    this.d = string2;
                    this.e = string3;
                    this.f = bl2;
                }

                @Override
                public void onSuccess(int operationId, JSONObject data) {
                    this.a(data);
                }

                public void a(JSONObject jSONObject) {
                    try {
                        String string;
                        Log.d((String)"SDK:PUSH", (String)("handleSuccess: " + jSONObject));
                        if (jSONObject.has("code") && !jSONObject.isNull("code")) {
                            string = jSONObject.getString("code");
                            if (string != null) {
                                if (string.toLowerCase().contains("null")) {
                                    PendingCommunicationController.addPendingToken("registered with null in code:" + jSONObject, context);
                                } else {
                                    Configuration.instance(context).setPushCode(string);
                                    Configuration.instance(context).setPushSentToken(this.b);
                                    PendingCommunicationController.onTokenSent(context);
                                }
                            }
                        } else if (!this.c) {
                            PendingCommunicationController.addPendingToken("registered with no code:" + jSONObject, context);
                        }
                        if (jSONObject.has("persona") && !jSONObject.isNull("persona")) {
                            string = jSONObject.getString("persona");
                            Configuration.instance(context).setUserCode(string);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PendingCommunicationController.addPendingToken(exception.getMessage(), context);
                    }
                    TendartsClient.instance(context).logEvent("Push", "sent token info", "");
                    Log.i((String)"SDK:PUSH", (String)("succesfully sent token to backend " + this.d));
                }

                @Override
                public void onFail(int operationId, String reason, Communications.PendingCommunication pc) {
                    String string = Configuration.instance(context).getPushCode();
                    Util.checkUnauthorized(reason, context);
                    if (reason != null && reason.contains("400") && string != null) {
                        Communications.patchData(String.format("https://10darts.com/api/v1/devices/%s/", string), Util.getProvider(), 0, new ICommunicationObserver(){

                            @Override
                            public void onSuccess(int operationId, JSONObject data) {
                                this.a(data);
                            }

                            @Override
                            public void onFail(int operationId, String reason, Communications.PendingCommunication pc) {
                                Util.checkUnauthorized(reason, context);
                                Log.e((String)"SDK:PUSH", (String)("error sending token to backend " + d));
                                TendartsClient.instance(context).logEvent("Push", "error sending token info", reason);
                                PendingCommunicationController.addPendingToken("400:" + reason, context);
                            }
                        }, this.e, false);
                    } else {
                        if (!this.f) {
                            Configuration.instance(context).setPushSentToken(null);
                            Configuration.instance(context).setPushUser(null);
                        }
                        Log.e((String)"SDK:PUSH", (String)("error sending token to backend " + this.d));
                        TendartsClient.instance(context).logEvent("Push", "error sending token info", reason);
                        PendingCommunicationController.addPendingToken(reason, context);
                    }
                }
            };
            if (string4 != null) {
                Communications.patchData(String.format("https://10darts.com/api/v1/devices/%s/", string4), Util.getProvider(), 0, iCommunicationObserver, string5, false);
            } else {
                Communications.postData("https://10darts.com/api/v1/devices/", Util.getProvider(), 0, iCommunicationObserver, string5);
            }
        }
    }
}

