/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.common;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import com.tendarts.sdk.client.TendartsClient;
import com.tendarts.sdk.common.Configuration;
import com.tendarts.sdk.communications.Communications;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.json.JSONObject;

public class Util {
    static Communications.ICommunicationsConfigProvider a = null;

    @SuppressLint(value={"NewApi"})
    public static int isNotificationEnabled(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                String string = context.getApplicationContext().getPackageName();
                int n = applicationInfo.uid;
                Class<?> clazz = null;
                clazz = Class.forName(AppOpsManager.class.getName());
                Method method = clazz.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = clazz.getDeclaredField("OP_POST_NOTIFICATION");
                int n2 = (Integer)field.get(Integer.class);
                return (Integer)method.invoke((Object)appOpsManager, n2, n, string) == 0 ? 1 : 0;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 2;
    }

    public static boolean isGooglePlayServicesAvailable(Context context) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        return n == 0;
    }

    public static int isPrimaryAccountConfigured(Context context) {
        try {
            Account[] accountArray = AccountManager.get((Context)context).getAccounts();
            if (accountArray.length > 0) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
    }

    public static int getSDKLevel() {
        try {
            return Build.VERSION.SDK_INT;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static void printExtras(String tag, Bundle extras) {
        try {
            StringBuilder stringBuilder = new StringBuilder("Extras:\n");
            if (extras == null) {
                stringBuilder.append("null");
            } else {
                for (String string : extras.keySet()) {
                    Object object = extras.get(string);
                    stringBuilder.append(string).append(": ").append(object).append("\n");
                }
            }
            Log.i((String)tag, (String)stringBuilder.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setBadgeCount(int count, Context context) {
        Intent intent;
        try {
            Configuration.instance(context).setLastBadge(count);
            intent = new Intent("android.intent.action.BADGE_COUNT_UPDATE");
            intent.putExtra("badge_count", count);
            intent.putExtra("badge_count_package_name", context.getPackageName());
            intent.putExtra("badge_count_class_name", TendartsClient.instance(context).mainActivityClassName());
            context.sendBroadcast(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            intent = new Intent("com.sonyericsson.home.action.UPDATE_BADGE");
            intent.putExtra("com.sonyericsson.home.intent.extra.badge.ACTIVITY_NAME", TendartsClient.instance(context).mainActivityClassName());
            intent.putExtra("com.sonyericsson.home.intent.extra.badge.SHOW_MESSAGE", true);
            intent.putExtra("com.sonyericsson.home.intent.extra.badge.MESSAGE", String.valueOf(count));
            intent.putExtra("com.sonyericsson.home.intent.extra.badge.PACKAGE_NAME", context.getPackageName());
            context.sendBroadcast(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getFullDeviceUrl(Context context) {
        return String.format("https://10darts.com/api/v1/devices/%s/", Configuration.instance(context).getPushCode());
    }

    public static String getDeviceJson(Context context) {
        String string = String.format("/api/v1/devices/%s/", Configuration.instance(context).getPushCode());
        String string2 = null;
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("device", (Object)string);
            string2 = jSONObject.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Log.d((String)"NET:", (String)("DeviceJson: " + string2));
        return string2;
    }

    public static int getResId(String resName, Class<?> c) {
        try {
            Field field = c.getDeclaredField(resName);
            return field.getInt(field);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static Communications.ICommunicationsConfigProvider getProvider() {
        if (a == null) {
            final Context context = Communications.getContext();
            a = new Communications.ICommunicationsConfigProvider(){

                @Override
                public String getPushCode() {
                    return Configuration.instance(context).getPushCode();
                }

                @Override
                public String getGeostatsUrlFormat() {
                    return "https://10darts.com/api/v1/devices/%s/";
                }

                @Override
                public ArrayList<Communications.CHeader> getHeaders() {
                    StringBuilder stringBuilder = new StringBuilder().append("Token ");
                    Configuration.instance(context);
                    Communications.CHeader cHeader = new Communications.CHeader("Authorization", stringBuilder.append(Configuration.getAccessToken(context)).toString());
                    ArrayList<Communications.CHeader> arrayList = new ArrayList<Communications.CHeader>();
                    arrayList.add(cHeader);
                    return arrayList;
                }

                @Override
                public void onGeostatSent(boolean success, String info) {
                    if (success) {
                        TendartsClient.instance(context).logEvent("GEO", "Succesfully  sent geoStats", "");
                    } else {
                        TendartsClient.instance(context).logEvent("GEO", "Failed to send geoStats", "" + info);
                    }
                }
            };
        }
        return a;
    }

    public static void checkUnauthorized(String reason, Context context) {
        if (reason != null && reason.contains("401")) {
            TendartsClient.instance(context).remoteLogException(new Exception(reason));
        }
    }
}

