/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.communications;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public class Bitmaps {
    public static boolean lowMemory = false;

    public static Bitmap bitmapFromFile(int width, int height, String file) {
        return Bitmaps.bitmapFromFile(width, height, file, false);
    }

    public static Bitmap bitmapFromFile(int width, int height, String file, boolean fullColor) {
        return Bitmaps.bitmapFromFile(width, height, file, false, false);
    }

    public static Bitmap bitmapFromFile(int width, int height, String file, boolean fullColor, boolean mutable) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        Log.i((String)"Bitmaps", (String)("Bitmap from file: " + width + "," + height + "calculating factor"));
        if (height < 1) {
            height = 320;
        }
        if (width < 1) {
            width = 512;
        }
        if (height > 0 && width > 0) {
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)file, (BitmapFactory.Options)options);
            options.inSampleSize = Bitmaps.calculateInSampleSize(options, width, height);
            options.inJustDecodeBounds = false;
        } else {
            options.inSampleSize = 2;
        }
        try {
            if (!fullColor) {
                options.inPreferredConfig = Bitmap.Config.RGB_565;
            }
            if (mutable) {
                options.inMutable = true;
            }
            Log.i((String)"Bitmaps", (String)("decoding factor:" + options.inSampleSize + " " + width + "," + height + " for file:" + file));
            bitmap = BitmapFactory.decodeFile((String)file, (BitmapFactory.Options)options);
            ExifInterface exifInterface = new ExifInterface(file);
            int n = exifInterface.getAttributeInt("Orientation", 0);
            Log.i((String)"Bitmaps", (String)("orientation: " + n));
            Matrix matrix = new Matrix();
            switch (n) {
                case 1: {
                    return bitmap;
                }
                case 2: {
                    matrix.setScale(-1.0f, 1.0f);
                    break;
                }
                case 3: {
                    matrix.setRotate(180.0f);
                    break;
                }
                case 4: {
                    matrix.setRotate(180.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 5: {
                    matrix.setRotate(90.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 6: {
                    matrix.setRotate(90.0f);
                    break;
                }
                case 7: {
                    matrix.setRotate(-90.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 8: {
                    matrix.setRotate(-90.0f);
                    break;
                }
                default: {
                    return bitmap;
                }
            }
            try {
                Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                bitmap.recycle();
                return bitmap2;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace();
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (bitmap != null) {
                bitmap.recycle();
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"Bitmaps", (String)("Throwable catched!!!" + throwable.getMessage()));
            throwable.printStackTrace();
            if (bitmap != null) {
                bitmap.recycle();
            }
            return null;
        }
        return bitmap;
    }

    public static Bitmap bitmapFromStream(int width, int height, InputStream buffIn) {
        try {
            buffIn.mark(buffIn.available());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (height < 1) {
            height = 512;
        }
        if (width < 1) {
            width = 512;
        }
        if (height > 0 && width > 0) {
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)buffIn, null, (BitmapFactory.Options)options);
            options.inSampleSize = Bitmaps.calculateInSampleSize(options, width, height);
            options.inJustDecodeBounds = false;
        } else {
            options.inSampleSize = 1;
        }
        try {
            buffIn.reset();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)buffIn, null, (BitmapFactory.Options)options);
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        long l = Runtime.getRuntime().freeMemory() / 6L;
        Log.i((String)"Bitmaps", (String)("max free: " + l));
        if (reqHeight < 1) {
            reqHeight = 512;
        }
        if (reqWidth < 1) {
            reqWidth = 512;
        }
        int n = options.outHeight;
        int n2 = options.outWidth;
        int n3 = 1;
        if (n > reqHeight || n2 > reqWidth) {
            int n4 = n;
            int n5 = n2;
            while (Bitmaps.a(n5, reqWidth, n3) && Bitmaps.a(n4, reqHeight, n3)) {
                n3 *= 2;
            }
            if (n * n2 / n3 > 2073600 && (n4 / n3 > reqHeight || n5 / n3 > reqWidth)) {
                n3 *= 2;
            }
            if (n / n3 < 4 && n2 / n3 < 4 && n3 > 1) {
                n3 /= 2;
            }
        }
        return n3;
    }

    private static boolean a(int n, int n2, int n3) {
        int n4 = n / n3;
        int n5 = n / (n3 * 2);
        int n6 = Math.abs(n5 - n2);
        int n7 = Math.abs(n4 - n2);
        return n5 > n2 || n4 > n2 && n6 < n7;
    }

    public static boolean canUseForInBitmap(Bitmap candidate, BitmapFactory.Options targetOptions) {
        if (Build.VERSION.SDK_INT >= 19) {
            int n = targetOptions.outWidth / targetOptions.inSampleSize;
            int n2 = targetOptions.outHeight / targetOptions.inSampleSize;
            int n3 = n * n2 * Bitmaps.a(candidate.getConfig());
            return n3 <= candidate.getAllocationByteCount();
        }
        return candidate.getWidth() == targetOptions.outWidth && candidate.getHeight() == targetOptions.outHeight && targetOptions.inSampleSize == 1;
    }

    static int a(Bitmap.Config config) {
        if (config == Bitmap.Config.ARGB_8888) {
            return 4;
        }
        if (config == Bitmap.Config.RGB_565) {
            return 2;
        }
        if (config == Bitmap.Config.ARGB_4444) {
            return 2;
        }
        if (config == Bitmap.Config.ALPHA_8) {
            return 1;
        }
        return 1;
    }
}

