/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.communications;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.tendarts.sdk.communications.ICommunicationArrayObserver;
import com.tendarts.sdk.communications.ICommunicationObserver;
import com.tendarts.sdk.communications.IImageDownloadObserver;
import com.tendarts.sdk.communications.ImageDownloadThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtilsHC4;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Communications {
    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int MIN_ACCURACY = 1500;
    private static double f;
    private static double g;
    private static String h;
    private static Context i;
    private static LocationManager j;
    private static Date k;
    private static HttpClientContext l;
    private static CookieStore m;
    private static Object n;
    private static WeakReference<ILocationAlerter> o;
    static boolean a;
    public static String lastProvider;
    public static String lastSource;
    public static boolean outOfRange;
    public static float lastPrecission;
    public static float lastSentPrecission;
    private static Date p;
    private static int q;
    static long b;
    static long c;
    static long d;

    public static void init(Context c) {
        i = c;
        m = new BasicCookieStore();
        l = HttpClientContext.create();
        l.setCookieStore(m);
        j = (LocationManager)i.getSystemService("location");
        Log.i((String)"OP:Communications:", (String)("location manager created: " + j + " context " + i));
    }

    public static Context getContext() {
        return i;
    }

    public static boolean isConnected() {
        assert (i != null);
        if (i != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager)i.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        return false;
    }

    public static String convertStreamToString(InputStream stream) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        stream.close();
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGeolocation(double latitude, double longitude) {
        Object object = n;
        synchronized (object) {
            f = latitude;
            g = longitude;
            h = "<geo:" + latitude + ";" + longitude + ">";
        }
    }

    public static double getLatitude() {
        return f;
    }

    public static double getLongitude() {
        return g;
    }

    public static double getLastPrecission() {
        return lastPrecission;
    }

    public static String getLastProvider() {
        return lastProvider;
    }

    public static String getLastSource() {
        return lastSource;
    }

    public static void sendGeoStats(final ICommunicationsConfigProvider provider) {
        final Date date = new Date();
        long l = date.getTime() - p.getTime();
        if (q < 3 || l > 120000L) {
            try {
                if (provider == null) {
                    return;
                }
                String string = provider.getPushCode();
                if (string == null || string.length() < 2) {
                    return;
                }
                boolean bl = Communications.isLocationEnabled();
                boolean bl2 = Communications.isLocationON();
                String string2 = "";
                String string3 = "";
                if (!bl) {
                    string2 = string2 + "NE ";
                }
                if (!bl2) {
                    string2 = string2 + "OFF ";
                }
                if (f != 0.0 && g != 0.0) {
                    string2 = string2 + lastProvider;
                    string3 = string3 + lastSource;
                } else {
                    string2 = string2 + (outOfRange ? "OOR:" + lastProvider : " NoData");
                    string3 = string3 + "LS:" + a + " " + lastSource;
                }
                string3 = string3 + "|acc:" + lastPrecission;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("last_position_origin", (Object)string2);
                jSONObject.put("debug_info", (Object)string3);
                Communications.addGeoData(jSONObject);
                String string4 = String.format(provider.getGeostatsUrlFormat(), string);
                Log.d((String)"OP:Communications:", (String)("sendGeoStats: patch to " + string4 + "\n" + jSONObject + bl));
                Communications.patchData(string4, provider, 0, new ICommunicationObserver(){

                    @Override
                    public void onSuccess(int operationId, JSONObject data) {
                        q++;
                        p = date;
                        provider.onGeostatSent(true, data.toString());
                    }

                    @Override
                    public void onFail(int operationId, String reason, PendingCommunication pending) {
                        provider.onGeostatSent(false, reason);
                        Log.e((String)"OP:Communications:", (String)("sendGeoStats error:" + reason));
                    }
                }, jSONObject.toString(), false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static LatLong getCurrentGeolocation() {
        Communications.updateGeolocation();
        return new LatLong(f, g);
    }

    public static boolean isLocationON() {
        try {
            int n = 0;
            if (Build.VERSION.SDK_INT >= 19) {
                try {
                    n = Settings.Secure.getInt((ContentResolver)i.getContentResolver(), (String)"location_mode");
                }
                catch (Settings.SettingNotFoundException settingNotFoundException) {
                    settingNotFoundException.printStackTrace();
                }
                return n != 0;
            }
            String string = Settings.Secure.getString((ContentResolver)i.getContentResolver(), (String)"location_providers_allowed");
            return !TextUtils.isEmpty((CharSequence)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isLocationEnabled() {
        try {
            if (j == null && i != null && (j = (LocationManager)i.getSystemService("location")) == null) {
                a = false;
            }
            if (j != null) {
                String string = Communications.b();
                if (string == null) {
                    return false;
                }
                Boolean bl = j.isProviderEnabled(string);
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static String b() {
        try {
            String string;
            Criteria criteria = new Criteria();
            criteria.setAccuracy(2);
            criteria.setPowerRequirement(1);
            criteria.setAltitudeRequired(false);
            criteria.setBearingRequired(false);
            criteria.setSpeedRequired(false);
            criteria.setCostAllowed(true);
            lastProvider = string = j.getBestProvider(criteria, true);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            lastProvider = "EXC";
            return "network";
        }
    }

    public static void setLocationAlerter(ILocationAlerter alerter) {
        o = new WeakReference<ILocationAlerter>(alerter);
    }

    public static void alertNoLocation(Activity parent) {
        try {
            if (o == null) {
                return;
            }
            ILocationAlerter iLocationAlerter = (ILocationAlerter)o.get();
            if (iLocationAlerter != null && !Communications.isLocationEnabled()) {
                iLocationAlerter.alertNotEnabled(parent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void updateGeolocation() {
        block19: {
            try {
                Log.i((String)"OP:Communications:", (String)"updating geolocation");
                if (Communications.isLocationEnabled()) {
                    Date date = new Date();
                    boolean bl = k == null || date.getTime() - k.getTime() > 60000L;
                    Location location = null;
                    Log.i((String)"OP:Communications:", (String)"location enabled");
                    if (j != null) {
                        if (f == 0.0 && g == 0.0 || bl) {
                            try {
                                location = j.getLastKnownLocation(Communications.b());
                                if (location != null) {
                                    Log.i((String)"OP:Communications:", (String)("location new location " + location.getLatitude() + " p:" + location.getProvider() + " acc:" + location.getAccuracy()));
                                }
                            }
                            catch (SecurityException securityException) {
                                securityException.printStackTrace();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    } else {
                        Log.i((String)"OP:Communications:", (String)"location manager not found");
                    }
                    if (location != null) {
                        float f = location.getAccuracy();
                        lastSource = "LastKnown";
                        lastProvider = location.getProvider();
                        lastPrecission = location.getAccuracy();
                        if (f < 1500.0f && f != 0.0f) {
                            outOfRange = false;
                            Communications.setGeolocation(location.getLatitude(), location.getLongitude());
                            k = new Date();
                            k = date;
                        } else {
                            outOfRange = true;
                        }
                        break block19;
                    }
                    try {
                        if (o == null) {
                            return;
                        }
                        ILocationAlerter iLocationAlerter = (ILocationAlerter)o.get();
                        if (iLocationAlerter == null || !bl) break block19;
                        try {
                            iLocationAlerter.alertNotEnabled(null);
                            break block19;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block19;
                }
                Log.i((String)"OP:Communications:", (String)"location not enabled");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(HttpUriRequest httpUriRequest, ICommunicationsConfigProvider iCommunicationsConfigProvider) {
        try {
            if (b++ % 100L == 0L) {
                Communications.updateGeolocation();
            }
            Object object = n;
            synchronized (object) {
                httpUriRequest.addHeader("Geolocation", h);
                httpUriRequest.addHeader("Content-Type", "application/json");
                try {
                    ArrayList<CHeader> arrayList;
                    if (iCommunicationsConfigProvider != null && (arrayList = iCommunicationsConfigProvider.getHeaders()) != null) {
                        for (CHeader cHeader : arrayList) {
                            httpUriRequest.addHeader(cHeader.a, cHeader.b);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Log.d((String)"OP:Communications:", (String)("Geolocation:" + h));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void putData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer, String payload, boolean plain) {
        Communications.putData(url, provider, id, observer, payload, plain, false);
    }

    public static void putData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer, String payload, boolean plain, boolean synchronous) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)10000);
        PendingCommunication pendingCommunication = null;
        try {
            Object object;
            HttpPut httpPut = new HttpPut(url);
            if (plain) {
                httpPut.addHeader("Content-Type", "application/x-www-form-urlencoded");
            } else {
                Communications.a((HttpUriRequest)httpPut, provider);
            }
            pendingCommunication = new PendingCommunication(PendingCommunication.Method.POST, payload, httpPut.getAllHeaders(), url);
            if (payload != null) {
                object = payload;
                StringEntity stringEntity = new StringEntity((String)object, "UTF-8");
                httpPut.setEntity((HttpEntity)stringEntity);
            }
            object = new CommunicationsThread(observer, id, (HttpClient)defaultHttpClient, (HttpUriRequest)httpPut, plain, pendingCommunication);
            if (!synchronous) {
                ((Thread)object).start();
            } else {
                ((CommunicationsThread)object).run();
            }
        }
        catch (Exception exception) {
            if (observer != null) {
                observer.onFail(id, "" + exception.getMessage() + ":" + exception.getCause(), pendingCommunication);
            }
            Log.e((String)"OP:Communications:", (String)("Error getting data:" + exception.getMessage()));
        }
    }

    public static void patchData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer, String payload, boolean plain) {
        Communications.patchData(url, provider, id, observer, payload, plain, false);
    }

    public static void patchData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer, String payload, boolean plain, boolean synchronous) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)10000);
        PendingCommunication pendingCommunication = null;
        try {
            Object object;
            HttpPatch httpPatch = new HttpPatch(url);
            if (plain) {
                httpPatch.addHeader("Content-Type", "application/x-www-form-urlencoded");
            } else {
                Communications.a((HttpUriRequest)httpPatch, provider);
            }
            pendingCommunication = new PendingCommunication(PendingCommunication.Method.PATCH, payload, httpPatch.getAllHeaders(), url);
            if (payload != null) {
                object = payload;
                StringEntity stringEntity = new StringEntity((String)object, "UTF-8");
                httpPatch.setEntity((HttpEntity)stringEntity);
            }
            object = new CommunicationsThread(observer, id, (HttpClient)defaultHttpClient, (HttpUriRequest)httpPatch, plain, pendingCommunication);
            if (!synchronous) {
                ((Thread)object).start();
            } else {
                ((CommunicationsThread)object).run();
            }
        }
        catch (Exception exception) {
            if (observer != null) {
                observer.onFail(id, "" + exception.getMessage() + ":" + exception.getCause(), pendingCommunication);
            }
            Log.e((String)"OP:Communications:", (String)("Error getting data:" + exception.getMessage()));
        }
    }

    public static void postData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer, String payload) {
        Communications.postData(url, provider, id, observer, payload, false, false);
    }

    public static void postData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer, String payload, boolean plain) {
        Communications.postData(url, provider, id, observer, payload, plain, false);
    }

    public static void postData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer, String payload, boolean plain, boolean synchronous) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)10000);
        PendingCommunication pendingCommunication = null;
        try {
            Object object;
            HttpPost httpPost = new HttpPost(url);
            if (plain) {
                httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            } else {
                Communications.a((HttpUriRequest)httpPost, provider);
            }
            pendingCommunication = new PendingCommunication(PendingCommunication.Method.POST, payload, httpPost.getAllHeaders(), url);
            if (payload != null) {
                object = payload;
                StringEntity stringEntity = new StringEntity((String)object, "UTF-8");
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            object = new CommunicationsThread(observer, id, (HttpClient)defaultHttpClient, (HttpUriRequest)httpPost, plain, pendingCommunication);
            if (!synchronous) {
                ((Thread)object).start();
            } else {
                ((CommunicationsThread)object).run();
            }
        }
        catch (Exception exception) {
            if (observer != null) {
                observer.onFail(id, "" + exception.getMessage() + ":" + exception.getCause(), pendingCommunication);
            }
            Log.e((String)"OP:Communications:", (String)("Error getting data:" + exception.getMessage()));
        }
    }

    public static void deleteData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)10000);
        try {
            HttpDelete httpDelete = new HttpDelete(url);
            Communications.a((HttpUriRequest)httpDelete, provider);
            CommunicationsThread communicationsThread = new CommunicationsThread(observer, id, (HttpClient)defaultHttpClient, (HttpUriRequest)httpDelete, false, null);
            communicationsThread.start();
        }
        catch (Exception exception) {
            if (observer != null) {
                observer.onFail(id, "" + exception.getMessage() + ":" + exception.getCause(), null);
            }
            Log.e((String)"OP:Communications:", (String)("Error getting data:" + exception.getMessage()));
        }
    }

    public static ChunkResult postChunk(String url, ICommunicationsConfigProvider provider, int start, int end, int total, RandomAccessFile file, String uploadId, String caption, String position, final IChunkObserver observer, String filename) {
        ChunkResult chunkResult = new ChunkResult();
        chunkResult.statusCode = -1;
        chunkResult.json = new JSONObject();
        try {
            final int n = 1 + end - start;
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)10000);
            byte[] byArray = new byte[n];
            file.seek(start);
            int n2 = file.read(byArray, 0, n);
            if (n2 < 1 || n2 != n) {
                Log.w((String)"OP:Communications:", (String)("postChunk: different chunks:" + n + "," + n2));
            }
            HttpPost httpPost = new HttpPost(url);
            Communications.a((HttpUriRequest)httpPost, provider);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            if (uploadId != null && start != 0) {
                multipartEntityBuilder.addPart("upload_id", (ContentBody)new StringBody(uploadId));
            }
            if (caption != null) {
                multipartEntityBuilder.addPart("caption", (ContentBody)new StringBody(caption));
            }
            if (position != null) {
                multipartEntityBuilder.addPart("position", (ContentBody)new StringBody(position));
            }
            multipartEntityBuilder.addBinaryBody("file", byArray, ContentType.DEFAULT_BINARY, filename == null ? "chunk" : filename);
            final HttpEntity httpEntity = multipartEntityBuilder.build();
            class A
            implements HttpEntity {
                A() {
                }

                public void consumeContent() throws IOException {
                    httpEntity.consumeContent();
                }

                public InputStream getContent() throws IOException, IllegalStateException {
                    return httpEntity.getContent();
                }

                public Header getContentEncoding() {
                    return httpEntity.getContentEncoding();
                }

                public long getContentLength() {
                    return httpEntity.getContentLength();
                }

                public Header getContentType() {
                    return httpEntity.getContentType();
                }

                public boolean isChunked() {
                    return httpEntity.isChunked();
                }

                public boolean isRepeatable() {
                    return httpEntity.isRepeatable();
                }

                public boolean isStreaming() {
                    return httpEntity.isStreaming();
                }

                public void writeTo(OutputStream outStream) throws IOException {
                    class A
                    extends a.b {
                        long a;
                        Date b;

                        public A(OutputStream outputStream) {
                            class B
                            extends FilterOutputStream {
                                public B(OutputStream outputStream) {
                                    super(outputStream);
                                }

                                @Override
                                public void write(int idx) throws IOException {
                                    Log.d((String)"OP:Communications:", (String)"upload write idx ");
                                    this.out.write(idx);
                                }

                                @Override
                                public void write(byte[] bts) throws IOException {
                                    int n;
                                    Log.d((String)"OP:Communications:", (String)("upload write bts " + bts.length));
                                    int n2 = bts.length >> 2;
                                    ++n2;
                                    for (int i = 0; i < bts.length; i += n) {
                                        n = n2;
                                        if (i + n > bts.length) {
                                            n = bts.length - i;
                                        }
                                        this.write(bts, i, n);
                                    }
                                }

                                @Override
                                public void write(byte[] bts, int offset, int length) throws IOException {
                                    Log.d((String)"OP:Communications:", (String)"upload write bts st end ");
                                    this.out.write(bts, offset, length);
                                }

                                @Override
                                public void flush() throws IOException {
                                    this.out.flush();
                                }

                                @Override
                                public void close() throws IOException {
                                    this.out.close();
                                }
                            }
                            super(outputStream);
                            this.a = 0L;
                            this.b = new Date();
                            this.b = new Date();
                        }

                        @Override
                        public void write(byte[] buffer, int offset, int byteCount) throws IOException {
                            this.a += (long)byteCount;
                            long l = new Date().getTime() - this.b.getTime();
                            if (observer != null && l > 750L) {
                                try {
                                    this.b = new Date();
                                    long l2 = n;
                                    if (l2 > 0L) {
                                        float f = 100.0f * (float)this.a / (float)l2;
                                        Log.d((String)"OP:Communications:", (String)("upload chunk: calling observer percentage " + f));
                                        observer.onProgress(f);
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            this.out.write(buffer, offset, byteCount);
                        }
                    }
                    httpEntity.writeTo((OutputStream)new A(outStream));
                }
            }
            A a2 = new A();
            httpPost.removeHeaders("Content-Type");
            httpPost.setEntity((HttpEntity)a2);
            httpPost.addHeader(httpEntity.getContentType());
            httpPost.removeHeaders("Content-range");
            String string = String.format("bytes %d-%d/%d", start, end, total);
            httpPost.addHeader("Content-range", string);
            Log.d((String)"OP:Communications:", (String)(" upload postChunk: " + string));
            if (uploadId != null) {
                httpPost.addHeader("upload_id", uploadId);
            }
            long l = httpPost.getEntity().getContentLength();
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            observer.onProgress(100.0f);
            if (httpResponse != null) {
                int n3;
                chunkResult.statusCode = n3 = httpResponse.getStatusLine().getStatusCode();
                if (n3 >= 200 && n3 < 300) {
                    JSONObject jSONObject;
                    d += httpResponse.getEntity().getContentLength() + l;
                    if ((c += (long)n) > 0L) {
                        Log.d((String)"OP:Communications:", (String)("upload statistics: S" + c + " T" + d + "overhead %" + 100.0f * (float)d / (float)c));
                    }
                    String string2 = null;
                    if (httpResponse.getEntity() != null) {
                        try {
                            string2 = EntityUtilsHC4.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
                            jSONObject = new JSONObject(string2);
                            if (jSONObject.has("upload_id")) {
                                chunkResult.uploadId = jSONObject.getString("upload_id");
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (string2 != null && string2.length() > 3) {
                        chunkResult.json = new JSONObject(string2);
                    }
                    if ((jSONObject = httpResponse.getHeaders("Location")) != null && ((Header[])jSONObject).length > 0) {
                        try {
                            String string3 = jSONObject[0].getValue();
                            int n4 = string3.indexOf("/api");
                            if (n4 > 0) {
                                string3 = string3.substring(n4);
                            }
                            chunkResult.json.put("resource_uri", (Object)string3);
                            int n5 = string3.length() - 1;
                            int n6 = string3.substring(0, end).lastIndexOf("/") + 1;
                            chunkResult.json.put("code", (Object)string3.substring(n6, n5));
                            int n7 = Integer.parseInt(string3.substring(n6, n5));
                            chunkResult.json.put("id", n7);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    return chunkResult;
                }
            } else {
                chunkResult.statusCode = -2;
                return chunkResult;
            }
            String string4 = "";
            InputStream inputStream = httpResponse.getEntity().getContent();
            chunkResult.error = string4 = Communications.convertStreamToString(inputStream);
        }
        catch (Exception exception) {
            chunkResult.statusCode = -3;
            chunkResult.error = exception.getLocalizedMessage();
            Log.e((String)"OP:Communications:", (String)("Error running thread:" + exception.getMessage()));
            exception.printStackTrace();
            return chunkResult;
        }
        return chunkResult;
    }

    public static ChunkResult finishFile(String url, ICommunicationsConfigProvider provider, String md5, String uploadId, int order) {
        ChunkResult chunkResult = new ChunkResult();
        if (uploadId == null) {
            chunkResult.statusCode = -7;
            chunkResult.error = "no upload id";
            return chunkResult;
        }
        chunkResult.statusCode = -1;
        chunkResult.json = new JSONObject();
        try {
            HttpResponse httpResponse;
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)10000);
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            multipartEntityBuilder.addPart("upload_id", (ContentBody)new StringBody(uploadId));
            multipartEntityBuilder.addPart("md5", (ContentBody)new StringBody(md5));
            multipartEntityBuilder.addPart("order", (ContentBody)new StringBody("" + order));
            HttpEntity httpEntity = multipartEntityBuilder.build();
            httpPost.setEntity(httpEntity);
            Communications.a((HttpUriRequest)httpPost, provider);
            httpPost.removeHeaders("Content-Type");
            httpPost.addHeader(httpEntity.getContentType());
            if (uploadId != null) {
                httpPost.addHeader("upload_id", uploadId);
            }
            if ((httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost)) != null) {
                int n;
                chunkResult.statusCode = n = httpResponse.getStatusLine().getStatusCode();
                if (n >= 200 && n < 300) {
                    JSONObject jSONObject;
                    String string = null;
                    if (httpResponse.getEntity() != null) {
                        try {
                            string = EntityUtilsHC4.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
                            chunkResult.json = jSONObject = new JSONObject(string);
                            Log.d((String)"OP:Communications:", (String)("finishFile: " + jSONObject));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (string == null || string.length() > 3) {
                        // empty if block
                    }
                    if ((jSONObject = httpResponse.getHeaders("Location")) != null && ((Header[])jSONObject).length > 0) {
                        try {
                            String string2 = jSONObject[0].getValue();
                            int n2 = string2.indexOf("/api");
                            if (n2 > 0) {
                                string2 = string2.substring(n2);
                            }
                            chunkResult.json.put("resource_uri", (Object)string2);
                            int n3 = string2.length() - 1;
                            int n4 = string2.substring(0, n3).lastIndexOf("/") + 1;
                            chunkResult.json.put("code", (Object)string2.substring(n4, n3));
                            int n5 = Integer.parseInt(string2.substring(n4, n3));
                            chunkResult.json.put("id", n5);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    return chunkResult;
                }
            } else {
                chunkResult.statusCode = -2;
                return chunkResult;
            }
            String string = "";
            InputStream inputStream = httpResponse.getEntity().getContent();
            chunkResult.error = string = Communications.convertStreamToString(inputStream);
        }
        catch (Exception exception) {
            chunkResult.statusCode = -3;
            chunkResult.error = exception.getLocalizedMessage();
            Log.e((String)"OP:Communications:", (String)("Error running thread:" + exception.getMessage()));
            exception.printStackTrace();
            return chunkResult;
        }
        return chunkResult;
    }

    public static Object postFile(String url, ICommunicationsConfigProvider provider, File file, Object userObject, IMediaPostObserver observer, String resourceUri, boolean published) {
        return Communications.postFile(url, provider, file, userObject, observer, resourceUri, published, false, false);
    }

    public static Object postFile(String url, ICommunicationsConfigProvider provider, File file, Object userObject, IMediaPostObserver observer, String resourceUri, boolean published, boolean avatar) {
        return Communications.postFile(url, provider, file, userObject, observer, resourceUri, published, avatar, false);
    }

    public static Object postFile(String url, ICommunicationsConfigProvider provider, File file, Object userObject, IMediaPostObserver observer, String resourceUri, boolean published, boolean avatar, boolean synchronous) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)10000);
        try {
            FileUploadThread fileUploadThread;
            HttpPost httpPost;
            Uploader uploader = new Uploader();
            uploader.post = httpPost = new HttpPost(url);
            Communications.a((HttpUriRequest)httpPost, provider);
            uploader.thread = fileUploadThread = new FileUploadThread(observer, userObject, (HttpClient)defaultHttpClient, httpPost, file, resourceUri, published, avatar);
            if (synchronous) {
                fileUploadThread.run();
            } else {
                fileUploadThread.start();
            }
            return uploader;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void cancelFile(Object item) {
        if (item == null) {
            return;
        }
        try {
            if (HttpPost.class.isAssignableFrom(item.getClass())) {
                final HttpPost httpPost = (HttpPost)item;
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        httpPost.abort();
                    }
                });
                thread.start();
            } else {
                final Uploader uploader = (Uploader)item;
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        uploader.post.abort();
                    }
                });
                thread.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void getImage(String url, String destination, int id, IImageDownloadObserver observer, int width, int height) {
        try {
            URL uRL = new URL(url);
            ImageDownloadThread imageDownloadThread = new ImageDownloadThread(observer, id, uRL, destination, width, height);
            imageDownloadThread.start();
        }
        catch (Exception exception) {
            if (observer != null) {
                observer.onFail(id, "" + exception.getMessage() + ":" + exception.getCause());
            }
            Log.e((String)"OP:Communications:", (String)("Error getting data:" + exception.getMessage()));
        }
    }

    public static void getArray(String url, ICommunicationsConfigProvider provider, int id, ICommunicationArrayObserver observer) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)10000);
        try {
            HttpGet httpGet = new HttpGet(url);
            Communications.a((HttpUriRequest)httpGet, provider);
            CommunicationsThreadArray communicationsThreadArray = new CommunicationsThreadArray(observer, id, (HttpClient)defaultHttpClient, (HttpUriRequest)httpGet, false);
            communicationsThreadArray.start();
        }
        catch (Exception exception) {
            if (observer != null) {
                observer.onFail(id, "" + exception.getMessage() + ":" + exception.getCause());
            }
            Log.e((String)"OP:Communications:", (String)("Error getting data:" + exception.getMessage()));
            exception.printStackTrace();
        }
    }

    public static void getImage(String url, int id, IImageDownloadObserver observer, int width, int height) {
        Communications.getImage(url, null, id, observer, width, height);
    }

    public static void getData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer) {
        Communications.getData(url, provider, id, observer, false);
    }

    public static void getData(String url, ICommunicationsConfigProvider provider, int id, ICommunicationObserver observer, boolean plain) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)10000);
        try {
            HttpGet httpGet = new HttpGet(url);
            Communications.a((HttpUriRequest)httpGet, provider);
            CommunicationsThread communicationsThread = new CommunicationsThread(observer, id, (HttpClient)defaultHttpClient, (HttpUriRequest)httpGet, plain, null);
            communicationsThread.start();
        }
        catch (Exception exception) {
            if (observer != null) {
                NotifyErrorThread notifyErrorThread = new NotifyErrorThread(id, exception, observer);
                notifyErrorThread.start();
            }
            Log.e((String)"OP:Communications:", (String)("Error getting data:" + exception.getMessage()));
            exception.printStackTrace();
        }
    }

    public static void Test() {
    }

    public static void addGeoData(JSONObject object) {
        try {
            LatLong latLong = Communications.getCurrentGeolocation();
            if (latLong.latitude != 0.0 && latLong.longitude != 0.0) {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                jSONArray.put(latLong.longitude);
                jSONArray.put(latLong.latitude);
                jSONObject.put("type", (Object)"Point");
                jSONObject.put("coordinates", (Object)jSONArray);
                object.put("position", (Object)jSONObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Log.d((String)"GEO:", (String)("addGeoData: " + object));
    }

    static {
        n = new Object();
        o = null;
        a = true;
        lastProvider = "";
        lastSource = "";
        outOfRange = false;
        lastPrecission = Float.MAX_VALUE;
        lastSentPrecission = Float.MAX_VALUE;
        p = new Date(0L);
        q = 0;
        b = 0L;
        c = 0L;
        d = 0L;
    }

    public static class PendingCommunication {
        public static final String RETRIES = "retries";
        public static final String ERROR = "error";
        public static final String BODY = "body";
        public static final String METHOD = "method";
        public static final String NAME = "name";
        public static final String VALUE = "value";
        public static final String HEADERS = "headers";
        public static final String URL = "url";
        public static final String TIMESTAMP = "timestamp";
        public String url;
        public int nRetries;
        public String errorStack;
        public Header[] headers;
        public String body;
        public Method method;
        public long timestamp;

        public PendingCommunication(Method method, String body, Header[] headers, String url) {
            this.nRetries = 0;
            this.errorStack = "";
            this.method = method;
            this.body = body;
            this.headers = headers;
            this.url = url;
            this.timestamp = new Date().getTime();
        }

        public PendingCommunication(JSONObject object) {
            try {
                this.url = object.getString(URL);
                this.nRetries = object.getInt(RETRIES);
                this.errorStack = object.getString(ERROR);
                this.body = object.getString(BODY);
                this.method = Method.valueOf(object.getString(METHOD));
                this.timestamp = object.getLong(TIMESTAMP);
                JSONArray jSONArray = object.getJSONArray(HEADERS);
                if (jSONArray != null && jSONArray.length() > 0) {
                    this.headers = new Header[jSONArray.length()];
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        this.headers[i] = new JsonHeader(jSONArray.getJSONObject(i));
                    }
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }

        public JSONObject serialize() {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put(URL, (Object)this.url);
                jSONObject.put(RETRIES, this.nRetries);
                jSONObject.put(ERROR, (Object)this.errorStack);
                jSONObject.put(BODY, (Object)this.body);
                jSONObject.put(METHOD, (Object)this.method.name());
                jSONObject.put(TIMESTAMP, this.timestamp);
                JSONArray jSONArray = new JSONArray();
                for (Header header : this.headers) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put(NAME, (Object)header.getName());
                    jSONObject2.put(VALUE, (Object)header.getValue());
                    jSONArray.put((Object)jSONObject2);
                }
                jSONObject.put(HEADERS, (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return jSONObject;
        }

        public class JsonHeader
        implements Header {
            private String b;
            private String c;

            public JsonHeader(JSONObject object) {
                try {
                    this.b = object.getString(PendingCommunication.NAME);
                    this.c = object.getString(PendingCommunication.VALUE);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }

            public String getName() {
                return this.b;
            }

            public String getValue() {
                return this.c;
            }

            public HeaderElement[] getElements() throws ParseException {
                return new HeaderElement[0];
            }
        }

        public static enum Method {
            NONE,
            PUT,
            POST,
            GET,
            PATCH;

        }
    }

    public static interface ILocationAlerter {
        public void alertNotEnabled(Activity var1);
    }

    public static interface IMediaPostObserver {
        public void OnFinishedOk(JSONObject var1, Object var2);

        public void OnMediaFailed(String var1, Object var2);

        public void OnProgress(float var1, Object var2);
    }

    public static class FileUploadThread
    extends Thread {
        private IMediaPostObserver b;
        private Object c;
        private HttpPost d;
        private HttpClient e;
        private File f;
        private String g;
        private boolean h;
        private boolean i;

        public FileUploadThread(IMediaPostObserver observer, Object userObject, HttpClient client, HttpPost request, File file, String resourceUri, boolean published, boolean avatar) {
            assert (request != null);
            assert (client != null);
            this.b = observer;
            this.c = userObject;
            this.e = client;
            this.d = request;
            this.f = file;
            this.g = resourceUri;
            this.h = published;
            this.i = avatar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                try {
                    Integer n;
                    File file = this.f;
                    MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                    multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                    multipartEntityBuilder.addPart("Title", (ContentBody)new StringBody("Title"));
                    multipartEntityBuilder.addBinaryBody(this.i ? "avatar" : "file", file);
                    if (this.g != null && this.g.length() > 2) {
                        multipartEntityBuilder.addPart("news", (ContentBody)new StringBody(this.g));
                    }
                    if (!this.h) {
                        n = 0;
                        multipartEntityBuilder.addPart("published", (ContentBody)new StringBody("false"));
                    }
                    n = multipartEntityBuilder.build();
                    class A
                    implements HttpEntity {
                        final /* synthetic */ HttpEntity a;
                        final /* synthetic */ File b;

                        A() {
                            this.a = httpEntity;
                            this.b = file;
                        }

                        public void consumeContent() throws IOException {
                            this.a.consumeContent();
                        }

                        public InputStream getContent() throws IOException, IllegalStateException {
                            return this.a.getContent();
                        }

                        public Header getContentEncoding() {
                            return this.a.getContentEncoding();
                        }

                        public long getContentLength() {
                            return this.a.getContentLength();
                        }

                        public Header getContentType() {
                            return this.a.getContentType();
                        }

                        public boolean isChunked() {
                            return this.a.isChunked();
                        }

                        public boolean isRepeatable() {
                            return this.a.isRepeatable();
                        }

                        public boolean isStreaming() {
                            return this.a.isStreaming();
                        }

                        public void writeTo(OutputStream outStream) throws IOException {
                            class A
                            extends a.b {
                                long a;

                                public A(OutputStream outputStream) {
                                    class B
                                    extends FilterOutputStream {
                                        public B(OutputStream outputStream) {
                                            super(outputStream);
                                        }

                                        @Override
                                        public void write(int idx) throws IOException {
                                            this.out.write(idx);
                                        }

                                        @Override
                                        public void write(byte[] bts) throws IOException {
                                            this.out.write(bts);
                                        }

                                        @Override
                                        public void write(byte[] bts, int st, int end) throws IOException {
                                            this.out.write(bts, st, end);
                                        }

                                        @Override
                                        public void flush() throws IOException {
                                            this.out.flush();
                                        }

                                        @Override
                                        public void close() throws IOException {
                                            this.out.close();
                                        }
                                    }
                                    super(outputStream);
                                    this.a = 0L;
                                }

                                @Override
                                public void write(byte[] buffer, int offset, int count) throws IOException {
                                    this.a += (long)count;
                                    if (FileUploadThread.this.b != null) {
                                        try {
                                            long l = b.length();
                                            if (l > 0L) {
                                                float f = 100.0f * (float)this.a / (float)l;
                                                FileUploadThread.this.b.OnProgress(f, FileUploadThread.this.c);
                                            }
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                    this.out.write(buffer, offset, count);
                                }
                            }
                            this.a.writeTo((OutputStream)new A(outStream));
                        }
                    }
                    A a2 = new A();
                    this.d.setEntity((HttpEntity)a2);
                    this.d.removeHeaders("Content-Type");
                    this.d.addHeader(n.getContentType());
                    HttpResponse httpResponse = this.e.execute((HttpUriRequest)this.d);
                    if (httpResponse != null) {
                        if (this.b == null) break block15;
                        int n2 = httpResponse.getStatusLine().getStatusCode();
                        if (n2 >= 200 && n2 < 300) {
                            JSONObject jSONObject = new JSONObject();
                            Header[] headerArray = httpResponse.getHeaders("Location");
                            if (headerArray != null && headerArray.length > 0) {
                                try {
                                    String string = headerArray[0].getValue();
                                    int n3 = string.indexOf("/api");
                                    if (n3 > 0) {
                                        string = string.substring(n3);
                                    }
                                    jSONObject.put("resource_uri", (Object)string);
                                    int n4 = string.length() - 1;
                                    int n5 = string.substring(0, n4).lastIndexOf("/") + 1;
                                    jSONObject.put("code", (Object)string.substring(n5, n4));
                                    int n6 = Integer.parseInt(string.substring(n5, n4));
                                    jSONObject.put("id", n6);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            this.b.OnFinishedOk(jSONObject, this.c);
                            break block15;
                        }
                        String string = "";
                        InputStream inputStream = httpResponse.getEntity().getContent();
                        string = Communications.convertStreamToString(inputStream);
                        this.b.OnMediaFailed("" + n2 + ":" + string, this.c);
                        break block15;
                    }
                    if (this.b != null) {
                        this.b.OnMediaFailed("no response", this.c);
                    }
                }
                catch (Exception exception) {
                    if (this.b != null) {
                        this.b.OnMediaFailed("e:" + exception.getMessage(), this.c);
                    }
                    Log.e((String)"OP:FUThread:", (String)("Error running thread:" + exception.getMessage()));
                    exception.printStackTrace();
                }
                finally {
                    this.b = null;
                }
            }
        }
    }

    public static class CommunicationsThreadArray
    extends Thread {
        private ICommunicationArrayObserver b;
        private int c;
        private HttpUriRequest d;
        private HttpClient e;
        private boolean f = false;

        public CommunicationsThreadArray(ICommunicationArrayObserver observer, int id, HttpClient client, HttpUriRequest request, boolean plain) {
            assert (request != null);
            assert (client != null);
            this.b = observer;
            this.c = id;
            this.e = client;
            this.d = request;
            this.f = plain;
        }

        @Override
        public void run() {
            block11: {
                try {
                    Date date = new Date();
                    HttpResponse httpResponse = this.e.execute(this.d);
                    Date date2 = new Date();
                    int n = 0;
                    if (httpResponse != null) {
                        n = httpResponse.getStatusLine().getStatusCode();
                    }
                    Log.i((String)"OP:ComThread:", (String)("T:" + (date2.getTime() - date.getTime()) + " for :" + this.d.getURI() + " C:" + n));
                    if (httpResponse != null) {
                        if (this.b == null) break block11;
                        int n2 = httpResponse.getStatusLine().getStatusCode();
                        if (n2 >= 200 && n2 < 300) {
                            String string = null;
                            if (httpResponse.getEntity() != null) {
                                try {
                                    string = EntityUtilsHC4.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            JSONArray jSONArray = string != null && string.length() > 3 ? new JSONArray(string) : new JSONArray();
                            Log.i((String)"ccc", (String)"received ");
                            this.b.onSuccess(this.c, jSONArray);
                            break block11;
                        }
                        String string = "";
                        if (httpResponse.getEntity() != null) {
                            InputStream inputStream = httpResponse.getEntity().getContent();
                            string = Communications.convertStreamToString(inputStream);
                        }
                        this.b.onFail(this.c, "" + n2 + ":" + string);
                        break block11;
                    }
                    if (this.b != null) {
                        this.b.onFail(this.c, "No response");
                    }
                }
                catch (Exception exception) {
                    if (this.b != null) {
                        this.b.onFail(this.c, "" + exception.getMessage() + ":" + exception.getCause());
                    }
                    Log.e((String)"OP:ComThread:", (String)("Error running thread:" + exception.getMessage()));
                    exception.printStackTrace();
                }
            }
        }
    }

    public static class CommunicationsThread
    extends Thread {
        private ICommunicationObserver b;
        private int c;
        private HttpUriRequest d;
        private HttpClient e;
        private boolean f = false;
        private PendingCommunication g = null;

        public CommunicationsThread(ICommunicationObserver observer, int id, HttpClient client, HttpUriRequest request, boolean plain, PendingCommunication pending) {
            assert (request != null);
            assert (client != null);
            this.b = observer;
            this.c = id;
            this.e = client;
            this.d = request;
            this.f = plain;
            this.g = pending;
        }

        @Override
        public void run() {
            block23: {
                try {
                    Date date = new Date();
                    HttpResponse httpResponse = this.e.execute(this.d);
                    Date date2 = new Date();
                    int n = 0;
                    if (httpResponse != null) {
                        n = httpResponse.getStatusLine().getStatusCode();
                    }
                    long l = date2.getTime() - date.getTime();
                    Log.i((String)"OP:ComThread:", (String)("T:" + l + " for :" + this.d.getURI() + " C:" + n));
                    if (httpResponse != null) {
                        if (this.b == null) break block23;
                        int n2 = httpResponse.getStatusLine().getStatusCode();
                        if (n2 >= 200 && n2 < 300) {
                            JSONObject jSONObject;
                            String string = null;
                            if (httpResponse.getEntity() != null) {
                                try {
                                    date = new Date();
                                    string = EntityUtilsHC4.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
                                    date2 = new Date();
                                    Log.i((String)"OP:ComThread:", (String)("T:" + (date2.getTime() - date.getTime()) + " for reading"));
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            if (this.f) {
                                jSONObject = new JSONObject();
                                for (String string2 : string.split("&")) {
                                    String[] stringArray = string2.split("=");
                                    if (stringArray.length != 2) continue;
                                    jSONObject.put(stringArray[0], (Object)stringArray[1]);
                                }
                            } else if (string != null && string.length() > 3) {
                                try {
                                    date = new Date();
                                    jSONObject = new JSONObject(string);
                                    date2 = new Date();
                                    Log.i((String)"OP:ComThread:", (String)("T:" + (date2.getTime() - date.getTime()) + " for json parsing"));
                                }
                                catch (Exception exception) {
                                    if (this.b != null) {
                                        this.b.onFail(this.c, "BAD JSON RESPONSE:(" + string + ")" + exception.getMessage(), this.g);
                                    }
                                    exception.printStackTrace();
                                    jSONObject = new JSONObject();
                                }
                            } else {
                                jSONObject = new JSONObject();
                            }
                            Log.i((String)"ccc", (String)"received ");
                            this.b.onSuccess(this.c, jSONObject);
                            break block23;
                        }
                        String string = "";
                        if (httpResponse.getEntity() != null) {
                            Header[] headerArray = httpResponse.getEntity().getContent();
                            string = Communications.convertStreamToString((InputStream)headerArray);
                        }
                        try {
                            if (n2 == 401) {
                                string = string + " T:" + l + " for :" + this.d.getMethod() + " " + this.d.getURI() + " \nH:";
                                for (Header header : this.d.getAllHeaders()) {
                                    string = string + "(" + header.getName() + "," + header.getValue() + ")";
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        this.b.onFail(this.c, "" + n2 + ":" + string, this.g);
                        this.a(this.d.getAllHeaders());
                        break block23;
                    }
                    if (this.b != null) {
                        this.b.onFail(this.c, "No response", this.g);
                    }
                }
                catch (Exception exception) {
                    if (this.b != null) {
                        this.b.onFail(this.c, "" + exception.getMessage() + ":" + exception.getCause(), this.g);
                    }
                    Log.e((String)"OP:ComThread:", (String)("Error running thread:" + exception.getMessage()));
                    exception.printStackTrace();
                }
            }
        }

        private void a(Header[] headerArray) {
            String string = "Headers[";
            for (Header header : headerArray) {
                string = string + "(" + header.getName() + "," + header.getValue() + ")";
            }
            Log.w((String)"OP:ComThread:", (String)(string + "]"));
        }
    }

    public static class NotifyErrorThread
    extends Thread {
        Exception a;
        ICommunicationObserver b;
        int c;

        public NotifyErrorThread(int id, Exception e, ICommunicationObserver observer) {
            this.a = e;
            this.b = observer;
            this.c = id;
        }

        @Override
        public void run() {
            super.run();
            try {
                if (this.b != null) {
                    this.b.onFail(this.c, "" + this.a.getMessage() + ":" + this.a.getCause(), null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static class Uploader {
        public HttpPost post;
        public FileUploadThread thread;
    }

    public static class ChunkResult {
        public int statusCode;
        public JSONObject json;
        public String error;
        public String uploadId;
    }

    public static interface IChunkObserver {
        public void onProgress(float var1);
    }

    public static class LatLong {
        public double latitude;
        public double longitude;

        public LatLong() {
        }

        public LatLong(double lat, double longit) {
            this.latitude = lat;
            this.longitude = longit;
        }
    }

    public static interface ICommunicationsConfigProvider {
        public String getPushCode();

        public String getGeostatsUrlFormat();

        public void onGeostatSent(boolean var1, String var2);

        public ArrayList<CHeader> getHeaders();
    }

    public static class CHeader {
        String a;
        String b;

        public CHeader(String name, String value) {
            this.a = name;
            this.b = value;
        }
    }
}

