/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.communications;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.util.Log;
import com.tendarts.sdk.common.ConnectionManager;
import com.tendarts.sdk.communications.PendingCommunicationsService;

public class NetworkChangeReceiver
extends BroadcastReceiver {
    private static NetworkChangeReceiver a = null;

    public static void enable(Context context) {
        ComponentName componentName = new ComponentName(context, NetworkChangeReceiver.class);
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null) {
            packageManager.setComponentEnabledSetting(componentName, 1, 1);
            try {
                a = new NetworkChangeReceiver();
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                context.getApplicationContext().registerReceiver((BroadcastReceiver)a, intentFilter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Log.e((String)"NetworkChangeReceiver", (String)"could not enable package manager");
        }
    }

    public static void disable(Context context) {
        ComponentName componentName = new ComponentName(context, NetworkChangeReceiver.class);
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null) {
            packageManager.setComponentEnabledSetting(componentName, 2, 1);
        } else {
            Log.e((String)"NetworkChangeReceiver", (String)"could not disable package manager");
        }
        try {
            context.getApplicationContext().unregisterReceiver((BroadcastReceiver)a);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onReceive(Context context, Intent intent) {
        Log.d((String)"NetworkChangeReceiver", (String)"Network change received");
        if (ConnectionManager.isConnected(context)) {
            PendingCommunicationsService.startPendingCommunications(context);
            NetworkChangeReceiver.disable(context);
        }
    }
}

