/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.communications;

import android.app.AlarmManager;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tendarts.sdk.common.PendingCommunicationController;
import com.tendarts.sdk.communications.Communications;

public class PendingCommunicationsService
extends IntentService {
    public static final String TAG = "PendingCommunicationsS";
    private static String a = "com.tendarts.sdk.CONTINUE_PENDING_COMMUNICATIONS";

    public PendingCommunicationsService() {
        super("PendingCommunicationsService");
    }

    public PendingCommunicationsService(String name) {
        super(name);
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        Log.d((String)TAG, (String)"onHandleIntent: ");
        PendingCommunicationController.doPending(this.getApplicationContext());
    }

    public void onTaskRemoved(Intent rootIntent) {
        Log.d((String)TAG, (String)"onTaskRemoved: scheduling");
        PendingCommunicationsService.schedulePending(60000L, this.getApplicationContext());
        super.onTaskRemoved(rootIntent);
    }

    public static void schedulePending(long milliseconds, Context context) {
        Intent intent = new Intent(context, PendingCommunicationsService.class);
        intent.setPackage(context.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)1, (Intent)intent, (int)0x40000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        alarmManager.set(3, SystemClock.elapsedRealtime() + milliseconds, pendingIntent);
        Log.d((String)TAG, (String)("scheluded " + (float)milliseconds / 1000.0f));
    }

    public static void startPendingCommunications(Context context) {
        Log.d((String)TAG, (String)"startPendingCommunications: ");
        Communications.init(context);
        Intent intent = new Intent(context, PendingCommunicationsService.class);
        intent.setAction(a);
        context.startService(intent);
    }
}

