/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.gcm;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.util.Log;
import android.widget.RemoteViews;
import com.google.android.gms.gcm.GcmListenerService;
import com.tendarts.sdk.Model.Notification;
import com.tendarts.sdk.Model.PersistentPush;
import com.tendarts.sdk.TendartsSDK;
import com.tendarts.sdk.client.INotifications;
import com.tendarts.sdk.client.TendartsClient;
import com.tendarts.sdk.common.Configuration;
import com.tendarts.sdk.common.PendingCommunicationController;
import com.tendarts.sdk.common.PushController;
import com.tendarts.sdk.common.Util;
import com.tendarts.sdk.communications.Communications;
import com.tendarts.sdk.communications.ICommunicationObserver;
import com.tendarts.sdk.communications.IImageDownloadObserver;
import com.tendarts.sdk.gcm.DartsReceiver;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.json.JSONObject;

public class GCMListenerService
extends GcmListenerService {
    public static int not_id = 5525;
    static INotifications.IBackgroundCustomNotificationLoaderListener a;

    public void onMessageReceived(String from, Bundle data) {
        Object object = this.getApplicationContext();
        if (object == null) {
            object = this;
        }
        TendartsSDK.instance();
        TendartsSDK.initCommunications(object);
        super.onMessageReceived(from, data);
        Log.i((String)"GCM Listener", (String)("Message received:" + from));
        Util.printExtras("GCM Listener", data);
        if (Configuration.getAccessToken(object) == null) {
            Log.d((String)"GCM Listener", (String)"onMessageReceived: sdk not configured");
            return;
        }
        Bundle bundle = data;
        try {
            try {
                String string = bundle.getString("id");
                String string2 = bundle.getString("cfm");
                int n = 0;
                n = "1".equalsIgnoreCase(string2) ? 1 : bundle.getInt("cfm");
                String string3 = bundle.getString("org");
                if (!"10d".equals(string3)) {
                    TendartsClient.instance(this.getApplicationContext()).remoteLogException(new Exception("invalid origin received: " + string3));
                    return;
                }
                try {
                    TendartsClient.instance(object, this.getApplicationInfo()).logEvent("Push", "received", bundle.getString("message"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Log.d((String)"GCM Listener", (String)(string2 + " " + n));
                if (string != null && n == 1) {
                    String string4 = null;
                    string4 = Util.getDeviceJson(object);
                    if (string4 != null) {
                        Object object2 = object;
                        Communications.patchData(String.format("https://10darts.com/api/v1/pushes/%s/received/", string), Util.getProvider(), 0, new ICommunicationObserver((Context)object2, string){
                            final /* synthetic */ Context a;
                            final /* synthetic */ String b;
                            {
                                this.a = context;
                                this.b = string;
                            }

                            @Override
                            public void onSuccess(int operationId, JSONObject data) {
                                TendartsClient.instance(this.a).logEvent("PUSH", "push received successfully reported", "");
                                Log.i((String)"GCM Listener", (String)"push rcv reported");
                            }

                            @Override
                            public void onFail(int operationId, String reason, Communications.PendingCommunication pending) {
                                Util.checkUnauthorized(reason, GCMListenerService.this.getApplicationContext());
                                TendartsClient.instance(this.a).logEvent("PUSH", "push received report can't send:", "" + reason);
                                if (reason != null && reason.contains("400")) {
                                    TendartsClient.instance(this.a).logEvent("PUSH", "push received send 400:", "" + reason + " duplicate: sent id:" + this.b + " stored id's:" + PersistentPush.getAllIds(this.a));
                                } else {
                                    PendingCommunicationController.addPending(pending, GCMListenerService.this.getApplicationContext());
                                }
                                Log.w((String)"GCM Listener", (String)("push rcv failed: " + reason));
                            }
                        }, string4, false);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.postNotification((Context)object, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void postNotification(final Context context, Bundle extras) {
        try {
            int n = 0;
            if (extras.containsKey("badge")) {
                Log.d((String)"GCM Listener", (String)"postNotification: new badge");
                n = Integer.parseInt(extras.getString("badge"));
                Util.setBadgeCount(n, context);
            } else {
                Log.d((String)"GCM Listener", (String)"postNotification: no badge");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            int n;
            String string;
            block36: {
                string = extras.getString("message").trim();
                try {
                    if (Configuration.instance(context.getApplicationContext()).getNotificationsEnabled()) break block36;
                    try {
                        TendartsClient.instance(context).logEvent("Push", "config_disabled", "" + string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            TendartsClient.instance(context).onNotificationReceived(this.buildPushFromBundle(extras));
            final NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (string == null || string.length() < 1) {
                try {
                    Log.e((String)"GCM Listener", (String)"null message...");
                    TendartsClient.instance(context).logEvent("Push", "no_message", "" + extras.getString("id"));
                    StringBuilder stringBuilder = new StringBuilder("Extras: ");
                    for (String string2 : extras.keySet()) {
                        Object object = extras.get(string2);
                        stringBuilder.append(string2).append(": ").append(object).append(";");
                    }
                    TendartsClient.instance(context).logEvent("Push", "all_no_message", stringBuilder.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            final String string3 = string;
            String string4 = extras.getString("title");
            if ((string4 == null || string4.length() < 1) && (n = string.indexOf(":")) > 0 && n < string.length() - 2) {
                string4 = string.substring(0, n + 1);
                string = string.substring(n + 1);
            }
            final Notification notification = this.buildPushFromBundle(extras);
            boolean bl = false;
            if (PersistentPush.alreadyContains(notification, context)) {
                bl = true;
                Log.d((String)"GCM Listener", (String)"postNotification: pust already contained");
            }
            final ArrayList<Notification> arrayList = PersistentPush.getStored(context);
            if (!(!TendartsSDK.instance().getAlwaysSowLastNotification() && TendartsSDK.instance().getStackNotifications() || bl)) {
                PendingIntent pendingIntent = PersistentPush.buildPendingIntent(notification, context, true);
                if (pendingIntent == null) {
                    try {
                        TendartsClient.instance(context).logEvent("Push", "no_build_intent", "" + notification);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return;
                }
                boolean bl2 = false;
                Calendar calendar = Calendar.getInstance();
                int n2 = calendar.get(11);
                if (!TendartsSDK.instance().getLimitNotificationSoundAndVibrationTime()) {
                    bl2 = true;
                } else if (n2 >= TendartsSDK.instance().getNotificationSoundAndVibrationFirstHour() && n2 < TendartsSDK.instance().getNotificationSoundAndVibrationLastHour()) {
                    bl2 = true;
                }
                Log.d((String)"GCM Listener", (String)("postNotification: sound in notification:" + bl2));
                int n3 = Color.parseColor((String)"#000000");
                try {
                    n3 = context.getResources().getColor(TendartsSDK.instance().getNotificationColorResource());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                final NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setColor(n3).setSmallIcon(TendartsSDK.instance().getSmallIconResource()).setContentTitle((CharSequence)string4).setContentText((CharSequence)string).setContentIntent(pendingIntent).setAutoCancel(true).setLargeIcon(TendartsSDK.instance().getLargeIcon(context)).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string)).setExtras(extras);
                if (Build.VERSION.SDK_INT >= 21) {
                    builder.setVisibility(1);
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    builder.setPriority(1);
                }
                if (bl2) {
                    builder.setVibrate(new long[]{1000L, 1000L, 1000L, 1000L, 1000L}).setDefaults(1);
                } else {
                    builder.setVibrate(new long[]{0L});
                }
                final android.app.Notification notification2 = builder.build();
                RemoteViews remoteViews = TendartsClient.instance(context).getCustomNotificationSmallView(notification, context);
                RemoteViews remoteViews2 = TendartsClient.instance(context).getCustomNotificationLargeView(notification, context);
                if (remoteViews != null) {
                    a = new a(context, notificationManager, builder, notification2, remoteViews, remoteViews2, notification);
                    TendartsClient.instance(context).loadBackgroundCustomNotificationData(a, notification, remoteViews, remoteViews2, context);
                } else {
                    Log.i((String)"GCM Listener", (String)"new push notification posted");
                    if (notification.hasImage(context)) {
                        final String string5 = string;
                        final String string6 = string4;
                        final boolean bl3 = bl;
                        Communications.getImage(notification.getThumbnail(), 0, new IImageDownloadObserver(){

                            @Override
                            public void onSuccess(int operationId, Bitmap data) {
                                builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(data).setBigContentTitle((CharSequence)string6).setSummaryText((CharSequence)string5));
                                android.app.Notification notification3 = builder.build();
                                notificationManager.notify(PushController.getNotificationId(notification), notification3);
                                GCMListenerService.this.a(string3, notification);
                                if (arrayList.size() > 1 && TendartsSDK.instance().getStackNotifications() && !bl3) {
                                    GCMListenerService.notifyList(context, notificationManager, notification, arrayList);
                                }
                            }

                            @Override
                            public void onFail(int operationId, String reason) {
                                notificationManager.notify(PushController.getNotificationId(notification), notification2);
                                GCMListenerService.this.a(string3, notification);
                                if (arrayList.size() > 1 && TendartsSDK.instance().getStackNotifications() && !bl3) {
                                    GCMListenerService.notifyList(context, notificationManager, notification, arrayList);
                                }
                            }
                        }, 1024, 1024);
                    } else {
                        notificationManager.notify(PushController.getNotificationId(notification), notification2);
                        this.a(string3, notification);
                        if (arrayList.size() > 1 && TendartsSDK.instance().getStackNotifications() && !bl) {
                            GCMListenerService.notifyList(context, notificationManager, notification, arrayList);
                        }
                    }
                }
            }
            PersistentPush.addPush(notification, context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                TendartsClient.instance(this.getApplicationContext(), this.getApplicationInfo()).logEvent("Push", "main_exception", "" + exception.getMessage());
                TendartsClient.instance(this.getApplicationContext(), this.getApplicationInfo()).remoteLogException(exception);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    private void a(String string, Notification notification) {
        try {
            TendartsClient.instance(this.getApplicationContext(), this.getApplicationInfo()).logEvent("Push", "showed_alone", "" + string);
            TendartsClient.instance(this.getApplicationContext(), this.getApplicationInfo()).onNotificationShowed(notification);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @NonNull
    public Notification buildPushFromBundle(Bundle extras) {
        int n;
        String string = extras.getString("message").trim();
        String string2 = extras.getString("title");
        if ((string2 == null || string2.length() < 1) && (n = string.indexOf(":")) > 0 && n < string.length() - 2) {
            string2 = string.substring(0, n + 1);
            string = string.substring(n + 1);
        }
        Notification notification = new Notification(string2, string);
        try {
            for (String string3 : extras.keySet()) {
                try {
                    String string4 = extras.getString(string3);
                    notification.putExtra(string3, string4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return notification;
    }

    public static void notifyList(Context context, NotificationManager mNotificationManager, Notification push, List<Notification> pushes) {
        try {
            Log.d((String)"GCM Listener", (String)"notifyList");
            if (pushes.size() < 1) {
                return;
            }
            Intent intent = new Intent(context, DartsReceiver.class);
            intent.setAction("com.darts.SDK.OPEN_LIST");
            intent.putExtra("dismiss", not_id);
            Configuration.instance(context);
            String string = Configuration.getAccessToken(context);
            if (string == null) {
                Log.d((String)"GCM Listener", (String)"notifyList: not access token");
                return;
            }
            intent.putExtra("sorg", string.hashCode());
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)12345, (Intent)intent, (int)0x8000000);
            Intent intent2 = new Intent(context, DartsReceiver.class);
            intent2.setAction("com.darts.SDK.CLEAR_PUSHES");
            intent2.putExtra("dismiss", not_id);
            Configuration.instance(context);
            intent2.putExtra("sorg", Configuration.getAccessToken(context).hashCode());
            PendingIntent pendingIntent2 = PendingIntent.getBroadcast((Context)context, (int)12345, (Intent)intent2, (int)0x8000000);
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setColor(context.getResources().getColor(TendartsSDK.instance().getNotificationColorResource())).setContentTitle(TendartsSDK.instance().getStackedNotificationTitle()).setContentText((CharSequence)TendartsSDK.instance().getStackedNotificationContent(pushes.size())).setContentIntent(pendingIntent).setSmallIcon(TendartsSDK.instance().getSmallIconResource()).setVibrate(new long[]{0L}).addAction(TendartsSDK.instance().getViewStackedIconResource(), TendartsSDK.instance().getViewStackedString(), pendingIntent).addAction(TendartsSDK.instance().getCancelStackedIconResource(), TendartsSDK.instance().getCancelStackedString(), pendingIntent2);
            if (Build.VERSION.SDK_INT >= 21) {
                builder.setVisibility(1);
            }
            if (Build.VERSION.SDK_INT >= 16) {
                builder.setPriority(0);
            }
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle(builder);
            int n = 0;
            for (Notification notification : pushes) {
                if (n == 0) {
                    ++n;
                    continue;
                }
                SpannableString spannableString = GCMListenerService.a(notification);
                inboxStyle.addLine((CharSequence)spannableString);
                if (++n <= 5) continue;
                break;
            }
            if (n < 5 && push != null) {
                inboxStyle.addLine((CharSequence)GCMListenerService.a(push));
            } else {
                inboxStyle.setSummaryText((CharSequence)("+" + (pushes.size() - n + 1)));
            }
            android.app.Notification notification = inboxStyle.build();
            notification.flags |= 0x10;
            mNotificationManager.notify(not_id, notification);
            try {
                if (push != null) {
                    TendartsClient.instance(context).logEvent("Push", "showed_list", "" + push.getFullText());
                    TendartsClient.instance(context).onNotificationShowedInList(push);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                TendartsClient.instance(context).logEvent("Push", "show_list_exc", "" + exception.getMessage());
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    @NonNull
    private static SpannableString a(Notification notification) {
        String string = "\u2022 ";
        int n = 2;
        if (notification.title != null && notification.title.length() < 15) {
            string = string + notification.title.trim() + " ";
            n = string.length();
        }
        SpannableString spannableString = new SpannableString((CharSequence)(string + notification.message.trim()));
        spannableString.setSpan((Object)new StyleSpan(1), 0, n, 33);
        return spannableString;
    }

    private class a
    implements INotifications.IBackgroundCustomNotificationLoaderListener {
        Context a;
        NotificationManager b;
        NotificationCompat.Builder c;
        android.app.Notification d;
        RemoteViews e;
        RemoteViews f;
        Notification g;

        public a(Context context, NotificationManager notificationManager, NotificationCompat.Builder builder, android.app.Notification notification, RemoteViews remoteViews, RemoteViews remoteViews2, Notification notification2) {
            this.a = context;
            this.b = notificationManager;
            this.c = builder;
            this.d = notification;
            this.e = remoteViews;
            this.f = remoteViews2;
            this.g = notification2;
        }

        @Override
        public void revertToStandardNotification() {
            ArrayList<Notification> arrayList = PersistentPush.getStored(GCMListenerService.this.getApplicationContext());
            if (!TendartsSDK.instance().getStackNotifications() || TendartsSDK.instance().getAlwaysSowLastNotification()) {
                this.b.notify(PushController.getNotificationId(this.g), this.d);
            }
            if (arrayList.size() > 1 && TendartsSDK.instance().getStackNotifications()) {
                GCMListenerService.notifyList(this.a, this.b, null, arrayList);
            }
            PersistentPush.save(this.a);
            a = null;
        }

        @Override
        public void customNotificationsReady(Bitmap bitmap) {
            ArrayList<Notification> arrayList = PersistentPush.getStored(this.a);
            try {
                if (this.e != null) {
                    this.c.setContent(this.e);
                }
                if (this.f != null) {
                    this.c.setCustomBigContentView(this.f);
                }
                this.b.notify(PushController.getNotificationId(this.g), this.c.setLargeIcon(bitmap).build());
                TendartsClient.instance(this.a).onNotificationShowed(this.g);
                PersistentPush.save(this.a);
                if (arrayList.size() > 1 && TendartsSDK.instance().getStackNotifications()) {
                    GCMListenerService.notifyList(this.a, this.b, null, arrayList);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            a = null;
        }
    }
}

