/*
 * Decompiled with CFR 0.152.
 */
package com.tendarts.sdk.geo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.tendarts.sdk.TendartsSDK;
import com.tendarts.sdk.client.TendartsClient;
import com.tendarts.sdk.communications.Communications;
import java.lang.ref.WeakReference;

public class GoogleUpdates
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    GoogleApiClient a;
    LocationRequest b;
    WeakReference<Activity> c;
    public boolean asking = false;

    public GoogleUpdates(Context context, Activity activity) {
        this.c = new WeakReference<Activity>(activity);
        this.a = new GoogleApiClient.Builder(context.getApplicationContext()).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).build();
    }

    public void onStart() {
        try {
            Log.d((String)"GU", (String)"onStart: ");
            if (this.a != null) {
                this.a.connect();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onStop() {
        try {
            Log.d((String)"GU", (String)"onStop: ");
            if (this.a != null) {
                this.a.disconnect();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onResume() {
        try {
            Log.d((String)"GU", (String)"onResume: ");
            if (this.a != null && this.a.isConnected()) {
                this.startLocationUpdates();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onLocationChanged(Location location) {
        Log.d((String)"GU", (String)"onLocationChanged: ");
        if (location != null) {
            float f = location.getAccuracy();
            Communications.lastProvider = location.getProvider();
            Communications.lastSource = "Service";
            Communications.lastPrecission = f;
            if (f != 0.0f && f < 1500.0f) {
                Communications.outOfRange = false;
                Communications.setGeolocation(location.getLatitude(), location.getLongitude());
            } else {
                Communications.outOfRange = true;
            }
            TendartsSDK.onNewLocation();
        }
    }

    public void onConnectionSuspended(int i) {
        Log.d((String)"GU", (String)("onConnectionSuspended: " + i));
    }

    public void onConnected(Bundle bundle) {
        Log.d((String)"GU", (String)"onConnected: ");
        this.startLocationUpdates();
    }

    public void startLocationUpdates() {
        this.startLocationUpdates(true);
    }

    public void startLocationUpdates(boolean askForPermissions) {
        this.getLocationUpdates(askForPermissions, true);
    }

    public void getLocationUpdates(boolean askForPermissions, boolean start) {
        Location location;
        try {
            Log.d((String)"GU", (String)("getLocationUpdates, ask:" + askForPermissions + ", start:" + start));
            location = LocationServices.FusedLocationApi.getLastLocation(this.a);
            if (location != null) {
                float f = location.getAccuracy();
                Communications.lastProvider = location.getProvider();
                Communications.lastSource = "LastLocation";
                Communications.lastPrecission = f;
                if (f != 0.0f && f < 1500.0f) {
                    Communications.outOfRange = false;
                    Communications.setGeolocation(location.getLatitude(), location.getLongitude());
                } else {
                    Communications.outOfRange = true;
                }
                TendartsSDK.onNewLocation();
            }
            if (this.b == null) {
                this.b = new LocationRequest();
                this.b.setInterval(120000L);
                this.b.setFastestInterval(20000L);
                this.b.setPriority(102);
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (Build.VERSION.SDK_INT > 22 && askForPermissions && !this.asking) {
            location = null;
            if (this.c != null) {
                location = (Activity)this.c.get();
            }
            Location location2 = location;
            assert (location2 != null);
            try {
                this.asking = true;
                if (ContextCompat.checkSelfPermission((Context)location, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && location2 != null) {
                    if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)location, (String)"android.permission.ACCESS_FINE_LOCATION")) {
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)location);
                        builder.setMessage(TendartsClient.instance(location.getApplicationContext()).getLocationExplanation(location.getApplicationContext()));
                        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener((Activity)location2){
                            final /* synthetic */ Activity a;
                            {
                                this.a = activity;
                            }

                            public void onClick(DialogInterface dialog, int id) {
                                ActivityCompat.requestPermissions((Activity)this.a, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)333);
                                GoogleUpdates.this.asking = false;
                            }
                        });
                        builder.setNegativeButton(17039369, new DialogInterface.OnClickListener((Activity)location2){
                            final /* synthetic */ Activity a;
                            {
                                this.a = activity;
                            }

                            public void onClick(DialogInterface dialog, int id) {
                                GoogleUpdates.this.asking = false;
                                dialog.dismiss();
                                TendartsClient.instance((Context)this.a).onUserRejectedLocationPermission();
                            }
                        });
                        AlertDialog alertDialog = builder.create();
                        alertDialog.show();
                    } else {
                        this.asking = true;
                        ActivityCompat.requestPermissions((Activity)location, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)333);
                    }
                } else {
                    this.asking = false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.asking = false;
            }
        }
        if (start) {
            try {
                LocationServices.FusedLocationApi.requestLocationUpdates(this.a, this.b, (LocationListener)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        Log.d((String)"GU", (String)("onConnectionFailed: " + connectionResult));
        Log.w((String)"GU", (String)("google connection failed:" + connectionResult.getErrorMessage()));
    }

    public void onPause() {
        try {
            if (this.a != null && this.a.isConnected()) {
                LocationServices.FusedLocationApi.removeLocationUpdates(this.a, (LocationListener)this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onDestroy() {
        Log.d((String)"GU", (String)"onDestroy: ");
        if (this.a != null) {
            try {
                this.a.unregisterConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this);
                this.a.unregisterConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this);
                if (this.a.isConnected()) {
                    LocationServices.FusedLocationApi.removeLocationUpdates(this.a, (LocationListener)this);
                    this.a.disconnect();
                }
                this.a = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

